/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.GlobalOrdinalMapping;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;

public class GlobalOrdinalsFieldData {
    private final Atomic[] atomicReaders;
    private SortedDocValues[] segmentSdv;

    public GlobalOrdinalsFieldData(String fieldName, SortedDocValues[] segmentSdv, OrdinalMap ordinalMap, long memorySizeInBytes) {
        this.segmentSdv = segmentSdv;
        this.atomicReaders = new Atomic[segmentSdv.length];
        for (int i = 0; i < segmentSdv.length; ++i) {
            this.atomicReaders[i] = new Atomic(segmentSdv[i], ordinalMap, i);
        }
    }

    public SortedDocValues getOrdinalsValues(LeafReaderContext context) {
        return this.atomicReaders[context.ord].getOrdinalsValues();
    }

    private final class Atomic {
        private final SortedDocValues sdv;
        private final OrdinalMap ordinalMap;
        private final int segmentIndex;

        private Atomic(SortedDocValues sdv, OrdinalMap ordinalMap, int segmentIndex) {
            this.sdv = sdv;
            this.ordinalMap = ordinalMap;
            this.segmentIndex = segmentIndex;
        }

        public SortedDocValues getOrdinalsValues() {
            if ((long)this.sdv.getValueCount() == this.ordinalMap.getValueCount()) {
                return this.sdv;
            }
            return new GlobalOrdinalMapping(this.ordinalMap, GlobalOrdinalsFieldData.this.segmentSdv, this.segmentIndex);
        }
    }
}

