/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata;

import com.manageengine.dataengine.xnode.datarepository.search.aggregation.LeafDocLookup;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;

public class MultiFieldDocValues {
    private List<String> fieldNames;
    private List<FieldDocValues> fieldDocValues;
    private LeafDocLookup lookup;
    public static final String MULTI_FIELD_SPLITTER = "_::_";

    public MultiFieldDocValues(List<String> fieldNames, LeafDocLookup lookup) {
        this.fieldNames = fieldNames;
        this.lookup = lookup;
        this.fieldDocValues = new ArrayList<FieldDocValues>();
    }

    public void loadDocValues() {
        for (String fieldName : this.fieldNames) {
            this.fieldDocValues.add((FieldDocValues)this.lookup.get(fieldName));
        }
    }

    public Object getFieldValue(int docId) {
        if (this.fieldDocValues.size() == 1) {
            return this.fieldDocValues.get(0).getFieldValue(docId);
        }
        String appendStr = "";
        for (FieldDocValues fieldDocValue : this.fieldDocValues) {
            appendStr = appendStr + MULTI_FIELD_SPLITTER + (fieldDocValue == null ? null : fieldDocValue.getFieldValue(docId));
        }
        return appendStr;
    }

    public static abstract class FieldDocValues<T>
    extends AbstractList<T> {
        public abstract Object getFieldValue(int var1);

        public final List<T> getValues() {
            return this;
        }

        @Override
        public final void add(int index, T element) {
            throw new UnsupportedOperationException("doc values are unmodifiable");
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException("doc values are unmodifiable");
        }

        @Override
        public final T set(int index, T element) {
            throw new UnsupportedOperationException("doc values are unmodifiable");
        }

        public static final class Doubles
        extends FieldDocValues<Double> {
            private final SortedNumericDocValues values;

            public Doubles(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public Double get(int docId) {
                try {
                    if (this.values.advanceExact(docId)) {
                        return this.values.nextValue();
                    }
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public int size() {
                return this.values.docValueCount();
            }

            @Override
            public Object getFieldValue(int docId) {
                return this.get(docId);
            }
        }

        public static final class Longs
        extends FieldDocValues<Long> {
            private final SortedNumericDocValues values;

            public Longs(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public Long get(int docId) {
                try {
                    if (this.values.advanceExact(docId)) {
                        return this.values.nextValue();
                    }
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public int size() {
                return this.values.docValueCount();
            }

            @Override
            public Object getFieldValue(int docId) {
                return this.get(docId);
            }
        }

        public static final class Strings
        extends FieldDocValues<String> {
            private final SortedDocValues values;

            public Strings(SortedDocValues values) {
                this.values = values;
            }

            @Override
            public String get(int docId) {
                try {
                    if (this.values.advanceExact(docId)) {
                        return this.values.binaryValue().utf8ToString();
                    }
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public int size() {
                return this.values.getValueCount();
            }

            @Override
            public Object getFieldValue(int docId) {
                return this.get(docId);
            }
        }
    }
}

