/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.DoubleValueResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class AvgAggregator
extends Aggregator {
    private ValuesSource.Numeric valuesSource;
    private double sum;
    private long count;

    public AvgAggregator(ValuesSource.Numeric valuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.sum = 0.0;
        this.count = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.doubleValues(ctx);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    Double value;
                    if (AvgAggregator.this.isValidTime(filterDocValues, doc) && (value = (Double)docValues.get(doc)) != null) {
                        AvgAggregator.this.sum = AvgAggregator.this.sum + value;
                        AvgAggregator.this.count++;
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Double value = (Double)docValues.get(doc);
                if (value != null) {
                    AvgAggregator.this.sum = AvgAggregator.this.sum + value;
                    AvgAggregator.this.count++;
                }
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        if (this.valuesSource == null) {
            return new DoubleValueResult(this.id(), this.aggregationType(), 0.0);
        }
        return new DoubleValueResult(this.id(), this.aggregationType(), this.sum / (double)this.count);
    }
}

