/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics;

import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.DoubleValueResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class MinAggregator
extends Aggregator {
    private ValuesSource.Numeric valuesSource;
    private double minValue;

    public MinAggregator(ValuesSource.Numeric valuesSource, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.valuesSource = valuesSource;
        this.minValue = Double.POSITIVE_INFINITY;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final FieldDocValues docValues = this.valuesSource.doubleValues(ctx);
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    Double value;
                    if (MinAggregator.this.isValidTime(filterDocValues, doc) && (value = (Double)docValues.get(doc)) != null) {
                        MinAggregator.this.minValue = Math.min(value, MinAggregator.this.minValue);
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                Double value = (Double)docValues.get(doc);
                if (value != null) {
                    MinAggregator.this.minValue = Math.min(value, MinAggregator.this.minValue);
                }
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        if (this.valuesSource == null) {
            return new DoubleValueResult(this.id(), this.aggregationType(), Double.POSITIVE_INFINITY);
        }
        return new DoubleValueResult(this.id(), this.aggregationType(), this.minValue);
    }
}

