/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository.search.aggregation.metrics;

import com.manageengine.dataengine.commons.utils.StatsType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchContext;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.AggregationResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.Aggregator;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.MultiStatsResult;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.ValuesSource;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.bucket.LeafBucketCollector;
import com.manageengine.dataengine.xnode.datarepository.search.aggregation.fielddata.FieldDocValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;

public class StatsAggregator
extends Aggregator {
    private List<ValuesSource.Numeric> statsValuesSource;
    private List<StatsType> statsType;
    private long totalHitCount = 0L;
    private ArrayList<Double> statsArrBucket = new ArrayList();
    private int statsFieldCount = 0;

    public StatsAggregator(List<ValuesSource.Numeric> statsValuesSource, List<StatsType> statsTypes, SearchContext context, Map<String, Object> metaData) throws IOException {
        super(context, metaData);
        this.statsValuesSource = statsValuesSource;
        this.statsType = statsTypes;
        for (int i = 0; i < this.statsType.size(); ++i) {
            if (this.statsType.get(i) == StatsType.MIN) {
                this.statsArrBucket.add(Double.POSITIVE_INFINITY);
                continue;
            }
            if (this.statsType.get(i) == StatsType.MAX) {
                this.statsArrBucket.add(Double.NEGATIVE_INFINITY);
                continue;
            }
            this.statsArrBucket.add(0.0);
        }
        this.totalHitCount = 0L;
    }

    public LeafCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        final ArrayList<FieldDocValues> statDocValues = new ArrayList<FieldDocValues>();
        for (int i = 0; i < this.statsValuesSource.size(); ++i) {
            statDocValues.add(i, this.statsValuesSource.get(i).doubleValues(ctx));
        }
        if (this.businessHourType != null && (this.businessHourType == 1 || this.businessHourType == 2)) {
            final SortedNumericDocValues filterDocValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.filterField);
            return new LeafBucketCollector(ctx){

                @Override
                public void collect(int doc) throws IOException {
                    if (StatsAggregator.this.isValidTime(filterDocValues, doc)) {
                        StatsAggregator.this.collectStats(statDocValues, doc);
                    }
                }
            };
        }
        return new LeafBucketCollector(ctx){

            @Override
            public void collect(int doc) throws IOException {
                StatsAggregator.this.collectStats(statDocValues, doc);
            }
        };
    }

    public void collectStats(ArrayList<FieldDocValues> statDocValues, int doc) {
        for (int i = 0; i < statDocValues.size(); ++i) {
            Double statFieldValue = (Double)statDocValues.get(i).get(doc);
            if (statFieldValue == null) {
                statFieldValue = this.statsType.get(i) == StatsType.MIN ? Double.valueOf(Double.POSITIVE_INFINITY) : (this.statsType.get(i) == StatsType.MAX ? Double.valueOf(Double.NEGATIVE_INFINITY) : Double.valueOf(0.0));
            }
            if (this.statsType.get(i) == StatsType.MIN) {
                this.statsArrBucket.set(i, Math.min(this.statsArrBucket.get(i), statFieldValue));
                continue;
            }
            if (this.statsType.get(i) == StatsType.MAX) {
                this.statsArrBucket.set(i, Math.max(this.statsArrBucket.get(i), statFieldValue));
                continue;
            }
            this.statsArrBucket.set(i, this.statsArrBucket.get(i) + statFieldValue);
        }
        ++this.totalHitCount;
    }

    public boolean needsScores() {
        return false;
    }

    @Override
    public AggregationResult buildAggregation() {
        return new MultiStatsResult(this.id(), this.aggregationType(), this.statsArrBucket, this.statsType, this.totalHitCount, this.metaData());
    }
}

