/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.scheduler;

import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.commons.utils.HealthState;
import com.manageengine.dataengine.xnode.scheduler.SchedulerJob;
import com.manageengine.dataengine.xnode.scheduler.SchedulerType;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;

public class SchedulerService
extends DEService {
    private static final Logger LOGGER = LogManager.getLogger((String)"org.quartz");
    private HashMap<SchedulerType, Scheduler> schedulerMap = new HashMap();

    protected boolean doStart() throws Exception {
        boolean status = true;
        try {
            this.schedulerMap = new HashMap();
            for (SchedulerType schedulerType : SchedulerType.values()) {
                Scheduler scheduler = new StdSchedulerFactory(schedulerType.confFile().getAbsolutePath()).getScheduler();
                scheduler = SchedulerService.buildScheduler(scheduler, schedulerType.jobsFile());
                scheduler.start();
                this.schedulerMap.put(schedulerType, scheduler);
            }
            this.setHealth(HealthState.GREEN);
        }
        catch (Throwable e) {
            this.setHealth(HealthState.RED);
            status = false;
            LOGGER.error("EXCEPTION : Unable to start SchedulerService service : " + e.getMessage());
            throw e;
        }
        return status;
    }

    protected boolean doStop() {
        String schedulerName = null;
        for (Scheduler scheduler : this.schedulerMap.values()) {
            try {
                schedulerName = scheduler.getSchedulerName();
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                LOGGER.error("EXCEPTION : Unable to stop Scheduler - " + schedulerName + ", Err : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.setHealth(HealthState.RED);
        LOGGER.info("STOPPING SchedulerService, isStopped : true");
        return true;
    }

    protected boolean doClose() {
        String schedulerName = null;
        for (Scheduler scheduler : this.schedulerMap.values()) {
            try {
                schedulerName = scheduler.getSchedulerName();
                if (scheduler.isShutdown()) continue;
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                LOGGER.error("EXCEPTION : Unable to close Scheduler - " + schedulerName + ", Err : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.setHealth(HealthState.RED);
        LOGGER.info("CLOSING SchedulerService, isClosed : true");
        return true;
    }

    protected boolean doFail() {
        this.setHealth(HealthState.RED);
        return true;
    }

    private static Scheduler buildScheduler(Scheduler scheduler, File jobsFile) throws Exception {
        String jsonString = new String(Files.readAllBytes(Paths.get(jobsFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
        JSONObject scheduleContentJson = new JSONObject(jsonString);
        if (scheduleContentJson.optBoolean("deleteJobsAndTriggers", false)) {
            SchedulerService.deleteAllJobsAndTriggers(scheduler);
        }
        JSONArray scheduleList = scheduleContentJson.getJSONArray("schedule");
        for (int i = 0; i < scheduleList.length(); ++i) {
            JSONObject scheduleObject = scheduleList.getJSONObject(i);
            JSONObject job = scheduleObject.getJSONObject("job");
            JobDetail jobDetail = JobBuilder.newJob(Class.forName(job.getString("jobClass"))).withIdentity(job.getString("name"), job.getString("group")).build();
            JSONObject triggerDetail = scheduleObject.getJSONObject("trigger");
            JSONObject cronDetail = triggerDetail.getJSONObject("cron");
            CronScheduleBuilder cron = CronScheduleBuilder.cronSchedule((String)cronDetail.getString("cronExpression"));
            cron = SchedulerService.setCronMisFireinstruction(cron, cronDetail.getString("misfireInstruction"));
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerDetail.getString("name"), triggerDetail.getString("group")).withSchedule((ScheduleBuilder)cron).build();
            scheduler.scheduleJob(jobDetail, trigger);
        }
        return scheduler;
    }

    private static CronScheduleBuilder setCronMisFireinstruction(CronScheduleBuilder cron, String misfireInstruction) {
        if (misfireInstruction.equals("MISFIRE_INSTRUCTION_DO_NOTHING")) {
            cron.withMisfireHandlingInstructionDoNothing();
        } else {
            LOGGER.info("UnHandled Misfire_Instruction - " + misfireInstruction);
        }
        return cron;
    }

    private static void deleteAllJobsAndTriggers(Scheduler scheduler) throws SchedulerException {
        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.anyJobGroup())) {
            scheduler.deleteJob(jobKey);
            LOGGER.info("DELETED job: " + jobKey);
        }
        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup())) {
            scheduler.unscheduleJob(triggerKey);
            LOGGER.info("DELETED trigger: " + triggerKey);
        }
    }

    public boolean reschedule(String cronExpression) {
        boolean status = true;
        Scheduler scheduler = this.schedulerMap.get((Object)SchedulerType.COMMON_ROUTINE);
        LOGGER.info("RESCHEDULING SchedulerService and updating cron trigger :: " + cronExpression);
        try {
            TriggerKey triggerKey = new TriggerKey(SchedulerJob.ARCHIVE_JOB.triggerName(), SchedulerJob.ARCHIVE_JOB.jobGroupName());
            CronTriggerImpl trigger = (CronTriggerImpl)scheduler.getTrigger(triggerKey);
            trigger.setCronExpression(cronExpression);
            Date nextFireTime = scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            LOGGER.info("RESCHEDULED SchedulerService nextFireTime :: " + nextFireTime);
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }
}

