/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.scheduler.jobs;

import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.AuditLogDR;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DRBlockRepairJob
implements Job {
    private static final Logger LOGGER = LogManager.getLogger((String)"Scheduler");
    private static final Logger XNODE_LOGGER = LogManager.getLogger((String)"XNode");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            long thresholdSpace = 524288000L;
            JobKey jobKey = context.getJobDetail().getKey();
            long elapsedTime = System.currentTimeMillis();
            LOGGER.info("DRBlockRoutineJob STARTED [KEY : " + jobKey + "] [Fire Time : " + context.getFireTime() + "] [Next Fire Time : " + context.getNextFireTime());
            File serverDir = ((Path)Environment.XNODE_HOME_DIR.value()).toFile();
            long freeSpace = serverDir.getUsableSpace();
            LOGGER.info("DRBlockRoutineJob :: Free Space : " + freeSpace + " Bytes, " + freeSpace / 0x100000L + " MB");
            if (freeSpace > thresholdSpace) {
                XNODE_LOGGER.info("Started to WRITE-COMPACT DB...");
                DBManager.writeCompact();
                XNODE_LOGGER.info("Completed WRITE-COMPACT DB!");
                ConcurrentHashMap<String, DataRepository> dataRepositoryMap = DataRepositoryManager.getDataRepositories();
                for (DataRepository dataRepository : dataRepositoryMap.values()) {
                    if (!(dataRepository instanceof AuditLogDR)) continue;
                    ((AuditLogDR)dataRepository).mergeColdBlockSegments();
                }
            } else {
                LOGGER.warn("DRBlockRoutineJob :: Skipped the job due to diskspace constraint!");
            }
            LOGGER.info("DRBlockRoutineJob ENDED [RunTime : " + (double)(System.currentTimeMillis() - elapsedTime) / 1000.0 + " secs]");
        }
        catch (Exception e) {
            LOGGER.error("DRBlockRoutineJob ERROR");
            e.printStackTrace();
        }
    }
}

