/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.scheduler.jobs;

import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DataRepositoryArchiveJob
implements Job {
    private static final Logger LOGGER = LogManager.getLogger((String)"Scheduler");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobKey jobKey = context.getJobDetail().getKey();
            long elapsedTime = System.currentTimeMillis();
            LOGGER.info("DataRepositoryArchiveJob STARTED [KEY : " + jobKey + "] [Fire Time : " + context.getFireTime() + "] [Next Fire Time : " + context.getNextFireTime());
            DataRepositoryManager.archiveOldBlocks();
            DataRepositoryManager.unloadOldArchiveBlocks();
            LOGGER.info("DataRepositoryArchiveJob ENDED [RunTime : " + (double)(System.currentTimeMillis() - elapsedTime) / 1000.0 + " secs]");
        }
        catch (Exception e) {
            LOGGER.error("DataRepositoryArchiveJob ERROR");
            e.printStackTrace();
        }
    }
}

