/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.file.GuessEncoding;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.commons.file.ZipUtil;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.terminal.LeafTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.StemTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.TerminalCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchiveBlockCmd
extends StemTerminalCommand {
    public TerminalCommand help = new LeafTerminalCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveBlockCmd.this.processHelp();
        }
    };
    public TerminalCommand restore_archive_meta = new LeafTerminalCommand(this.getCmdId() + "1", "restore-archive-meta", "Restores archive.meta of all category based on available archive files"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveBlockCmd.this.processRestoreArchiveMeta(cmdStr, processIndex);
        }
    };
    public TerminalCommand remove_duplicate_archive_entries = new LeafTerminalCommand(this.getCmdId() + "2", "remove-duplicate-archive-entries", "Remove duplicate archive entries from archive.meta"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            ArchiveBlockCmd.this.processRemoveDuplicateArchiveEntries(cmdStr, processIndex);
        }
    };

    public ArchiveBlockCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, TerminalCommand> childCmdList = new LinkedHashMap<String, TerminalCommand>();
        childCmdList.put(this.help.getCmdName(), this.help);
        childCmdList.put(this.restore_archive_meta.getCmdName(), this.restore_archive_meta);
        childCmdList.put(this.remove_duplicate_archive_entries.getCmdName(), this.remove_duplicate_archive_entries);
        this.setChildCmdList(childCmdList);
    }

    private void processRestoreArchiveMeta(String[] cmdStr, int processIndex) {
        ConcurrentHashMap<String, DataRepository> dataRepos = DataRepositoryManager.getDataRepositories();
        for (DataRepository dataRepo : dataRepos.values()) {
            this.ioHandle().print("\nGoing to clean archive meta of " + dataRepo.repositoryName());
            try {
                dataRepo.cleanArchiveMeta();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.ioHandle().print("\nCleaned archive meta of " + dataRepo.repositoryName());
            ArrayList<DRIndexField> indexFields = dataRepo.getIndexFields();
            int timeGeneratedIndex = 0;
            for (int i = 0; i < indexFields.size(); ++i) {
                if (!indexFields.get(i).getFieldName().equalsIgnoreCase("TIME_GENERATED")) continue;
                timeGeneratedIndex = i;
                break;
            }
            ArrayList<File> deArchiveFiles = this.listDEArchiveFiles(dataRepo);
            JSONArray blockList = new JSONArray();
            for (File file : deArchiveFiles) {
                this.ioHandle().print("\nFiles = " + file.getName());
                blockList.put((Object)this.buildBlockObject(file, dataRepo, timeGeneratedIndex, indexFields.size()));
            }
            ArrayList<File> deS1ArchiveFiles = this.listDES1ArchiveFiles(dataRepo);
            for (File file3 : deS1ArchiveFiles) {
                this.ioHandle().print("\nFiles = " + file3.getName());
                blockList = this.buildS1BlockObject(file3, blockList);
            }
            this.ioHandle().print("\nGoing to Add entries archive meta of " + dataRepo.repositoryName());
            try {
                dataRepo.addEntriesToArchiveMeta(blockList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.ioHandle().print("\nAdded entries archive meta of " + dataRepo.repositoryName() + "\n");
        }
        this.ioHandle().print("\n");
    }

    private void processRemoveDuplicateArchiveEntries(String[] cmdStr, int processIndex) {
        ConcurrentHashMap<String, DataRepository> dataRepos = DataRepositoryManager.getDataRepositories();
        for (DataRepository dataRepo : dataRepos.values()) {
            this.ioHandle().print("\nGoing to remove duplicate archive entries of " + dataRepo.repositoryName());
            try {
                dataRepo.removeDuplicateEntries();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.ioHandle().print("\nRemove duplicate archive entries of " + dataRepo.repositoryName());
        }
        this.ioHandle().print("\nGoing to SHUTDOWN COMPACT DB");
        try {
            DBManager.writeCompact();
            this.ioHandle().print("\nSHUTDOWN COMPACT DB completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.ioHandle().print("\n");
    }

    private JSONObject buildBlockObject(File file, DataRepository dataRepo, int timeGeneratedIndex, int fieldListSize) {
        JSONObject fileProps;
        int version;
        JSONObject result = new JSONObject();
        String fileName = file.getName();
        String blockName = fileName.substring(0, fileName.indexOf("."));
        blockName = blockName.replace("_S2", "");
        result.put("block_name", (Object)blockName);
        if (!fileName.endsWith(".zip")) {
            version = 10;
            fileProps = this.readGZFile(file, timeGeneratedIndex);
        } else {
            version = 1;
            fileProps = this.readZipFile(file, timeGeneratedIndex, fieldListSize);
        }
        result.put("version", version);
        result.put("datarepository_name", (Object)dataRepo.repositoryName());
        result.put("creation_time", (Object)blockName.substring(blockName.indexOf("_") + 1));
        result.put("state", (Object)"FROZEN");
        result.put("status", (Object)"-");
        result.put("range_from", (Object)fileProps.optString("range_from"));
        result.put("range_to", (Object)fileProps.optString("range_to"));
        result.put("doc_count", (Object)fileProps.optString("doc_count"));
        result.put("raw_size", FileUtils.sizeOf((File)file));
        return result;
    }

    private JSONArray buildS1BlockObject(File file, JSONArray blockList) {
        String fileName = file.getName();
        String blockName = fileName.substring(0, fileName.indexOf("."));
        for (int i = 0; i < blockList.length(); ++i) {
            if (!blockList.getJSONObject(i).getString("block_name").equalsIgnoreCase(blockName.replace("_S1", ""))) continue;
            blockList.getJSONObject(i).put("version", 11);
            blockList.getJSONObject(i).put("cold_size", FileUtils.sizeOf((File)file));
            break;
        }
        return blockList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject readGZFile(File file, int timeGeneratedIndex) {
        JSONObject fileProps = new JSONObject();
        GzipUtil.GzipCsvReadHandle reader = null;
        Long totalLines = 0L;
        Long minTime = Long.MAX_VALUE;
        Long maxTime = Long.MIN_VALUE;
        try {
            String[] line;
            reader = new GzipUtil().getGzipCsvReadHandle(file.getAbsolutePath(), '\t');
            while ((line = reader.readNext()) != null) {
                Long tempTime = Long.parseLong(line[timeGeneratedIndex]);
                if (minTime > tempTime) {
                    minTime = tempTime;
                }
                if (maxTime < tempTime) {
                    maxTime = tempTime;
                }
                Long l = totalLines;
                Long l2 = totalLines = Long.valueOf(totalLines + 1L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fileProps.put("range_from", (Object)minTime);
        fileProps.put("range_to", (Object)maxTime);
        fileProps.put("doc_count", (Object)totalLines);
        return fileProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject readZipFile(File file, int timeGeneratedIndex, int fieldListSize) {
        JSONObject fileProps = new JSONObject();
        Charset encoding = Charset.forName("UTF-8");
        Long totalLines = 0L;
        Long minTime = Long.MAX_VALUE;
        Long maxTime = Long.MIN_VALUE;
        String splitBy = "\t";
        String absFileName = file.getAbsolutePath();
        Boolean isMySqlDb = false;
        BufferedReader br = null;
        try {
            String line;
            ZipUtil.unZip((File)file, (File)file.getParentFile(), null, null, null);
            encoding = GuessEncoding.getArchiveFileEncoding((File)new File(absFileName.replace(".zip", ".csv")));
            if (encoding.toString().equals("UTF-16LE")) {
                encoding = Charset.forName("UTF-16");
                splitBy = "\\|\\*\\*\\|";
            } else {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absFileName.replace(".zip", ".csv")), encoding));
                String firstLine = br.readLine();
                if (firstLine.contains("|**|")) {
                    splitBy = "\\|\\*\\*\\|";
                } else if (!firstLine.contains("\t")) {
                    splitBy = ",";
                    isMySqlDb = true;
                }
                br.close();
            }
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absFileName.replace(".zip", ".csv")), encoding));
            while ((line = br.readLine()) != null) {
                String[] str = this.splitLine(line, splitBy, fieldListSize, isMySqlDb);
                Long tempTime = Long.parseLong(str[timeGeneratedIndex]);
                if (minTime > tempTime) {
                    minTime = tempTime;
                }
                if (maxTime < tempTime) {
                    maxTime = tempTime;
                }
                Long l = totalLines;
                Long l2 = totalLines = Long.valueOf(totalLines + 1L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new File(absFileName.replace(".zip", ".csv")).delete();
        }
        fileProps.put("range_from", (Object)minTime);
        fileProps.put("range_to", (Object)maxTime);
        fileProps.put("doc_count", (Object)totalLines);
        return fileProps;
    }

    private String[] splitMySqlLine(String line, int totalCols) {
        String[] splitStr = new String[totalCols];
        int len = line.length();
        int commaBeginIndex = 0;
        int commaEndIndex = 0;
        int splitStrIndex = 0;
        while (commaEndIndex < len && splitStrIndex < totalCols) {
            boolean isQuoteChk = false;
            if (line.charAt(commaBeginIndex) == '\"') {
                for (commaEndIndex = ++commaBeginIndex; commaEndIndex < len && (line.charAt(commaEndIndex) != '\"' || line.charAt(commaEndIndex - 1) == '\\' && commaEndIndex - 2 >= 0 && line.charAt(commaEndIndex - 2) != '\\'); ++commaEndIndex) {
                }
                isQuoteChk = true;
            } else {
                commaEndIndex = line.indexOf(44, commaBeginIndex);
            }
            if (commaEndIndex == -1) {
                commaEndIndex = len;
            }
            String colVal = line.substring(commaBeginIndex, commaEndIndex);
            if ((colVal = colVal.replace("\\\\", "\\")).equals("\\N")) {
                colVal = "";
            }
            splitStr[splitStrIndex++] = colVal;
            commaEndIndex = commaBeginIndex = commaEndIndex + (isQuoteChk ? 2 : 1);
        }
        return splitStr;
    }

    private String[] splitLine(String line, String splitBy, int totalCols, boolean isMySql) {
        int i;
        String[] rColStr = new String[totalCols];
        String[] aColStr = isMySql ? this.splitMySqlLine(line, totalCols) : line.split(splitBy, -1);
        int actualColLen = aColStr.length;
        int indexLen = totalCols;
        if (actualColLen < totalCols) {
            indexLen = actualColLen;
        }
        for (i = 0; i < indexLen; ++i) {
            rColStr[i] = aColStr[i] == null || aColStr[i].isEmpty() ? "-" : aColStr[i];
        }
        for (i = actualColLen; i < totalCols; ++i) {
            rColStr[i] = "-";
        }
        return rColStr;
    }

    private ArrayList<File> listDEArchiveFiles(DataRepository dataRepo) {
        ArrayList<String> locationList = DataRepositoryManager.getArchiveLocations();
        ArrayList<File> result = new ArrayList<File>();
        Iterator<String> iterator = locationList.iterator();
        while (iterator.hasNext()) {
            String archiveLocation;
            String legacyLocation = archiveLocation = iterator.next();
            String deArchiveLocation = archiveLocation + File.separator + dataRepo.containerName() + File.separator + dataRepo.repositoryName() + File.separator + "frozen";
            if (dataRepo.isLegacy()) {
                result.addAll(this.listFiles(legacyLocation, ".zip", dataRepo.legacyTableName()));
            }
            result.addAll(this.listFiles(deArchiveLocation, ".gz", dataRepo.repositoryName()));
        }
        return result;
    }

    private ArrayList<File> listDES1ArchiveFiles(DataRepository dataRepo) {
        ArrayList<String> locationList = DataRepositoryManager.getArchiveLocations();
        ArrayList<File> result = new ArrayList<File>();
        for (String archiveLocation : locationList) {
            String deArchiveLocation = archiveLocation + File.separator + dataRepo.containerName() + File.separator + dataRepo.repositoryName() + File.separator + "frozen";
            result.addAll(this.listFiles(deArchiveLocation, ".7z", dataRepo.repositoryName()));
        }
        return result;
    }

    private ArrayList<File> listFiles(String location, String extension, String tableName) {
        File folder = new File(location);
        ArrayList<File> result = new ArrayList<File>();
        if (!folder.exists()) {
            return result;
        }
        for (File file : folder.listFiles()) {
            String tempTableName;
            String fileName = file.getName();
            if (!fileName.endsWith(extension) || !(tempTableName = fileName.substring(0, fileName.indexOf("_"))).equalsIgnoreCase(tableName)) continue;
            result.add(file);
        }
        return result;
    }
}

