/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.terminal.ArchiveBlockCmd;
import com.manageengine.dataengine.xnode.terminal.LeafTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.MainBlockCmd;
import com.manageengine.dataengine.xnode.terminal.StemTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.TerminalCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DRCmd
extends StemTerminalCommand {
    public TerminalCommand help = new LeafTerminalCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DRCmd.this.processHelp();
        }
    };
    public TerminalCommand show = new LeafTerminalCommand(this.getCmdId() + "1", "show", "Shows the available DataRepositories"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DRCmd.this.processShow(cmdStr, processIndex);
        }
    };
    public TerminalCommand show_detail = new LeafTerminalCommand(this.getCmdId() + "2", "show-detail", "Shows the detailed available DataRepositories"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            DRCmd.this.processShowDetail(cmdStr, processIndex);
        }
    };
    public final MainBlockCmd main_block = new MainBlockCmd(this.getCmdId() + "3", "main-block", "Main block commands");
    public final ArchiveBlockCmd archive_block = new ArchiveBlockCmd(this.getCmdId() + "4", "archive-block", "Archive block commands");

    public DRCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, TerminalCommand> childCmdList = new LinkedHashMap<String, TerminalCommand>();
        childCmdList.put(this.help.getCmdName(), this.help);
        childCmdList.put(this.show.getCmdName(), this.show);
        childCmdList.put(this.show_detail.getCmdName(), this.show_detail);
        childCmdList.put(this.main_block.getCmdName(), this.main_block);
        childCmdList.put(this.archive_block.getCmdName(), this.archive_block);
        this.setChildCmdList(childCmdList);
    }

    private void processShow(String[] cmdStr, int processIndex) throws IOException {
        this.ioHandle().print(String.format("\n\t%-25s%-20s%-50s", "DataRepository", "Type", "Description"));
        this.ioHandle().print("\n\t-----------------------------------------------------------");
        ConcurrentHashMap<String, DataRepository> dataRepositoryMap = DataRepositoryManager.getDataRepositories();
        for (DataRepository dataRepository : dataRepositoryMap.values()) {
            this.ioHandle().print(String.format("\n\t%-25s%-20s%-50s", dataRepository.repositoryName(), dataRepository.repositoryType(), dataRepository.description()));
        }
        this.ioHandle().print("\n\n");
    }

    private void processShowDetail(String[] cmdStr, int processIndex) throws IOException {
        this.ioHandle().print("\n");
        ConcurrentHashMap<String, DataRepository> dataRepositoryMap = DataRepositoryManager.getDataRepositories();
        for (DataRepository dataRepository : dataRepositoryMap.values()) {
            this.ioHandle().print("\n\t--------------------------------------------------------------------");
            this.ioHandle().print("\n\tDATA REPOSITORY - " + dataRepository.repositoryName());
            this.ioHandle().print("\n\t--------------------------------------------------------------------");
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "repository_state", ": " + dataRepository.repositoryState()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "repository_type", ": " + dataRepository.repositoryType()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "description", ": " + dataRepository.description()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "container_name", ": " + dataRepository.containerName()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "is_legacy", ": " + dataRepository.isLegacy()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "schema_name", ": " + dataRepository.schema().getSchemaName()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "store_raw_data", ": " + dataRepository.storeRawData()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "contains_duplicate", ": " + dataRepository.containsDuplicate()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_prefix", ": " + dataRepository.blockPrefix()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_hot_count", ": " + dataRepository.hotBlockCount()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_hot_refresh_interval", ": " + dataRepository.hotBlockRefreshInterval()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_hot_rotation_type", ": " + dataRepository.hotBlockRotationType()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_hot_rotation_size", ": " + dataRepository.hotBlockRotationSize()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_hot_rotation_period", ": " + dataRepository.hotBlockRotationPeriod()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_main_retention_days", ": " + dataRepository.mainBlockRetentionDays()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_frozen_retention_days", ": " + dataRepository.frozenBlockRetentionDays()));
            this.ioHandle().print(String.format("\n\t%-50s%-50s", "block_defrost_retention_days", ": " + dataRepository.defrostBlockRetentionDays()));
            this.ioHandle().print("\n");
        }
        this.ioHandle().print("\n\n");
    }
}

