/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import com.manageengine.dataengine.xnode.datarepository.AuditLogDR;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.terminal.LeafTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.StemTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.TerminalCommand;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.lucene.index.CheckIndex;

public class MainBlockCmd
extends StemTerminalCommand {
    private static CheckIndex.Status indexStatus;
    public TerminalCommand help = new LeafTerminalCommand(this.getCmdId() + "0", "help", "Lists available commands"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processHelp();
        }
    };
    public TerminalCommand check_index = new LeafTerminalCommand(this.getCmdId() + "1", "check-index", "Checks the lucene index"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processCheckIndex(cmdStr, processIndex);
        }
    };
    public TerminalCommand count_index = new LeafTerminalCommand(this.getCmdId() + "2", "doc-count-index", "Gets the lucene document count"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processCountIndex(cmdStr, processIndex);
        }
    };
    public TerminalCommand count_raw = new LeafTerminalCommand(this.getCmdId() + "3", "doc-count-raw", "Gets the raw file document count"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processCountRaw(cmdStr, processIndex);
        }
    };
    public TerminalCommand repair_index = new LeafTerminalCommand(this.getCmdId() + "4", "repair-index", "Tries to repair the lucene index"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processRepairIndex(cmdStr, processIndex);
        }
    };
    public TerminalCommand reindex = new LeafTerminalCommand(this.getCmdId() + "5", "re-index", "Re-Indexes a block from raw file"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processReindex(cmdStr, processIndex);
        }
    };
    public TerminalCommand auto_repair_index = new LeafTerminalCommand(this.getCmdId() + "6", "auto-repair-index", "Checks both index and raw files and repair index based on more documents"){

        @Override
        public void process(String[] cmdStr, int processIndex) throws Exception {
            MainBlockCmd.this.processAutoRepairIndex(cmdStr, processIndex);
        }
    };

    public MainBlockCmd(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
        LinkedHashMap<String, TerminalCommand> childCmdList = new LinkedHashMap<String, TerminalCommand>();
        childCmdList.put(this.help.getCmdName(), this.help);
        childCmdList.put(this.check_index.getCmdName(), this.check_index);
        childCmdList.put(this.count_index.getCmdName(), this.count_index);
        childCmdList.put(this.count_raw.getCmdName(), this.count_raw);
        childCmdList.put(this.repair_index.getCmdName(), this.repair_index);
        childCmdList.put(this.reindex.getCmdName(), this.reindex);
        childCmdList.put(this.auto_repair_index.getCmdName(), this.auto_repair_index);
        this.setChildCmdList(childCmdList);
    }

    private void processCheckIndex(String[] cmdStr, int processIndex) throws Exception {
        boolean isValid = true;
        int len = cmdStr.length;
        WriterOutputStream os = new WriterOutputStream((Writer)this.ioHandle().printWriter());
        this.ioHandle().print("\n");
        if (processIndex + 2 == len - 1) {
            String repoName = cmdStr[processIndex + 1];
            String blockName = cmdStr[processIndex + 2];
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            if (dataRepository instanceof AuditLogDR) {
                indexStatus = ((AuditLogDR)dataRepository).checkBlockIndex(blockName, new PrintStream((OutputStream)os));
                this.ioHandle().print("\n\nStatus : " + this.createResultsMessage(indexStatus) + "\n\n\n");
            } else {
                this.ioHandle().print("\n Command not supported for this repository!\n\n\n");
            }
        } else {
            this.ioHandle().print("\n Wrong Usage!\n");
            this.ioHandle().print("\n Syntax:\n");
            this.ioHandle().print("\n     DR MAIN-BLOCK CHECK-INDEX <REPO_NAME> <DR_BLOCK_NAME>\n\n\n");
            isValid = false;
        }
    }

    private void processCountIndex(String[] cmdStr, int processIndex) throws Exception {
        this.processCount(cmdStr, processIndex, "index");
    }

    private void processCountRaw(String[] cmdStr, int processIndex) throws Exception {
        this.processCount(cmdStr, processIndex, "raw");
    }

    private void processCount(String[] cmdStr, int processIndex, String type) throws Exception {
        boolean isValid = true;
        int len = cmdStr.length;
        WriterOutputStream os = new WriterOutputStream((Writer)this.ioHandle().printWriter());
        this.ioHandle().print("\n");
        if (processIndex + 2 == len - 1) {
            String repoName = cmdStr[processIndex + 1];
            String blockName = cmdStr[processIndex + 2];
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            if (dataRepository instanceof AuditLogDR) {
                int count = type.equalsIgnoreCase("raw") ? ((AuditLogDR)dataRepository).getRawDocCount(blockName) : ((AuditLogDR)dataRepository).getIndexDocCount(blockName);
                this.ioHandle().print("\n Count : " + count + "\n\n\n");
            } else {
                this.ioHandle().print("\n Command not supported for this repository!\n\n\n");
            }
        } else {
            this.ioHandle().print("\n Wrong Usage!\n");
            this.ioHandle().print("\n Syntax:\n");
            this.ioHandle().print("\n     DR MAIN-BLOCK DOC-COUNT-RAW/DOC-COUNT-INDEX <REPO_NAME> <DR_BLOCK_NAME>\n\n\n");
            isValid = false;
        }
    }

    private void processRepairIndex(String[] cmdStr, int processIndex) throws Exception {
        boolean isValid = true;
        int len = cmdStr.length;
        WriterOutputStream os = new WriterOutputStream((Writer)this.ioHandle().printWriter());
        this.ioHandle().print("\n");
        if (processIndex + 2 == len - 1) {
            String repoName = cmdStr[processIndex + 1];
            String blockName = cmdStr[processIndex + 2];
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            if (dataRepository instanceof AuditLogDR) {
                ((AuditLogDR)dataRepository).repairBlockIndex(blockName, new PrintStream((OutputStream)os), indexStatus);
                this.ioHandle().print("\n Repair completed!\n\n\n");
            } else {
                this.ioHandle().print("\n Command not supported for this repository!\n\n\n");
            }
        } else {
            this.ioHandle().print("\n Wrong Usage!\n");
            this.ioHandle().print("\n Syntax:\n");
            this.ioHandle().print("\n     DR MAIN-BLOCK REPAIR-INDEX <REPO_NAME> <DR_BLOCK_NAME>\n\n\n");
            isValid = false;
        }
    }

    private void processReindex(String[] cmdStr, int processIndex) throws Exception {
        boolean isValid = true;
        int len = cmdStr.length;
        WriterOutputStream os = new WriterOutputStream((Writer)this.ioHandle().printWriter());
        this.ioHandle().print("\n");
        if (processIndex + 2 == len - 1) {
            String repoName = cmdStr[processIndex + 1];
            String blockName = cmdStr[processIndex + 2];
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            if (dataRepository instanceof AuditLogDR) {
                ((AuditLogDR)dataRepository).reindexBlockFromRawFile(blockName, new PrintStream((OutputStream)os));
                this.ioHandle().print("\n Re-indexing completed!\n\n\n");
            } else {
                this.ioHandle().print("\n Command not supported for this repository!\n\n\n");
            }
        } else {
            this.ioHandle().print("\n Wrong Usage!\n");
            this.ioHandle().print("\n Syntax:\n");
            this.ioHandle().print("\n     DR REINDEX-BLOCK <REPO_NAME> <DR_BLOCK_NAME>\n\n\n");
            isValid = false;
        }
    }

    private String createResultsMessage(CheckIndex.Status status) {
        String msg;
        if (status == null) {
            msg = "?";
        } else if (status.clean) {
            msg = "OK";
        } else if (status.toolOutOfDate) {
            msg = "ERROR: Can't check - tool out-of-date";
        } else {
            StringBuilder sb = new StringBuilder("BAD:");
            if (status.missingSegments) {
                sb.append(" Missing segments.");
            }
            if (status.numBadSegments > 0) {
                sb.append(" numBadSegments=");
                sb.append(status.numBadSegments);
            }
            if (status.totLoseDocCount > 0) {
                sb.append(" totLoseDocCount=");
                sb.append(status.totLoseDocCount);
            }
            msg = sb.toString();
        }
        return msg;
    }

    private void processAutoRepairIndex(String[] cmdStr, int processIndex) throws Exception {
        int len = cmdStr.length;
        WriterOutputStream os = new WriterOutputStream((Writer)this.ioHandle().printWriter());
        this.ioHandle().print("\n");
        if (processIndex + 2 == len - 1) {
            String repoName = cmdStr[processIndex + 1];
            String blockName = cmdStr[processIndex + 2];
            DataRepository dataRepository = DataRepositoryManager.getDataRepository(repoName);
            if (dataRepository instanceof AuditLogDR) {
                boolean compareCount = false;
                indexStatus = ((AuditLogDR)dataRepository).checkBlockIndex(blockName, new PrintStream((OutputStream)os));
                this.ioHandle().print("\n\nStatus : " + this.createResultsMessage(indexStatus) + "\n\n\n");
                if (indexStatus != null) {
                    if (MainBlockCmd.indexStatus.clean) {
                        compareCount = true;
                    } else if (!MainBlockCmd.indexStatus.toolOutOfDate && MainBlockCmd.indexStatus.totLoseDocCount > 0) {
                        this.ioHandle().print("\n Going to Repair Index\n\n\n");
                        ((AuditLogDR)dataRepository).repairBlockIndex(blockName, new PrintStream((OutputStream)os), indexStatus);
                        this.ioHandle().print("\n Repair completed!\n\n\n");
                        compareCount = true;
                    }
                    if (compareCount) {
                        int rawCount = ((AuditLogDR)dataRepository).getRawDocCount(blockName);
                        this.ioHandle().print("\n Raw Count = " + rawCount + "\n");
                        int indexCount = ((AuditLogDR)dataRepository).getIndexDocCount(blockName);
                        this.ioHandle().print("\n Index Count = " + indexCount + "\n");
                        if (rawCount > indexCount) {
                            ((AuditLogDR)dataRepository).reindexBlockFromRawFile(blockName, new PrintStream((OutputStream)os));
                            this.ioHandle().print("\n Re-indexing completed!\n\n\n");
                        } else if (indexCount > rawCount) {
                            ((AuditLogDR)dataRepository).rewriteRawFileFromIndexBlock(blockName, new PrintStream((OutputStream)os));
                            this.ioHandle().print("\n Re-Write Raw File completed!\n\n\n");
                        }
                        this.ioHandle().print("\n After Repair!\n\n\n");
                        rawCount = ((AuditLogDR)dataRepository).getRawDocCount(blockName);
                        this.ioHandle().print("\n Raw Count = " + rawCount + "\n");
                        indexCount = ((AuditLogDR)dataRepository).getIndexDocCount(blockName);
                        this.ioHandle().print("\n Index Count = " + indexCount + "\n");
                    }
                }
            } else {
                this.ioHandle().print("\n Command not supported for this repository!\n\n\n");
            }
        } else {
            this.ioHandle().print("\n Wrong Usage!\n");
            this.ioHandle().print("\n Syntax:\n");
            this.ioHandle().print("\n     DR MAIN-BLOCK AUTO-REPAIR-INDEX <REPO_NAME> <DR_BLOCK_NAME>\n\n\n");
        }
    }
}

