/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import com.manageengine.dataengine.xnode.terminal.LeafTerminalCommand;
import com.manageengine.dataengine.xnode.terminal.TerminalCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class StemTerminalCommand
extends TerminalCommand {
    private LinkedHashMap<String, TerminalCommand> childCmdList = new LinkedHashMap();

    public StemTerminalCommand(String cmdId, String cmdName, String cmdDesc) {
        super(cmdId, cmdName, cmdDesc);
    }

    public LinkedHashMap<String, TerminalCommand> getChildCmdList() {
        return this.childCmdList;
    }

    public void setChildCmdList(LinkedHashMap<String, TerminalCommand> childCmdList) {
        this.childCmdList = childCmdList;
    }

    @Override
    public void process(String[] cmdStr, int processIndex) throws Exception {
        int cmdLen = cmdStr.length;
        LinkedHashMap<String, TerminalCommand> childCmdList = this.getChildCmdList();
        if (processIndex < cmdLen && childCmdList.containsKey(cmdStr[processIndex].toLowerCase())) {
            TerminalCommand cmdHandler = childCmdList.get(cmdStr[processIndex].toLowerCase());
            if (this.userRole().hasAccess(cmdHandler.getCmdId())) {
                if (cmdHandler instanceof LeafTerminalCommand) {
                    cmdHandler.process(cmdStr, processIndex);
                } else {
                    cmdHandler.process(cmdStr, ++processIndex);
                }
            } else {
                this.ioHandle().print("\n# Access Denied!\n\n");
            }
        } else {
            this.ioHandle().print("\n# Wrong command! Enter \"help\" to view list of available commands\n\n");
        }
    }

    public void processHelp() throws IOException {
        LinkedHashMap<String, TerminalCommand> childCmdList = this.getChildCmdList();
        for (TerminalCommand cmdHandler : childCmdList.values()) {
            if (!this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
            this.ioHandle().print(String.format("\n%-15s%-50s", " " + cmdHandler.getCmdName().toUpperCase(), cmdHandler.getCmdDesc()));
        }
        this.ioHandle().print("\n\n");
    }

    public void getAllCommandTreeList(ArrayList<TerminalCommand> cmdList) {
        cmdList.add(this);
        LinkedHashMap<String, TerminalCommand> childCmdList = this.getChildCmdList();
        for (TerminalCommand cmdHandler : childCmdList.values()) {
            if (cmdHandler instanceof LeafTerminalCommand) {
                cmdList.add(cmdHandler);
                continue;
            }
            ((StemTerminalCommand)cmdHandler).getAllCommandTreeList(cmdList);
        }
    }

    public JSONArray getCommandTree() throws Exception {
        JSONArray jCmdList = new JSONArray();
        LinkedHashMap<String, TerminalCommand> childCmdList = this.getChildCmdList();
        for (TerminalCommand cmdHandler : childCmdList.values()) {
            if (!this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
            JSONObject nodeObj = new JSONObject();
            nodeObj.put("nodeName", (Object)cmdHandler.getCmdName());
            if (!(cmdHandler instanceof LeafTerminalCommand)) {
                nodeObj.put("nodeChildList", (Object)((StemTerminalCommand)cmdHandler).getCommandTree());
            }
            jCmdList.put((Object)nodeObj);
        }
        return jCmdList;
    }

    public void showSuggestions(String[] cmdStr, int processIndex) throws IOException {
        int cmdLen = cmdStr.length;
        boolean isLastCmd = processIndex == cmdLen - 1;
        LinkedHashMap<String, TerminalCommand> childCmdList = this.getChildCmdList();
        if (isLastCmd) {
            ArrayList<String> sugList = new ArrayList<String>();
            String cmd = cmdStr[processIndex];
            cmd = cmd.replace("?", "");
            for (TerminalCommand cmdHandler : childCmdList.values()) {
                if (!cmdHandler.getCmdName().startsWith(cmd) || !this.userRole().hasAccess(cmdHandler.getCmdId())) continue;
                sugList.add(cmdHandler.getCmdName());
            }
            this.ioHandle().print("\n");
            for (String key : sugList) {
                this.ioHandle().print(String.format("  %-20s", key));
            }
            this.ioHandle().print("\n\n");
        } else {
            TerminalCommand cmdHandler = childCmdList.get(cmdStr[processIndex]);
            if (cmdHandler != null) {
                ((StemTerminalCommand)cmdHandler).showSuggestions(cmdStr, ++processIndex);
            } else {
                this.ioHandle().print("\n# Wrong command! Enter \"help\" to view list of available commands\n\n");
            }
        }
    }
}

