/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

class TcpClient {
    private int port;
    private String username;
    private String password;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private static final Logger LOGGER = LogManager.getLogger((String)"Terminal");

    public TcpClient(int port, String username, String password) {
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void connect() throws Exception {
        this.socket = new Socket("localhost", this.port);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.authenticate();
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void authenticate() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("username", (Object)this.username);
        obj.put("password", (Object)this.password);
        obj.put("request_id", (Object)new Integer(1));
        this.send(obj.toString());
        String resp = this.read();
        JSONObject jResp = new JSONObject(resp);
    }

    public void send(String msg) throws Exception {
        this.out.writeBytes(msg);
        this.out.flush();
    }

    public String read() throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        String resp = reader.readLine();
        return resp;
    }
}

