/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.terminal;

import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.xnode.bootstrap.DataEngineXNode;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.database.DBService;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryService;
import com.manageengine.dataengine.xnode.terminal.IOHandler;
import com.manageengine.dataengine.xnode.terminal.JLineIOHandler;
import com.manageengine.dataengine.xnode.terminal.RootCmd;
import com.manageengine.dataengine.xnode.terminal.TerminalRole;
import com.manageengine.dataengine.xnode.terminal.TerminalRoleManager;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class XNodeTerminal {
    private static String shellPrompt;
    private static String loginName;
    private static String password;
    private static TerminalRole userRole;
    private static IOHandler ioHandle;
    private static DEService dataRepositoryService;
    private static DEService databaseService;
    public static final RootCmd ROOT;
    protected static int maxStringSizePrinted;
    private static final String FORMAT = "%s[%-50s] %3d%% %s %5d/%-5d\r";
    private static final Logger LOGGER;

    public static void main(String[] arg) {
        XNodeTerminal.doStart();
    }

    private static void doStart() {
        boolean status = false;
        boolean run = true;
        try {
            LOGGER.info("------------------------------------------------------------------------------------");
            LOGGER.info("#########################        DataEngine Terminal       #########################");
            LOGGER.info("------------------------------------------------------------------------------------");
            LOGGER.info("BOOTSTRAPING XNode Terminal...");
            Environment.XNODE_START_TYPE.set((Object)DataEngineXNode.StartType.CMD.ordinal());
            Environment.initialize();
            ioHandle = new JLineIOHandler();
            shellPrompt = "xnode # ";
            userRole = TerminalRoleManager.getRole("operator");
            XNodeTerminal.initBootstrapServices();
            if (XNodeTerminal.startBootstrapServices()) {
                while (run) {
                    XNodeTerminal.printBanner();
                    while (!XNodeTerminal.authenticate()) {
                        ioHandle.print("\nAuthentication failed! Retry\n\n\n");
                    }
                    run = XNodeTerminal.listenConsole();
                }
            } else {
                ioHandle.print("\nEXCEPTION while bootstraping DataEngine Terminal!\n\n");
                LOGGER.error("EXCEPTION while bootstraping DataEngine Terminal!");
            }
        }
        catch (Throwable e) {
            LOGGER.info("EXCEPTION while bootstraping DataEngine Terminal! Error : " + e);
            e.printStackTrace();
            try {
                ioHandle.print("\n# ERROR \n\n" + e.getMessage() + "\n\nExiting!!\n\n");
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    private static void doStop() {
        ioHandle.print("\n\n Bye!\n\n");
        ioHandle.flush();
        LOGGER.info("User '" + loginName + "' EXITED the terminal!");
        LOGGER.info("Going to SHUTDOWN XNode Terminal...");
        try {
            XNodeTerminal.stopBootstrapServices();
            boolean isClosed = XNodeTerminal.closeBootstrapServices();
            while (!isClosed) {
                LOGGER.info("XNode NOT SHUTDOWN, waiting for 300ms");
                ioHandle.print("\n XNode NOT SHUTDOWN, waiting for 300ms!\n");
                Thread.sleep(300L);
                isClosed = XNodeTerminal.closeBootstrapServices();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
        }
        LOGGER.info("XNode SHUTDOWN!!");
    }

    private static void initBootstrapServices() {
        databaseService = new DBService();
        dataRepositoryService = new DataRepositoryService();
    }

    private static boolean startBootstrapServices() throws Exception {
        boolean status = false;
        try {
            status = databaseService.start();
            if (status) {
                status = dataRepositoryService.start();
            }
        }
        catch (Throwable e) {
            status = false;
            ioHandle.print("\nDataEngine-XNode is running! Please shutdown it and connect again.\n\n");
            LOGGER.error("DataEngine-XNode is running! Please shutdown it and connect again." + e.getMessage());
        }
        return status;
    }

    private static boolean stopBootstrapServices() throws Exception {
        boolean status = true;
        if (dataRepositoryService != null) {
            status |= dataRepositoryService.stop();
        }
        if (databaseService != null) {
            status |= databaseService.stop();
        }
        return status;
    }

    private static boolean closeBootstrapServices() throws Exception {
        boolean status = true;
        if (dataRepositoryService != null) {
            status |= dataRepositoryService.close();
        }
        if (databaseService != null) {
            status |= databaseService.close();
        }
        return status;
    }

    private static void printBanner() throws IOException {
        ioHandle.print("****************************************************************************************\n");
        ioHandle.print("*                                                                                      *\n");
        ioHandle.print("*                                    XNode Terminal                                    *\n");
        ioHandle.print("*                                                                                      *\n");
        ioHandle.print("****************************************************************************************\n\n");
    }

    private static boolean authenticate() {
        boolean result = false;
        try {
            loginName = ioHandle.readLine("Username : ");
            password = ioHandle.readLine("Password : ", Character.valueOf('*'));
            loginName = loginName.toLowerCase();
            if (loginName.equals("alpha") && password.equals("alpha")) {
                XNodeTerminal.handleSuccessfullLogin();
                return true;
            }
            if (loginName.equals("operator") && password.equals("operator")) {
                XNodeTerminal.handleSuccessfullLogin();
                return true;
            }
            LOGGER.info("User '" + loginName + "' - log-in attempt FAILED!");
        }
        catch (Exception loginException) {
            loginException.printStackTrace();
        }
        return result;
    }

    private static void handleSuccessfullLogin() throws Exception {
        LOGGER.info("User '" + loginName + "' LOGGED-IN successfully!");
        ioHandle.print("\n\nWelcome " + loginName + "!\n\n\n");
        shellPrompt = loginName + "@xnode # ";
        ioHandle.setPrompt(shellPrompt);
        userRole = TerminalRoleManager.getEquivalentRole(loginName);
        JSONArray jCmdList = ROOT.getCommandTree();
        LinkedList<Completer> argumentCompleterList = new LinkedList<Completer>();
        XNodeTerminal.buildCommandSuggestionTree(jCmdList, new LinkedList<String>(), argumentCompleterList);
        ioHandle.addCompleter(new AggregateCompleter(argumentCompleterList));
    }

    private static void handleLogout() {
        ioHandle.print("\n\n Bye " + loginName + "!\n\n");
        ioHandle.flush();
        LOGGER.info("User '" + loginName + "' LOGGED-OUT!");
        userRole = TerminalRoleManager.getRole("operator");
        ioHandle.clearCompleters();
    }

    private static void buildCommandSuggestionTree(JSONArray jCmdList, LinkedList<String> parentCmdList, LinkedList<Completer> argumentCompleterList) throws Exception {
        LinkedList<Object> currentCompleterList = new LinkedList<Object>();
        for (String parentCmd : parentCmdList) {
            currentCompleterList.add(new StringsCompleter(new String[]{parentCmd}));
        }
        LinkedList<String> currentLeafNodeList = new LinkedList<String>();
        int index = 0;
        for (index = 0; index < jCmdList.length(); ++index) {
            JSONObject node = jCmdList.getJSONObject(index);
            String cmdName = node.getString("nodeName");
            JSONArray childCmdList = node.optJSONArray("nodeChildList");
            if (childCmdList == null || childCmdList.length() == 0) {
                currentLeafNodeList.add(cmdName);
                continue;
            }
            parentCmdList.add(cmdName);
            XNodeTerminal.buildCommandSuggestionTree(childCmdList, parentCmdList, argumentCompleterList);
            parentCmdList.pollLast();
        }
        StringsCompleter currentLeafNodeCompleter = new StringsCompleter(currentLeafNodeList);
        currentCompleterList.add(currentLeafNodeCompleter);
        currentCompleterList.add(new NullCompleter());
        argumentCompleterList.add((Completer)new ArgumentCompleter(currentCompleterList));
    }

    private static boolean listenConsole() {
        boolean run = true;
        String inputCmd = "";
        boolean listen = true;
        while (listen) {
            try {
                inputCmd = ioHandle.readLine().trim();
                if (inputCmd.equalsIgnoreCase("exit")) {
                    XNodeTerminal.doStop();
                    listen = false;
                    run = false;
                    continue;
                }
                if (inputCmd.equalsIgnoreCase("account logout")) {
                    XNodeTerminal.handleLogout();
                    listen = false;
                    run = true;
                    continue;
                }
                if (inputCmd.endsWith("?")) {
                    ROOT.showSuggestions(inputCmd.toString().trim().toLowerCase().split("\\s+"), 0);
                    continue;
                }
                if (inputCmd.equalsIgnoreCase("cls")) {
                    ioHandle.clearScreen();
                    continue;
                }
                if (inputCmd.isEmpty()) continue;
                LOGGER.info("PROCESSING command '" + inputCmd + "'");
                ROOT.process(inputCmd.trim().split("\\s+"), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("\n# ERROR \n\n" + e.getMessage() + "\n");
                try {
                    ioHandle.print("\n# ERROR \n\n" + e.getMessage() + "\n");
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
        return run;
    }

    protected static void printProgressInConsole(String message, int total, int processed) {
        String msgToBePrinted;
        String position = new String(new char[maxStringSizePrinted]).replace("\u0000", "\b");
        int pers = processed * 100 / total;
        String completed = "";
        if (pers != 0) {
            completed = new String(new char[pers / 2]).replace("\u0000", "=");
        }
        if ((msgToBePrinted = String.format(FORMAT, position, completed, pers, message, processed, total)).length() < maxStringSizePrinted) {
            msgToBePrinted = msgToBePrinted + new String(new char[maxStringSizePrinted - msgToBePrinted.length()]).replace("\u0000", " ");
        }
        maxStringSizePrinted = msgToBePrinted.length();
        ioHandle.print(msgToBePrinted);
        if (pers == 100) {
            ioHandle.println("");
        }
        ioHandle.flush();
    }

    public static TerminalRole currentUserRole() {
        return userRole;
    }

    public static IOHandler ioHandler() {
        return ioHandle;
    }

    static {
        loginName = null;
        password = null;
        dataRepositoryService = null;
        databaseService = null;
        ROOT = new RootCmd();
        maxStringSizePrinted = 0;
        LOGGER = LogManager.getLogger((String)"Terminal");
    }
}

