/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.cluster;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.omg.CORBA.ORB;
import weblogic.corba.client.cluster.DummySocket;
import weblogic.corba.client.utils.EndPointInfo;
import weblogic.corba.j2ee.naming.ORBHelper;

public class ORBSocketFactory
implements com.sun.corba.se.spi.legacy.connection.ORBSocketFactory {
    protected static final boolean DEBUG = false;
    private static final String ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME = "weblogic.thinclient.enableClusterFailOver";
    private static final boolean ENABLE_CLUSTER_FAILOVER = ORBSocketFactory.initializeEnableClusterFailOverProperty();
    private int timeout = -1;

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        return ServerSocketFactory.getDefault().createServerSocket(port);
    }

    public SocketInfo getEndPointInfo(ORB orb, IOR ior, SocketInfo endPointInfo) {
        if (this.timeout < 0) {
            this.timeout = ORBHelper.getORBHelper().getORBTimeout(orb);
        }
        IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
        IIOPAddress primary = temp.getPrimaryAddress();
        return new EndPointInfo(primary.getHost(), primary.getPort(), "IIOP_CLEAR_TEXT");
    }

    public Socket createSocket(SocketInfo endPointInfo) throws IOException {
        try {
            Socket sock = SocketFactory.getDefault().createSocket();
            sock.connect(new InetSocketAddress(endPointInfo.getHost(), endPointInfo.getPort()), this.timeout);
            sock.setSoTimeout(this.timeout);
            return sock;
        }
        catch (IOException ie) {
            if (endPointInfo.getHost().trim().length() == 0) {
                return new DummySocket();
            }
            if (!ENABLE_CLUSTER_FAILOVER) {
                throw ie;
            }
            if (ie instanceof ConnectException || ie instanceof NoRouteToHostException || ie instanceof SocketTimeoutException) {
                return new DummySocket();
            }
            throw ie;
        }
    }

    protected static void p(String s) {
        System.err.println("<ORBSocketFactory> " + s);
    }

    private static boolean initializeEnableClusterFailOverProperty() {
        boolean enabled = true;
        try {
            enabled = System.getProperty(ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME, "true").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return enabled;
    }
}

