/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.omg.CORBA.ORB;
import weblogic.corba.client.cluster.DummySocket;
import weblogic.corba.client.iiop.BiDirSSLSocketFactory;
import weblogic.corba.client.security.SSLORBSocketFactory;

public class BiDirSSLORBSocketFactory
extends SSLORBSocketFactory {
    private BiDirSSLSocketFactory factory = new BiDirSSLSocketFactory();
    private static final String ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME = "weblogic.thinclient.enableClusterFailOver";
    private static final boolean ENABLE_CLUSTER_FAILOVER = BiDirSSLORBSocketFactory.initializeEnableClusterFailOverProperty();

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        if (DEBUG) {
            BiDirSSLORBSocketFactory.p("createServerSocket(" + type + ", " + port + ")");
        }
        return this.factory.createServerSocket(port);
    }

    public SocketInfo getEndPointInfo(ORB orb, IOR ior, SocketInfo endPointInfo) {
        this.factory.initializeInterceptor(orb);
        return super.getEndPointInfo(orb, ior, endPointInfo);
    }

    public Socket createSocket(SocketInfo endPointInfo) throws IOException {
        if (DEBUG) {
            BiDirSSLORBSocketFactory.p("createSocket(" + endPointInfo.getHost() + ":" + endPointInfo.getPort() + ", " + endPointInfo.getType() + ")");
        }
        try {
            return this.factory.createSocket(endPointInfo.getHost(), endPointInfo.getPort(), super.createSocket(endPointInfo), this);
        }
        catch (IOException ie) {
            if (!ENABLE_CLUSTER_FAILOVER) {
                throw ie;
            }
            if (ie instanceof ConnectException || ie instanceof NoRouteToHostException || ie instanceof SocketTimeoutException) {
                if (DEBUG) {
                    BiDirSSLORBSocketFactory.p("created DummySocket()");
                }
                return new DummySocket();
            }
            throw ie;
        }
    }

    protected static void p(String s) {
        System.err.println("<BiDirSSLORBSocketFactory> " + s);
    }

    private static boolean initializeEnableClusterFailOverProperty() {
        boolean enabled = true;
        try {
            enabled = System.getProperty(ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME, "true").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return enabled;
    }
}

