/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.kernel.KernelStatus;

public class BiDirSocketImpl
extends SocketImpl
implements Runnable {
    private boolean closed = false;
    private boolean server = false;
    protected String host;
    private PipedInputStream inpipe;
    protected PipedOutputStream outpipe;
    private BiDirOutputStream out;
    protected BiDirSocketImpl serverImpl = null;
    protected BiDirSocketFactory factory;
    private Socket realSocket;
    private OutputStream realOut;
    protected static final int MSG_HEADER_LENGTH = 12;
    protected static final int MSG_TYPE_POS = 7;
    private static final int READ_PIPE_SIZE = 1024;
    private static final boolean DEBUG = BiDirSocketImpl.getDebug();
    private static int GIOP_FLAGS_POS = 6;
    private static int GIOP_SIZE_POS = 8;
    private static ThreadGroup responseReaderThreadGroup = null;
    private static boolean hasThreadGroupAccess = true;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception e) {
            return false;
        }
    }

    public BiDirSocketImpl(BiDirSocketFactory factory) {
        this.factory = factory;
        this.localport = factory.getLocalAddress().getPort();
        this.out = new BiDirOutputStream(this);
    }

    public BiDirSocketImpl(Socket sock, BiDirSocketFactory factory) {
        this(factory);
        this.realSocket = sock;
    }

    protected BiDirSocketImpl(BiDirSocketImpl impl, boolean server) throws IOException {
        this.out = new BiDirOutputStream(impl);
        this.server = server;
        this.inpipe = new PipedInputStream();
        this.outpipe = new PipedOutputStream(this.inpipe);
        this.port = impl.port;
        this.host = impl.host;
        this.address = impl.address;
        this.factory = impl.factory;
        this.closed = false;
    }

    boolean isServer() {
        return this.server;
    }

    protected void create(boolean stream) throws IOException {
        if (DEBUG) {
            this.p("create(" + stream + ")");
        }
    }

    protected void connect(InetAddress address, int port) throws IOException {
        if (DEBUG) {
            this.p("connect(" + address + ", " + port + ")");
        }
        this.connect(new InetSocketAddress(address, port));
    }

    protected void connect(String host, int port) throws IOException {
        if (DEBUG) {
            this.p("connect(" + host + ", " + port + ")");
        }
        this.connect(new InetSocketAddress(host, port));
    }

    protected void connect(SocketAddress address, int timeout) throws IOException {
        if (DEBUG) {
            this.p("connect(" + address + ", " + timeout + ")");
        }
        this.connect((InetSocketAddress)address);
    }

    protected void bind(InetAddress host, int port) throws IOException {
        if (DEBUG) {
            this.p("bind(" + host + ", " + port + ")");
        }
    }

    protected void listen(int backlog) throws IOException {
        if (DEBUG) {
            this.p("listen(" + backlog + ")");
        }
    }

    protected synchronized void accept(SocketImpl s) throws IOException {
        if (DEBUG) {
            this.p("accept(" + s + ")");
        }
    }

    protected InputStream getInputStream() throws IOException {
        if (DEBUG) {
            this.p("getInputStream()");
        }
        if (this.inpipe == null || this.isClosed()) {
            throw new IOException("The connection is closed");
        }
        return this.inpipe;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (DEBUG) {
            this.p("getOutputStream()");
        }
        if (this.out == null || this.isClosed()) {
            throw new IOException("The connection is closed");
        }
        return this.out;
    }

    protected int available() throws IOException {
        if (DEBUG) {
            this.p("available()");
        }
        if (this.inpipe == null || this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        return this.inpipe.available();
    }

    protected synchronized void close() throws IOException {
        if (DEBUG) {
            this.p("close()");
        }
        this.inpipe.close();
        this.out.close();
        this.closed = true;
        if (this.realOut != null) {
            this.realOut.close();
        }
        if (this.realSocket != null) {
            this.realSocket.close();
        }
    }

    protected synchronized boolean isClosed() {
        return this.closed;
    }

    protected void shutdownInput() throws IOException {
        if (DEBUG) {
            this.p("shutdownInput()");
        }
    }

    protected void shutdownOutput() throws IOException {
        if (DEBUG) {
            this.p("shutdownOutput()");
        }
    }

    protected void sendUrgentData(int data) throws IOException {
        if (DEBUG) {
            this.p("sendUrgentData(" + data + ")");
        }
    }

    public Object getOption(int n) throws SocketException {
        if (DEBUG) {
            this.p("getOption(" + n + ")");
        }
        return null;
    }

    public void setOption(int n, Object object) throws SocketException {
        if (DEBUG) {
            this.p("setOption(" + n + ", " + object + ")");
        }
        if (this.realSocket != null) {
            switch (n) {
                case 1: {
                    this.realSocket.setTcpNoDelay((Boolean)object);
                }
            }
        }
    }

    private synchronized void connect(InetSocketAddress address) throws IOException {
        if (DEBUG) {
            this.p("connect(" + address + ")");
        }
        if (this.isServer()) {
            return;
        }
        this.host = address.getHostName();
        this.port = address.getPort();
        this.address = address.getAddress();
        this.connectInternal();
        if (DEBUG) {
            this.p("connect() succesful to " + this.host + ":" + this.port);
        }
        this.closed = false;
        this.inpipe = new PipedInputStream();
        this.outpipe = new PipedOutputStream(this.inpipe);
        this.serverImpl = this.createServerImpl();
        this.factory.acceptOrQueueServerImpl(this.serverImpl);
        Thread responseHandler = BiDirSocketImpl.createResponseThread(this);
        responseHandler.setDaemon(true);
        responseHandler.start();
    }

    protected BiDirSocketImpl createServerImpl() throws IOException {
        return new BiDirSocketImpl(this, true);
    }

    protected void connectInternal() throws IOException {
        if (this.realSocket == null) {
            this.realSocket = new Socket();
            this.realSocket.connect(new InetSocketAddress(this.host, this.port), this.factory.getTimeout());
        }
        this.realSocket.setSoTimeout(60000);
        this.realOut = this.realSocket.getOutputStream();
    }

    BiDirSocketImpl getServerImpl() {
        return this.serverImpl;
    }

    public int getServerPort() {
        return this.getPort();
    }

    public String getServerHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            is = this.realSocket.getInputStream();
            while (!this.isClosed()) {
                Object res = null;
                int type = -1;
                boolean requestType = false;
                long now = System.currentTimeMillis();
                this.readBytes(is, buf, 0, 12);
                type = buf[7];
                switch (type) {
                    case 0: 
                    case 2: 
                    case 3: {
                        requestType = true;
                    }
                }
                if (type < 0) {
                    throw new ProtocolException("Bad inbound GIOP message");
                }
                int remaining = BiDirSocketImpl.getMsgLength(buf);
                int toread = BiDirSocketImpl.min(remaining - 12, 1012);
                this.readBytes(is, buf, 12, toread);
                toread += 12;
                if (DEBUG) {
                    this.p("run(): reading GIOP message: " + type + " of length: " + remaining);
                }
                do {
                    remaining -= toread;
                    if (requestType) {
                        if (DEBUG) {
                            this.p("run(): received ServerSocket request: " + type + " " + toread + " bytes in " + (System.currentTimeMillis() - now) + "ms");
                        }
                        this.serverImpl.outpipe.write(buf, 0, toread);
                    } else {
                        if (DEBUG) {
                            this.p("run(): received Socket response: " + type + " " + toread + " bytes in " + (System.currentTimeMillis() - now) + "ms");
                        }
                        this.outpipe.write(buf, 0, toread);
                    }
                    now = System.currentTimeMillis();
                    toread = BiDirSocketImpl.min(remaining, 1024);
                } while (remaining > 0 && this.readBytes(is, buf, 0, toread));
                if (requestType) {
                    this.serverImpl.outpipe.flush();
                } else {
                    this.outpipe.flush();
                }
                if (!DEBUG) continue;
                this.p("run(): dispatched message");
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            if (DEBUG) {
                t.printStackTrace();
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.factory.removeServerImpl(this.serverImpl);
        try {
            this.outpipe.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.serverImpl.outpipe.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.serverImpl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final boolean readBytes(InputStream is, byte[] buf, int offset, int len) throws IOException {
        while (len > 0) {
            try {
                int r = is.read(buf, offset, len);
                if (r <= 0) {
                    throw new IOException("End of stream");
                }
                len -= r;
                offset += r;
            }
            catch (SocketTimeoutException ste) {
                if (this.factory.isPeerGone()) {
                    if (DEBUG) {
                        this.p("readBytes(): timed out, giving up");
                    }
                    throw ste;
                }
                if (!DEBUG) continue;
                this.p("readBytes(): timed out, retrying");
            }
        }
        return true;
    }

    protected synchronized void write(byte[] buf, int off, int len) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        this.realOut.write(buf, off, len);
    }

    protected static final int getMsgLength(byte[] buf) {
        byte byteOrder = (byte)(buf[GIOP_FLAGS_POS] & 1);
        int pos = GIOP_SIZE_POS;
        int b1 = buf[pos++] & 0xFF;
        int b2 = buf[pos++] & 0xFF;
        int b3 = buf[pos++] & 0xFF;
        int b4 = buf[pos++] & 0xFF;
        if (byteOrder == 0) {
            return 12 + (b1 << 24 | b2 << 16 | b3 << 8 | b4);
        }
        return 12 + (b4 << 24 | b3 << 16 | b2 << 8 | b1);
    }

    private static final int min(int a, int b) {
        return a <= b ? a : b;
    }

    private final void p(String msg) {
        System.out.println("<BiDirSocketImpl (" + System.identityHashCode(this) + ")>: " + msg);
    }

    private static Thread createResponseThread(Runnable runnable) {
        String name = "Tunneling Response Thread";
        if (!KernelStatus.isApplet()) {
            return new Thread(runnable, name);
        }
        BiDirSocketImpl.initializeResponseReaderThreadGroup();
        if (hasThreadGroupAccess && responseReaderThreadGroup != null) {
            return new Thread(responseReaderThreadGroup, runnable, name);
        }
        return new Thread(runnable, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeResponseReaderThreadGroup() {
        if (!hasThreadGroupAccess || responseReaderThreadGroup != null) return;
        Class<BiDirSocketImpl> clazz = BiDirSocketImpl.class;
        synchronized (BiDirSocketImpl.class) {
            if (responseReaderThreadGroup != null) return;
            try {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (true) {
                    if (tg.getName().equals("main") && tg.getParent().getName().equals("system")) {
                        ThreadGroup theParent = tg;
                        responseReaderThreadGroup = new ThreadGroup(theParent, "Response Reader ThreadGroup"){

                            public String toString() {
                                return "ResponseReaderThreadGroup(name=" + this.getName() + ", parent=" + this.getParent() + ")";
                            }
                        };
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    tg = tg.getParent();
                }
            }
            catch (SecurityException se) {
                System.out.println(" +++ <Warining> Don't have permissions to access ThreadGroup.  We strongly recommend to use signed applet.");
                System.out.println(" +++ <Warining> Proceed further without creating ThreadGroup.");
                hasThreadGroupAccess = false;
            }
            return;
        }
    }

    private static class BiDirOutputStream
    extends OutputStream {
        private BiDirSocketImpl sock;

        private BiDirOutputStream(BiDirSocketImpl sock) {
            this.sock = sock;
        }

        public void write(int b) throws IOException {
            throw new IOException("write(int) not supported");
        }

        public void write(byte[] buf) throws IOException {
            this.write(buf, 0, buf.length);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this.sock.write(buf, off, len);
        }

        public void close() throws IOException {
        }
    }
}

