/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.util.HashMap;
import javax.security.auth.Subject;
import org.omg.IOP.ServiceContext;

public class ClientSecurityContext {
    private static long nextClientContextId = 0L;
    private static HashMap statefulClientContextTable = new HashMap();
    private long contextId;
    private ServiceContext contextMessage;
    private Subject subject;

    public ClientSecurityContext(long contextId, Subject subject) {
        this.contextId = contextId;
        this.subject = subject;
    }

    public ServiceContext getMessageInContext() {
        return this.contextMessage;
    }

    public long getContextId() {
        return this.contextId;
    }

    public void setMessageInContext(ServiceContext contextMessage) {
        this.contextMessage = contextMessage;
    }

    public static final synchronized ClientSecurityContext allocateClientContext(Subject subject) {
        ClientSecurityContext csc = (ClientSecurityContext)statefulClientContextTable.get(subject);
        if (csc == null) {
            csc = new ClientSecurityContext(++nextClientContextId, subject);
            statefulClientContextTable.put(subject, csc);
            statefulClientContextTable.put(new Long(csc.getContextId()), csc);
        }
        return csc;
    }

    public static final synchronized ClientSecurityContext getClientContext(Subject subject) {
        return (ClientSecurityContext)statefulClientContextTable.get(subject);
    }

    public static final synchronized ClientSecurityContext getClientContext(long clientContextId) {
        return (ClientSecurityContext)statefulClientContextTable.get(new Long(clientContextId));
    }

    public static final synchronized ClientSecurityContext removeClientContext(long contextId) {
        ClientSecurityContext csc = (ClientSecurityContext)statefulClientContextTable.remove(new Long(contextId));
        statefulClientContextTable.remove(csc.subject);
        return csc;
    }

    public static final synchronized long getNextClientContextId() {
        return ++nextClientContextId;
    }
}

