/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.SocketInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SSL_SEC_TRANS;
import org.omg.CSIIOP.SSL_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import weblogic.corba.client.security.SSLEndPointInfo;
import weblogic.corba.j2ee.naming.ORBHelper;

public class SSLORBSocketFactory
implements ORBSocketFactory {
    private Hashtable epiCache = new Hashtable();
    private int timeout = -1;
    protected static final boolean DEBUG = SSLORBSocketFactory.getDebug();
    private static final String proxyHost = SSLORBSocketFactory.getProxyHost();
    private static final int proxyPort = SSLORBSocketFactory.getProxyPort();

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.ssl");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final String getProxyHost() {
        try {
            return System.getProperty("iiops.ProxyHost");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final int getProxyPort() {
        try {
            return Integer.getInteger("iiops.ProxyPort", 80);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public SSLORBSocketFactory() {
        if (DEBUG) {
            SSLORBSocketFactory.p("initialized");
        }
        boolean verify = false;
        try {
            String prop = System.getProperty("weblogic.security.SSL.ignoreHostnameVerification");
            if (prop != null && prop.equalsIgnoreCase("false")) {
                verify = true;
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            if (!verify) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String host, SSLSession sslsession) {
                        return true;
                    }
                });
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int cacheSize = Integer.getInteger("weblogic.security.SSL.clientSessionCacheSize", 1);
            SSLContext.getInstance("Default").getClientSessionContext().setSessionCacheSize(cacheSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        if (DEBUG) {
            SSLORBSocketFactory.p("createServerSocket(" + type + ", " + port + ")");
        }
        if (type == "IIOP_SSL_WLS") {
            return SSLServerSocketFactory.getDefault().createServerSocket(port);
        }
        return ServerSocketFactory.getDefault().createServerSocket(port);
    }

    public SocketInfo getEndPointInfo(org.omg.CORBA.ORB orb, IOR ior, SocketInfo endPointInfo) {
        if (DEBUG) {
            SSLORBSocketFactory.p("getEndPointInfo(" + ior + ")");
        }
        if (this.timeout < 0) {
            this.timeout = ORBHelper.getORBHelper().getORBTimeout(orb);
        }
        if ((endPointInfo = (SocketInfo)this.epiCache.get(ior)) == null) {
            IIOPAddress primary;
            block18: {
                SSLContext ctx = ORBHelper.getORBHelper().getSSLContext(orb);
                if (DEBUG && ctx != null) {
                    SSLORBSocketFactory.p("getEndPointInfo() found SSLContext");
                }
                boolean useTLS = true;
                IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                primary = temp.getPrimaryAddress();
                TaggedComponent[] comps = temp.getIOPComponents((ORB)orb, 33);
                if (comps.length == 0) {
                    comps = temp.getIOPComponents((ORB)orb, 20);
                    useTLS = false;
                }
                if (comps.length > 0) {
                    try {
                        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
                        Encoding encoding = new Encoding(0, 1, 2);
                        Codec codec = codecFactory.create_codec(encoding);
                        if (useTLS) {
                            if (DEBUG) {
                                SSLORBSocketFactory.p("found " + comps.length + " CompoundSecMechList components");
                            }
                            Any a = codec.decode_value(comps[0].component_data, CompoundSecMechListHelper.type());
                            CompoundSecMechList csml = CompoundSecMechListHelper.extract(a);
                            if (csml.mechanism_list != null) {
                                for (int i = 0; i < csml.mechanism_list.length; ++i) {
                                    TaggedComponent tlscomp = csml.mechanism_list[i].transport_mech;
                                    if (tlscomp.tag != 36) continue;
                                    a = codec.decode_value(tlscomp.component_data, TLS_SEC_TRANSHelper.type());
                                    TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.extract(a);
                                    if (tls.addresses.length <= 0) continue;
                                    if (DEBUG) {
                                        SSLORBSocketFactory.p("found TAG_TLS_SEC_TRANS component " + tls.addresses[0].host_name + ":" + tls.addresses[0].port);
                                    }
                                    endPointInfo = new SSLEndPointInfo(tls.addresses[0].host_name, tls.addresses[0].port & 0xFFFF, "IIOP_SSL_WLS", ctx);
                                }
                            }
                            break block18;
                        }
                        Any a = codec.decode_value(comps[0].component_data, SSL_SEC_TRANSHelper.type());
                        SSL_SEC_TRANS ssl = SSL_SEC_TRANSHelper.extract(a);
                        if (DEBUG) {
                            SSLORBSocketFactory.p("found TAG_SSL_SEC_TRANS component " + ssl.port);
                        }
                        endPointInfo = new SSLEndPointInfo(primary.getHost(), ssl.port & 0xFFFF, "IIOP_SSL_WLS", ctx);
                    }
                    catch (UserException ue) {
                        if (DEBUG) {
                            ue.printStackTrace();
                            SSLORBSocketFactory.p("problem decoding TLS/SSL components in IOR");
                        }
                        break block18;
                    }
                }
                String oid = new String(ior.getProfile().getObjectKey().getId().getId());
                if (oid.equals("NameService") || oid.equals("INIT")) {
                    endPointInfo = new SSLEndPointInfo(primary.getHost(), primary.getPort(), "IIOP_SSL_WLS", ctx);
                }
            }
            if (endPointInfo == null) {
                endPointInfo = new SSLEndPointInfo(primary.getHost(), primary.getPort(), "IIOP_CLEAR_TEXT", null);
                if (DEBUG) {
                    SSLORBSocketFactory.p("couldn't find TAG_TLS_SEC_TRANS component for " + ior.getTypeId());
                }
            }
            this.epiCache.put(ior, endPointInfo);
        }
        return endPointInfo;
    }

    public Socket createSocket(SocketInfo endPointInfo) throws IOException {
        if (DEBUG) {
            SSLORBSocketFactory.p("createSocket(" + endPointInfo.getHost() + ":" + endPointInfo.getPort() + ", " + endPointInfo.getType() + ")");
        }
        SocketFactory fact = null;
        try {
            if (endPointInfo.getType() == "IIOP_SSL_WLS") {
                fact = ((SSLEndPointInfo)endPointInfo).getContext() != null ? ((SSLEndPointInfo)endPointInfo).getContext().getSocketFactory() : SSLSocketFactory.getDefault();
                if (proxyHost != null && proxyPort > 0) {
                    return SSLORBSocketFactory.createProxySSLSocket((SSLSocketFactory)fact, endPointInfo.getHost(), endPointInfo.getPort(), proxyHost, proxyPort);
                }
            } else {
                fact = SocketFactory.getDefault();
            }
            Socket sock = fact.createSocket();
            sock.connect(new InetSocketAddress(endPointInfo.getHost(), endPointInfo.getPort()), this.timeout);
            sock.setSoTimeout(this.timeout);
            return sock;
        }
        catch (IOException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (IllegalStateException ise) {
            if (DEBUG) {
                ise.printStackTrace();
            }
            throw ise;
        }
    }

    private static final Socket createProxySSLSocket(SSLSocketFactory fact, String host, int port, String proxyHost, int proxyPort) throws IOException {
        Socket sock = SocketFactory.getDefault().createSocket(proxyHost, proxyPort);
        String connect = new String("CONNECT " + host + ":" + port + " HTTP/1.1\r\n\r\n");
        if (DEBUG) {
            SSLORBSocketFactory.p("Proxy conect: " + connect);
        }
        OutputStream os = sock.getOutputStream();
        os.write(connect.getBytes());
        os.flush();
        DataInputStream dis = new DataInputStream(sock.getInputStream());
        String resp = dis.readLine();
        if (DEBUG) {
            SSLORBSocketFactory.p("Proxy response: " + resp);
        }
        StringTokenizer toks = new StringTokenizer(resp);
        try {
            toks.nextToken();
            int code = Integer.parseInt(toks.nextToken());
            if (code < 200 || code > 299) {
                throw new ConnectException("HTTP error: " + code);
            }
            if (DEBUG) {
                SSLORBSocketFactory.p("Proxy connected: " + code);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ConnectException("Bad HTTP response");
        }
        catch (NumberFormatException nfe) {
            throw new ConnectException("Bad HTTP response");
        }
        String line = null;
        while ((line = dis.readLine()).length() > 0) {
            if (!DEBUG) continue;
            SSLORBSocketFactory.p("Discarding: " + line);
        }
        return fact.createSocket(sock, host, port, true);
    }

    protected static void p(String s) {
        System.err.println("<SSLORBSocketFactory> " + s);
    }

    public void clearCache() {
        this.epiCache.clear();
    }
}

