/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.transaction;

import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import weblogic.corba.j2ee.transaction.TransactionManagerImpl;

public final class TransactionInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = TransactionInterceptor.getDebug();
    public static final String NAME = "TransactionInterceptor";
    private static final int TX_CONTEXT = 0;
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.ots");
        }
        catch (Exception e) {
            return false;
        }
    }

    public TransactionInterceptor(Current piCurrent, Codec codec, int slot) {
        this.piCurrent = piCurrent;
        this.codec = codec;
        this.slot = slot;
    }

    public String name() {
        return NAME;
    }

    public void setTransaction(UserTransaction ut) throws SystemException {
        try {
            Any any = ORB.init().create_any();
            if (ut != null) {
                any.insert_Value((Serializable)((Object)ut));
            }
            this.piCurrent.set_slot(this.slot, any);
        }
        catch (InvalidSlot is) {
            throw new SystemException(is.getMessage());
        }
        catch (ClassCastException cce) {
            throw new SystemException(cce.getMessage());
        }
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (DEBUG) {
            TransactionInterceptor.p("send_request(<" + Integer.toHexString(ri.effective_target()._hash(Integer.MAX_VALUE)) + ">." + ri.operation() + ")");
        }
        try {
            TransactionManagerImpl ut;
            Any any = ri.get_slot(this.slot);
            if (!any.type().kind().equals(TCKind.tk_null) && (ut = (TransactionManagerImpl)any.extract_Value()).get_txcontext() != null) {
                ri.add_request_service_context(this.createTxContext(ut.get_txcontext()), true);
            }
        }
        catch (InvalidSlot invalidSlot) {
            // empty catch block
        }
    }

    public void send_poll(ClientRequestInfo ri) {
        if (DEBUG) {
            TransactionInterceptor.p("send_poll(" + ri.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        if (DEBUG) {
            TransactionInterceptor.p("receive_reply(" + ri.operation() + ")");
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (DEBUG) {
            TransactionInterceptor.p("receive_exception(" + ri.operation() + ")");
        }
    }

    public void receive_other(ClientRequestInfo ri) {
        if (DEBUG) {
            TransactionInterceptor.p("receive_other(" + ri.operation() + ")");
        }
    }

    private PropagationContext getTxContext(ClientRequestInfo ri) {
        try {
            ServiceContext txsc = ri.get_reply_service_context(0);
            if (DEBUG) {
                TransactionInterceptor.p("found tx context for " + ri.operation() + "()");
            }
            Any a = this.codec.decode_value(txsc.context_data, PropagationContextHelper.type());
            return PropagationContextHelper.extract(a);
        }
        catch (TypeMismatch tm) {
            if (DEBUG) {
                TransactionInterceptor.p("bad tx context in request target for: " + ri.operation() + "()");
            }
        }
        catch (FormatMismatch fm) {
            if (DEBUG) {
                TransactionInterceptor.p("bad tx context in request target for: " + ri.operation() + "()");
            }
        }
        catch (BAD_PARAM bpe) {
            switch (bpe.minor) {
                case 1330446362: {
                    if (!DEBUG) break;
                    TransactionInterceptor.p("no tx context in request target for: " + ri.operation() + "()");
                    break;
                }
                default: {
                    if (DEBUG) {
                        bpe.printStackTrace();
                    }
                    throw bpe;
                }
            }
        }
        return null;
    }

    private ServiceContext createTxContext(PropagationContext ctx) {
        try {
            if (DEBUG) {
                TransactionInterceptor.p("createTxContext(" + ctx + ")");
            }
            Any a = ORB.init().create_any();
            PropagationContextHelper.insert(a, ctx);
            byte[] cdr = this.codec.encode_value(a);
            return new ServiceContext(0, cdr);
        }
        catch (InvalidTypeForEncoding itfee) {
            if (DEBUG) {
                TransactionInterceptor.p("couldn't marshal tx context");
            }
            return null;
        }
    }

    protected static void p(String s) {
        System.err.println("<TransactionInterceptor> " + s);
    }
}

