/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextOutput;

class ContextOutputImpl
implements WorkContextOutput {
    private ArrayList members = new ArrayList();
    private ORB orb;
    private DynAnyFactory factory;

    ContextOutputImpl(ORB orb, DynAnyFactory factory) {
        this.orb = orb;
        this.factory = factory;
    }

    Any get_any() throws InvalidTypeForEncoding {
        try {
            NameValuePair[] nvp = this.members.toArray(new NameValuePair[0]);
            StructMember[] mem = new StructMember[nvp.length];
            for (int i = 0; i < nvp.length; ++i) {
                mem[i] = new StructMember("", nvp[i].value.type(), null);
            }
            DynStruct dynany = DynStructHelper.narrow((Object)this.factory.create_dyn_any_from_type_code(this.orb.create_struct_tc("MyStruct", "MyStruct", mem)));
            dynany.set_members(nvp);
            return dynany.to_any();
        }
        catch (TypeMismatch tm) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)tm);
        }
        catch (InvalidValue iv) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)iv);
        }
        catch (InconsistentTypeCode itc) {
            throw (InvalidTypeForEncoding)new InvalidTypeForEncoding().initCause((Throwable)itc);
        }
    }

    public void write(byte[] byteArray) throws IOException {
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int off, int len) throws IOException {
        Any any = this.orb.create_any();
        TypeCode tc = this.orb.create_array_tc(len, this.orb.get_primitive_tc(TCKind.tk_octet));
        any.type(tc);
        OutputStream out = any.create_output_stream();
        out.write_octet_array(byteArray, off, len);
        any.read_value(out.create_input_stream(), tc);
        this.members.add(new NameValuePair("", any));
    }

    public void write(int n) throws IOException {
        this.writeByte(n);
    }

    public void writeInt(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_long(n);
        this.members.add(new NameValuePair("", any));
    }

    public void writeUTF(String string) throws IOException {
        Any any = this.orb.create_any();
        any.insert_wstring(string);
        this.members.add(new NameValuePair("", any));
    }

    public void writeLong(long l) throws IOException {
        Any any = this.orb.create_any();
        any.insert_longlong(l);
        this.members.add(new NameValuePair("", any));
    }

    public void writeByte(int n) throws IOException {
        this.write((byte)(n & 0xFF));
    }

    public void writeShort(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_short((short)(n & 0xFFFF));
        this.members.add(new NameValuePair("", any));
    }

    public void writeBytes(String string) throws IOException {
        throw new UnsupportedOperationException("writeBytes()");
    }

    public void writeFloat(float f) throws IOException {
        Any any = this.orb.create_any();
        any.insert_float(f);
        this.members.add(new NameValuePair("", any));
    }

    public void writeChar(int n) throws IOException {
        Any any = this.orb.create_any();
        any.insert_wchar((char)(n & 0xFFFF));
        this.members.add(new NameValuePair("", any));
    }

    public void writeBoolean(boolean flag) throws IOException {
        Any any = this.orb.create_any();
        any.insert_boolean(flag);
        this.members.add(new NameValuePair("", any));
    }

    public void writeDouble(double d) throws IOException {
        Any any = this.orb.create_any();
        any.insert_double(d);
        this.members.add(new NameValuePair("", any));
    }

    public void writeChars(String string) throws IOException {
        throw new UnsupportedOperationException("writeChars()");
    }

    public void writeASCII(String string) throws IOException {
        Any any = this.orb.create_any();
        any.insert_string(string);
        this.members.add(new NameValuePair("", any));
    }

    public void writeContext(WorkContext runtimeContext) throws IOException {
        try {
            this.writeASCII(runtimeContext.getClass().getName());
            ContextOutputImpl co = new ContextOutputImpl(this.orb, this.factory);
            runtimeContext.writeContext(co);
            Any any = co.get_any();
            this.members.add(new NameValuePair("", any));
        }
        catch (InvalidTypeForEncoding ite) {
            throw (IOException)new IOException(ite.getMessage()).initCause(ite);
        }
    }
}

