/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.corba.j2ee.naming.ContextImpl;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;

public final class InitialContextFactoryImpl
implements InitialContextFactory {
    private static final boolean DEBUG = false;

    public Context getInitialContext(Hashtable env) throws NamingException {
        String url = env == null ? null : env.remove("java.naming.provider.url");
        if (url == null) {
            url = "iiop://localhost:7001";
        }
        return InitialContextFactoryImpl.getInitialContext(env, url);
    }

    public static Context getInitialContext(Hashtable env, String url) throws NamingException {
        NamingContext ctx = null;
        Object obj = null;
        ORBInfo orbinfo = null;
        if (url.startsWith("IOR:")) {
            orbinfo = ORBHelper.getORBHelper().getCurrent();
            if (orbinfo == null) {
                ORB orb = ORBHelper.getORBHelper().getLocalORB();
                obj = orb.string_to_object(url);
            } else {
                obj = orbinfo.getORB().string_to_object(url);
            }
        } else {
            obj = ORBHelper.getORBHelper().getORBReference(url, env, "NameService");
            orbinfo = ORBHelper.getORBHelper().getCurrent();
        }
        ctx = Utils.narrowContext(obj);
        if (ctx == null) {
            throw new NamingException("Could not resolve context from: " + url);
        }
        ContextImpl ic = new ContextImpl(env, orbinfo, ctx);
        ServiceManager.getSecurityManager().pushSubject(env, ic);
        ORBHelper.getORBHelper().pushTransactionHelper();
        return ic;
    }

    static void p(String s) {
        System.err.println("<InitialContextFactoryImpl> " + s);
    }
}

