/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.j2ee.naming.EndPointInfo;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.corba.orb.ORBHelperImpl;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public class ORBHelper {
    public static final String ORB_INITIAL_HOST = "org.omg.CORBA.ORBInitialHost";
    public static final String ORB_INITIAL_PORT = "org.omg.CORBA.ORBInitialPort";
    public static final String ORB_INITIAL_REF = "org.omg.CORBA.ORBInitRef";
    public static final String ORB_DEFAULT_INITIAL_REF = "org.omg.CORBA.ORBDefaultInitRef";
    public static final String ORB_CLASS_PROP = "org.omg.CORBA.ORBClass";
    public static final String ORB_NAMING_PROP = "java.naming.corba.orb";
    public static final String SUN_SOCKET_FACTORY = "com.sun.CORBA.legacy.connection.ORBSocketFactoryClass";
    public static final String SUN_SOCKET_FACTORY_OLD = "com.sun.CORBA.connection.ORBSocketFactoryClass";
    public static final String SUN_LISTEN_SOCKET = "com.sun.CORBA.connection.ORBListenSocket";
    public static final String SUN_WCHARSET = "com.sun.CORBA.codeset.wcharsets";
    public static final String SUN_FRAGMENT = "com.sun.CORBA.giop.ORBGIOP12BuffMgr";
    public static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String BI_DIR_ORBINIT = "weblogic.corba.client.iiop.BiDirORBInitializer";
    public static final String CLIENT_ORBINIT = "weblogic.corba.client.ClientORBInitializer";
    public static final String CLIENT_PACKAGE = "weblogic.corba.client.";
    public static final String CLIENT_PACKAGE_14 = "weblogic.corba.client14.";
    public static final String BI_DIR_SOCKET_FACTORY = "iiop.BiDirORBSocketFactory";
    public static final String BI_DIR_SSL_SOCKET_FACTORY = "iiop.BiDirSSLORBSocketFactory";
    public static final String SSL_SOCKET_FACTORY = "security.SSLORBSocketFactory";
    public static final String TUNNEL_SOCKET_FACTORY = "http.TunneledORBSocketFactory";
    public static final String TUNNEL_SSL_SOCKET_FACTORY = "http.TunneledSSLORBSocketFactory";
    public static final String CLUSTER_SOCKET_FACTORY = "cluster.ORBSocketFactory";
    public static final String NATIVE_TX_HELPER = "weblogic.corba.server.transaction.TransactionHelperImpl";
    public static final String ENABLE_SERVER_AFFINITY = "weblogic.jndi.enableServerAffinity";
    public static final String ORB_PROTOCOL = "weblogic.corba.orb.ORBProtocol";
    public static final String ORB_NAME = "weblogic.corba.orb.ORBName";
    public static final String INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String REQUEST_TIMEOUT = "weblogic.jndi.requestTimeout";
    public static final String RMI_TIMEOUT = "weblogic.rmi.clientTimeout";
    public static final String SUN_RPC_TRANSPORT_LOGGER = "javax.enterprise.resource.corba._DEFAULT_.rpc.transport";
    public static final String SUN_TCP_READ_TIMEOUTS_PROPERTY = "com.sun.CORBA.transport.ORBTCPReadTimeouts";
    private static final boolean DEBUG = false;
    private static final String FALSE_PROP = "false";
    private static ORBHelper singleton;
    private static boolean enableIIOPClient;
    private static boolean thinClient;
    private boolean dummyORBCreated = false;
    private String orbClassName;
    private static final boolean jdk14;
    private static final boolean enableBiDir;
    private HashMap orbs = new HashMap();
    private HashMap sslCtxCache = new HashMap();
    private ConcurrentHashMap timeoutCache = new ConcurrentHashMap();
    private HashMap urlCache = new HashMap();
    private ORBInfo currentinfo = null;

    private static final boolean getJDK14() {
        Class<String> c = String.class;
        try {
            c.getMethod("replace", CharSequence.class, CharSequence.class);
            return false;
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            c.getMethod("replace", String.class, String.class);
            return false;
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return true;
    }

    private static final boolean getBiDir() {
        try {
            return Boolean.getBoolean("weblogic.corba.client.bidir");
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isThinClient() {
        return thinClient;
    }

    public static ORBHelper getORBHelper() {
        if (singleton == null) {
            if (thinClient) {
                new WLInitialContextFactory();
            } else {
                ORBHelper.createORBHelper();
            }
        }
        return singleton;
    }

    public static synchronized void createORBHelper() {
        if (singleton == null) {
            String enableClientProp = "";
            enableClientProp = KernelStatus.isApplet() ? FALSE_PROP : System.getProperty("weblogic.system.iiop.enableClient");
            if (!FALSE_PROP.equals(enableClientProp)) {
                enableIIOPClient = true;
                singleton = new ORBHelperImpl();
            } else {
                singleton = new ORBHelper();
            }
        }
    }

    public static synchronized void setORBHelper(ORBHelper helper) {
        singleton = helper;
    }

    private static boolean getServerAffinity(Hashtable env) {
        return env == null ? false : Boolean.valueOf((String)env.get(ENABLE_SERVER_AFFINITY));
    }

    public synchronized ORB getORB(String url, Hashtable env) throws NamingException {
        NameParser.URLInfo info = this.parseURL(url);
        boolean affinity = ORBHelper.getServerAffinity(env);
        ORBInfo orbinfo = this.getCachedORB(affinity ? info.getKey() : info.getNextKey(), env);
        if (orbinfo != null) {
            return orbinfo.getORB();
        }
        ORB orb = null;
        if (url != null) {
            EndPointInfo epi = info.getAddress();
            orb = this.createORB(env, epi, info.getProtocol(), info.serviceName + "=" + info.getURL());
            orbinfo = this.cacheORBAndCreateURL(info.getKey(), orb, info);
        } else {
            orb = this.createORB(env, null, null, null);
            orbinfo = this.createORBInfo(orb, null);
            this.setCurrent(orbinfo);
        }
        return orbinfo.getORB();
    }

    private synchronized ORBInfo getCachedORB(String key, Hashtable env) {
        ORBInfo orbinfo = null;
        if (key != null && (orbinfo = (ORBInfo)this.orbs.get(key)) != null) {
            this.setCurrent(orbinfo);
            return orbinfo;
        }
        if (env != null && env.get(ORB_NAMING_PROP) != null) {
            orbinfo = this.cacheORB(key, (ORB)env.get(ORB_NAMING_PROP));
        }
        return orbinfo;
    }

    private ORBInfo cacheORB(String key, ORB orb) {
        ORBInfo orbinfo = this.createORBInfo(orb, key);
        this.orbs.put(key, orbinfo);
        this.setCurrent(orbinfo);
        return orbinfo;
    }

    private ORBInfo cacheORBAndCreateURL(String key, ORB orb, NameParser.URLInfo info) {
        ORBInfo orbinfo = this.cacheORB(key, orb);
        orbinfo.setClusterURL(info.getClusterURL());
        return orbinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORB createORB(Hashtable env, EndPointInfo epi, String protocol, String initialRef) {
        ORB orb;
        String clientPkg;
        Properties props = new Properties();
        if (env != null) {
            props.putAll((Map<?, ?>)env);
        }
        String string = clientPkg = jdk14 ? CLIENT_PACKAGE_14 : CLIENT_PACKAGE;
        if (props.getProperty(ORB_CLASS_PROP) == null && this.getORBClass() != null) {
            props.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        if (epi != null) {
            if (epi.getPort() > 0) {
                props.put(ORB_INITIAL_PORT, Integer.toString(epi.getPort()));
            }
            props.put(ORB_PROTOCOL, protocol);
            props.put(SUN_FRAGMENT, "GROW");
            if (env != null && env.containsKey(RMI_TIMEOUT)) {
                props.put(SUN_TCP_READ_TIMEOUTS_PROPERTY, "100:" + env.get(RMI_TIMEOUT) + ":300:20");
            }
            props.put(SUN_WCHARSET, "0x05010001,0x00010109");
            if (protocol == "iiops") {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, clientPkg + BI_DIR_SSL_SOCKET_FACTORY);
                props.put(SUN_SOCKET_FACTORY_OLD, clientPkg + BI_DIR_SSL_SOCKET_FACTORY);
            } else if (protocol == "http") {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, clientPkg + TUNNEL_SOCKET_FACTORY);
                props.put(SUN_SOCKET_FACTORY_OLD, clientPkg + TUNNEL_SOCKET_FACTORY);
            } else if (protocol == "https") {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, clientPkg + TUNNEL_SSL_SOCKET_FACTORY);
                props.put(SUN_SOCKET_FACTORY_OLD, clientPkg + TUNNEL_SSL_SOCKET_FACTORY);
            } else if (thinClient) {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                if (enableBiDir && protocol.length() > 0) {
                    props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                    props.put(SUN_SOCKET_FACTORY, clientPkg + BI_DIR_SOCKET_FACTORY);
                    props.put(SUN_SOCKET_FACTORY_OLD, clientPkg + BI_DIR_SOCKET_FACTORY);
                } else {
                    props.put(SUN_SOCKET_FACTORY, clientPkg + CLUSTER_SOCKET_FACTORY);
                    props.put(SUN_SOCKET_FACTORY_OLD, clientPkg + CLUSTER_SOCKET_FACTORY);
                }
            }
            props.put(ORB_INITIAL_HOST, epi.getHost());
            props.put(ORB_INITIAL_REF, initialRef);
        }
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ORBHelper.class.getClassLoader());
            orb = ORB.init((String[])new String[0], (Properties)props);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
        }
        if (env != null) {
            java.lang.Object creds = env.get("java.naming.security.credentials");
            if (creds != null && creds instanceof SSLContext) {
                this.sslCtxCache.put(orb, creds);
            }
            if (env.containsKey(REQUEST_TIMEOUT)) {
                this.timeoutCache.put(orb, env.get(REQUEST_TIMEOUT));
            }
        }
        return orb;
    }

    public final SSLContext getSSLContext(ORB orb) {
        return (SSLContext)this.sslCtxCache.get(orb);
    }

    public int getORBTimeout(ORB orb) {
        if (this.timeoutCache.containsKey(orb)) {
            return ((Long)this.timeoutCache.get(orb)).intValue();
        }
        return 0;
    }

    public String getORBClass() {
        return this.orbClassName;
    }

    public ORB getLocalORB() throws NamingException {
        Properties props = new Properties();
        if (this.getORBClass() != null) {
            props.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        return ORB.init((String[])new String[0], (Properties)props);
    }

    public ORBInfo getCurrent() {
        return this.currentinfo;
    }

    public void setCurrent(ORBInfo info) {
        this.currentinfo = info;
    }

    public ORBInfo createORBInfo(ORB orb, String key) {
        return new ORBInfo(orb, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getORBReference(String url, Hashtable env, String rir) throws NamingException {
        String key;
        ORBInfo orbinfo;
        NameParser.URLInfo info = this.parseURL(url);
        if (info == null) {
            throw new InvalidNameException("url `" + url + "' is invalid");
        }
        boolean affinity = ORBHelper.getServerAffinity(env);
        for (int i = 0; i < info.addressList.length && (orbinfo = this.getCachedORB(key = info.getKey(), env)) != null; ++i) {
            try {
                Object obj = orbinfo.getORB().resolve_initial_references(rir);
                if (thinClient) {
                    obj._non_existent();
                }
                if (!affinity) {
                    info.getNextAddress();
                }
                orbinfo.setClusterURL(info.getClusterURL());
                return obj;
            }
            catch (InvalidName in) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)in), "Couldn't resolve initial reference: " + rir);
            }
            catch (SystemException se) {
                ORBHelper oRBHelper = this;
                synchronized (oRBHelper) {
                    this.orbs.remove(key);
                    this.setCurrent(null);
                }
                if (thinClient) {
                    this.destroyORB(orbinfo.getORB());
                }
                this.timeoutCache.remove(orbinfo.getORB());
                if (!ORBHelper.isRecoverableORBFailure(se)) {
                    throw Utils.wrapNamingException((Exception)((java.lang.Object)se), "Couldn't resolve initial reference: " + rir);
                }
                info.getNextAddress();
                continue;
            }
        }
        return this.getORBReferenceWithRetry(info, env, rir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getORBReferenceWithRetry(NameParser.URLInfo info, Hashtable env, String rir) throws NamingException {
        ORB orb = null;
        Object obj = null;
        int i = 0;
        boolean affinity = ORBHelper.getServerAffinity(env);
        boolean cachedORB = false;
        while (obj == null) {
            java.lang.Object epi;
            String key = info.getKey();
            if (!cachedORB) {
                String bootstrapURL;
                epi = info.getAddress();
                String string = bootstrapURL = thinClient ? info.getNeutralURL() : info.getURL();
                if (thinClient && !this.dummyORBCreated) {
                    this.createDummyORB(env, (EndPointInfo)epi);
                }
                orb = this.createORB(env, (EndPointInfo)epi, info.getProtocol(), info.serviceName + "=" + bootstrapURL);
            }
            try {
                obj = orb.resolve_initial_references(rir);
                if (thinClient) {
                    obj._non_existent();
                }
                if (!affinity) {
                    info.getNextAddress();
                }
                epi = this;
                synchronized (epi) {
                    if (this.getCachedORB(key, env) == null) {
                        this.cacheORBAndCreateURL(key, orb, info);
                    }
                }
            }
            catch (InvalidName in) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)in), "Couldn't resolve initial reference: " + rir);
            }
            catch (SystemException se) {
                obj = null;
                if (thinClient) {
                    this.destroyORB(orb);
                }
                this.timeoutCache.remove(orb);
                if (!cachedORB) {
                    if (!ORBHelper.isRecoverableORBFailure(se) || ++i >= info.addressList.length) {
                        String msg = info.addressList.length == 1 ? this.getRootCauseMessage(se) : "Couldn't connect to any host ";
                        throw Utils.wrapNamingException((Exception)((java.lang.Object)se), msg);
                    }
                    info.getNextAddress();
                    ORBInfo orbinfo = this.getCachedORB(info.getKey(), env);
                    if (orbinfo == null) continue;
                    orb = orbinfo.getORB();
                    cachedORB = true;
                    continue;
                }
                this.clearORBFromCache(info.getKey());
                cachedORB = false;
                if (ORBHelper.isRecoverableORBFailure(se)) continue;
                throw Utils.wrapNamingException((Exception)((java.lang.Object)se), "Couldn't resolve initial reference: " + rir);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearORBFromCache(String key) {
        ORBHelper oRBHelper = this;
        synchronized (oRBHelper) {
            if (key != null) {
                this.orbs.remove(key);
            }
            this.setCurrent(null);
        }
    }

    private final synchronized NameParser.URLInfo parseURL(String url) throws InvalidNameException {
        NameParser.URLInfo info = (NameParser.URLInfo)this.urlCache.get(url);
        if (info == null) {
            info = NameParser.parseURL(url);
            this.urlCache.put(url, info);
        }
        return info;
    }

    public void pushTransactionHelper() {
        if (enableIIOPClient) {
            TransactionHelper.pushTransactionHelper(ORBHelper.createTxHelper(NATIVE_TX_HELPER));
        } else {
            TransactionHelper.pushTransactionHelper(new TransactionHelperImpl());
        }
    }

    public void popTransactionHelper() {
        TransactionHelper.popTransactionHelper();
    }

    static boolean isRecoverableORBFailure(SystemException se) {
        return ORBHelper.isRecoverableORBFailure(se, true);
    }

    public static boolean isRecoverableORBFailure(SystemException se, boolean idempotent) {
        return (se instanceof COMM_FAILURE || se instanceof MARSHAL || se instanceof OBJECT_NOT_EXIST || se instanceof BAD_PARAM && se.minor == 1330446344) && (se.completed.value() == 1 || se.completed.value() == 2 && idempotent);
    }

    private static TransactionHelper createTxHelper(String name) {
        try {
            return (TransactionHelper)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new Error(cnfe.toString());
        }
        catch (InstantiationException ie) {
            throw new Error(ie.toString());
        }
        catch (IllegalAccessException iae) {
            throw new Error(iae.toString());
        }
    }

    protected static void p(String s) {
        System.err.println("<ORBHelper> " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummyORB(Hashtable env, EndPointInfo epi) {
        java.lang.Object orb = null;
        EndPointInfo epi1 = new EndPointInfo(" ", -1, epi.getMajorVersion(), epi.getMajorVersion());
        String initialRef = "NameService=corbaloc::1.1@/NameService";
        ORBHelper oRBHelper = this;
        synchronized (oRBHelper) {
            if (!this.dummyORBCreated) {
                try {
                    orb = this.createORB(null, epi1, "", initialRef);
                    this.setORBLogLevel();
                    Object obj = orb.resolve_initial_references(initialRef);
                    obj._non_existent();
                }
                catch (Throwable th) {
                }
                finally {
                    this.orbClassName = orb.getClass().getName();
                    this.dummyORBCreated = true;
                }
            }
        }
    }

    public void destroyORB(ORB orb) {
        try {
            java.lang.Object tm = orb.getClass().getMethod("getTransportManager", new Class[0]).invoke((java.lang.Object)orb, new java.lang.Object[0]);
            try {
                java.lang.Object selector = tm.getClass().getMethod("getSelector", Integer.TYPE).invoke(tm, 0);
                selector.getClass().getMethod("close", new Class[0]).invoke(selector, new java.lang.Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Collection acceptors = (Collection)tm.getClass().getMethod("getAcceptors", new Class[0]).invoke(tm, new java.lang.Object[0]);
            for (java.lang.Object acceptor : acceptors) {
                try {
                    acceptor.getClass().getMethod("close", new Class[0]).invoke(acceptor, new java.lang.Object[0]);
                }
                catch (Exception ex) {}
            }
            orb.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setORBLogLevel() {
        String levelName = System.getProperty("weblogic.corba.client.ORBLogLevel");
        if (levelName == null) {
            return;
        }
        Logger logger = LogManager.getLogManager().getLogger(SUN_RPC_TRANSPORT_LOGGER);
        if (logger != null) {
            Level level = null;
            try {
                level = Level.parse(levelName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (level != null) {
                logger.setLevel(level);
            }
        }
    }

    private String getRootCauseMessage(Throwable th) {
        String s = "Couldn't connect to the specified host";
        Throwable cause = th.getCause();
        if (cause == null) {
            return s;
        }
        return s + " : " + cause.getMessage();
    }

    static {
        enableIIOPClient = false;
        thinClient = false;
        jdk14 = ORBHelper.getJDK14();
        enableBiDir = ORBHelper.getBiDir();
        try {
            String clientPkg = jdk14 ? CLIENT_PACKAGE_14 : CLIENT_PACKAGE;
            Class.forName(clientPkg + CLUSTER_SOCKET_FACTORY);
            Class.forName(INITIAL_CONTEXT_FACTORY);
            if (!KernelStatus.isServer() && KernelStatus.isThinIIOPClient()) {
                thinClient = true;
            } else {
                Class.forName("org.osgi.framework.Bundle");
                thinClient = true;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

