/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public final class DiagnosticContextFactory {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger("DebugDiagnosticContext");
    private static final Factory DEFAULT_FACTORY;
    private static Factory SINGLETON;
    private static boolean contextEnabled;
    private static int propagationMode;

    static synchronized void setFactory(Factory factory) {
        if (!KernelStatus.isServer() || SINGLETON != DEFAULT_FACTORY || factory == null) {
            return;
        }
        SINGLETON = factory;
    }

    static boolean isEnabled() {
        return contextEnabled;
    }

    static void setEnabled(boolean val) {
        contextEnabled = val;
    }

    static int getPropagationMode() {
        return propagationMode;
    }

    static void setPropagationMode(int val) {
        propagationMode = val;
    }

    public static DiagnosticContext getDiagnosticContext() {
        WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
        return (DiagnosticContext)map.get("weblogic.diagnostics.DiagnosticContext");
    }

    public static DiagnosticContext findOrCreateDiagnosticContext() {
        return DiagnosticContextFactory.findOrCreateDiagnosticContext(contextEnabled);
    }

    public static DiagnosticContext findOrCreateDiagnosticContext(boolean enabled) {
        if (!KernelStatus.isServer()) {
            enabled = true;
        }
        return SINGLETON.findOrCreateDiagnosticContext(enabled);
    }

    public static void invalidateCache() {
        SINGLETON.invalidateCache();
    }

    public static void setJFRThrottled(DiagnosticContext ctx) {
        SINGLETON.setJFRThrottled(ctx);
    }

    static void setDiagnosticContext(DiagnosticContext ctx) {
        SINGLETON.setDiagnosticContext(ctx);
    }

    static {
        SINGLETON = DEFAULT_FACTORY = new DefaultFactoryImpl();
        propagationMode = 383;
    }

    private static class DefaultFactoryImpl
    implements Factory {
        private DefaultFactoryImpl() {
        }

        public DiagnosticContext findOrCreateDiagnosticContext(boolean enabled) {
            DiagnosticContext ctx;
            block3: {
                ctx = null;
                WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                ctx = (DiagnosticContext)map.get("weblogic.diagnostics.DiagnosticContext");
                if (ctx == null && enabled) {
                    ctx = new DiagnosticContextImpl();
                    try {
                        map.put("weblogic.diagnostics.DiagnosticContext", ctx, propagationMode);
                    }
                    catch (Throwable th) {
                        if (!DEBUG_LOGGER.isDebugEnabled()) break block3;
                        th.printStackTrace();
                    }
                }
            }
            return ctx;
        }

        public void invalidateCache() {
        }

        public void setJFRThrottled(DiagnosticContext ctx) {
        }

        public void setDiagnosticContext(DiagnosticContext ctx) {
            block5: {
                WorkContextMap map = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                try {
                    if (ctx != null) {
                        map.put("weblogic.diagnostics.DiagnosticContext", ctx, propagationMode);
                    } else if (map.get("weblogic.diagnostics.DiagnosticContext") != null) {
                        map.remove("weblogic.diagnostics.DiagnosticContext");
                        this.invalidateCache();
                    }
                }
                catch (Throwable th) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block5;
                    th.printStackTrace();
                }
            }
        }
    }

    public static interface Factory {
        public DiagnosticContext findOrCreateDiagnosticContext(boolean var1);

        public void invalidateCache();

        public void setJFRThrottled(DiagnosticContext var1);

        public void setDiagnosticContext(DiagnosticContext var1);
    }
}

