/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.io.IOException;
import java.rmi.dgc.VMID;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public final class DiagnosticContextImpl
implements DiagnosticContext {
    private static final char[] int2hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int SEQID_LENGTH = 16;
    private static long seqID = 0L;
    private static final char[] baseID = DiagnosticContextImpl.createBaseID();
    private String contextId;
    private long dyeVector;
    private String payload;

    public DiagnosticContextImpl() {
        this.init();
    }

    void setContextId(String newId) {
        this.contextId = newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        long id = 0L;
        char[] cArray = baseID;
        synchronized (baseID) {
            id = ++seqID;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            int baseLength = baseID.length;
            int len = baseLength + 16;
            char[] contextIdChars = new char[len];
            System.arraycopy(baseID, 0, contextIdChars, 0, baseLength);
            for (int i = len - 1; i >= baseLength; --i) {
                contextIdChars[i] = int2hex[(int)(id & 0xFL)];
                id >>= 4;
            }
            this.contextId = new String(contextIdChars);
            this.dyeVector = 0L;
            this.payload = null;
            return;
        }
    }

    private static char[] createBaseID() {
        VMID vmID = new VMID();
        String str = vmID.toString() + "-";
        int len = str.length();
        char[] id = new char[len];
        str.getChars(0, len, id, 0);
        return id;
    }

    public String getContextId() {
        return this.contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDye(byte dye, boolean enable) throws InvalidDyeException {
        if (dye < 0 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        long val = 1L << dye;
        DiagnosticContextImpl diagnosticContextImpl = this;
        synchronized (diagnosticContextImpl) {
            this.dyeVector = enable ? (this.dyeVector |= val) : (this.dyeVector &= val ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean isDyedWith(byte dye) throws InvalidDyeException {
        if (dye < 0 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        return (this.dyeVector & 1L << dye) != 0L;
    }

    public void setDyeVector(long vector) {
        this.dyeVector = vector;
    }

    public long getDyeVector() {
        return this.dyeVector;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void writeContext(WorkContextOutput out) throws IOException {
        out.writeASCII(this.contextId);
        out.writeLong(this.dyeVector);
        if (this.payload != null) {
            out.writeBoolean(true);
            out.writeASCII(this.payload);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readContext(WorkContextInput in) throws IOException {
        this.contextId = in.readASCII();
        this.dyeVector = in.readLong();
        this.payload = in.readBoolean() ? in.readASCII() : null;
        DiagnosticContextFactory.invalidateCache();
        DiagnosticContextFactory.setJFRThrottled(this);
    }
}

