/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import weblogic.diagnostics.debug.DebugLogger;

public final class DebugLoggerRepository {
    static final String DEFAULT_CMDLINE_OVERRIDE_PREFIX = "weblogic.debug.";
    private Map debugLoggers = new HashMap();
    private Logger jdkLogger = DebugLoggerRepository.createAndInitAnonymousLogger();
    private String cmdlineOveridePrifix;

    DebugLoggerRepository() {
        try {
            this.cmdlineOveridePrifix = System.getProperty("weblogic.diagnostics.debug.DefaultCommandLinePrefix", DEFAULT_CMDLINE_OVERRIDE_PREFIX);
        }
        catch (Exception exception) {
            this.cmdlineOveridePrifix = DEFAULT_CMDLINE_OVERRIDE_PREFIX;
        }
    }

    DebugLoggerRepository(String string) {
        this.cmdlineOveridePrifix = string;
    }

    public Logger getLogger() {
        return this.jdkLogger;
    }

    public synchronized void setLogger(Logger logger) {
        this.jdkLogger = logger;
    }

    public synchronized DebugLogger getDebugLogger(String string) {
        DebugLogger debugLogger = (DebugLogger)this.debugLoggers.get(string);
        if (debugLogger == null) {
            debugLogger = new DebugLogger(string, this);
            this.debugLoggers.put(string, debugLogger);
            try {
                boolean bl = Boolean.getBoolean(this.cmdlineOveridePrifix + string);
                debugLogger.setDebugEnabled(bl);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return debugLogger;
    }

    private static Logger createAndInitAnonymousLogger() {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.FINE);
        StreamHandler streamHandler = new StreamHandler(System.out, new SimpleFormatter()){

            public void publish(LogRecord logRecord) {
                super.publish(logRecord);
                super.flush();
            }

            public void close() {
                super.flush();
            }
        };
        try {
            streamHandler.setLevel(Level.FINE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        logger.addHandler(streamHandler);
        return logger;
    }
}

