/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Date;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.Severities;

class BasicLogMessageFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private String fieldPrefix;
    private String fieldSuffix;

    public BasicLogMessageFormatter() {
        this("", "");
    }

    public BasicLogMessageFormatter(String string, String string2) {
        this.fieldPrefix = string;
        this.fieldSuffix = string2;
    }

    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    public void setFieldPrefix(String string) {
        this.fieldPrefix = string;
    }

    public String getFieldSuffix() {
        return this.fieldSuffix;
    }

    public void setFieldSuffix(String string) {
        this.fieldSuffix = string;
    }

    String formatLogMessage(LogMessage logMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendField(stringBuffer, new Date().toString());
        String string = Severities.severityNumToString(logMessage.getSeverity());
        this.appendField(stringBuffer, string);
        this.appendBaseLogMessageFields(logMessage, stringBuffer);
        return stringBuffer.toString();
    }

    String formatBaseLogMessageFields(LogMessage logMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBaseLogMessageFields(logMessage, stringBuffer);
        return stringBuffer.toString();
    }

    void appendBaseLogMessageFields(LogMessage logMessage, StringBuffer stringBuffer) {
        String string;
        this.appendField(stringBuffer, logMessage.getSubsystem());
        String string2 = logMessage.getMessageIdPrefix();
        if (string2 == null || string2.length() == 0) {
            string2 = "BEA";
        }
        if ((string = logMessage.getMessageId()) == null || string.length() == 0) {
            string = "000000";
        }
        this.appendField(stringBuffer, string2 + "-" + string);
        if (logMessage.getThrowable() == null) {
            this.appendField(stringBuffer, logMessage.getMessage());
        } else {
            stringBuffer.append(this.fieldPrefix);
            stringBuffer.append(logMessage.getMessage());
            stringBuffer.append(EOL);
            Throwable throwable = logMessage.getThrowable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("\tat ");
                stringBuffer.append(stackTraceElementArray[i]);
                stringBuffer.append(EOL);
            }
            stringBuffer.append(this.fieldSuffix);
        }
    }

    private void appendField(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.fieldPrefix);
        stringBuffer.append(string);
        stringBuffer.append(this.fieldSuffix);
    }
}

