/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.text.MessageFormat;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18ntools.L10nLookup;

public class CatalogMessage
extends LogMessage {
    private Object[] messageArgs;
    private String localizerResourceName;
    private ClassLoader localizerResourceClassloader;
    private boolean stackTraceEnabled;
    private Localizer localizer = null;
    private String diagnosticVolume;

    public CatalogMessage(String string, Object[] objectArray, String string2) {
        this(string, objectArray, string2, null);
    }

    public CatalogMessage(String string, Object[] objectArray, String string2, ClassLoader classLoader) {
        this.setMessageId(string);
        this.messageArgs = objectArray;
        this.localizerResourceName = string2;
        this.localizerResourceClassloader = classLoader;
        this.localizer = L10nLookup.getLocalizer(Locale.getDefault(), this.localizerResourceName, this.localizerResourceClassloader);
        super.setMsgIdPrefix(this.localizer.getPrefix());
        super.setSeverity(this.localizer.getSeverity(string));
        super.setSubsystem(this.localizer.getSubSystem());
        this.stackTraceEnabled = this.localizer.getStackTrace(string);
        this.diagnosticVolume = this.localizer.getDiagnosticVolume(string);
        super.setMessage(MessageFormat.format(this.localizer.getBody(string), this.messageArgs));
        this.initThrowable();
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public Object[] getArguments() {
        return this.messageArgs;
    }

    public String getLocalizerResourceName() {
        return this.localizerResourceName;
    }

    public ClassLoader getResourceClassLoader() {
        return this.localizerResourceClassloader;
    }

    public String getDiagnosticVolume() {
        return this.diagnosticVolume;
    }

    private void initThrowable() {
        Object object;
        int n;
        Object[] objectArray = this.messageArgs;
        if (objectArray != null && (n = objectArray.length - 1) >= 0 && (object = objectArray[n]) instanceof Throwable) {
            this.setThrowable((Throwable)object);
        }
    }
}

