/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.i18n.logging.BasicLogMessageFormatter;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.MessageDispatcher;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.Severities;

public class CoreEnginePrimordialLoggerWrapper
implements MessageLogger,
MessageDispatcher {
    public static final String PRIMORDIAL_LOGGER_PROPERTY = "com.bea.logging.PrimordialLoggingService";
    private Logger primordialLogger;
    private BasicLogMessageFormatter basicFormatter = new BasicLogMessageFormatter("", ": ");
    private static CoreEnginePrimordialLoggerWrapper instance;

    private CoreEnginePrimordialLoggerWrapper(Logger logger) {
        this.primordialLogger = logger;
    }

    public static synchronized CoreEnginePrimordialLoggerWrapper getInstance() throws Exception {
        Class<?> clazz;
        Logger logger;
        String string;
        if (instance == null && (string = System.getProperty(PRIMORDIAL_LOGGER_PROPERTY)) != null && (logger = (Logger)(clazz = Class.forName(string)).getMethod("getJDKLogger", null).invoke(null, (Object[])null)) != null) {
            instance = new CoreEnginePrimordialLoggerWrapper(logger);
        }
        return instance;
    }

    public boolean isSeverityEnabled(String string, int n) {
        return this.isSeverityEnabled(n);
    }

    public void log(String string, int n, String string2) {
        this.log(string, n, string2, null);
    }

    public void log(String string, int n, String string2, Throwable throwable) {
        this.log(new LogMessage("", "", string, n, string2, throwable));
    }

    public void log(LogMessage logMessage) {
        Level level = Severities.severityToJDKLoggerLevel(logMessage.getSeverity());
        String string = this.basicFormatter.formatBaseLogMessageFields(logMessage);
        this.primordialLogger.log(level, string, logMessage.getThrowable());
    }

    public MessageDispatcher getMessageDispatcher(String string) {
        return this;
    }

    public String getName() {
        return this.primordialLogger.getName();
    }

    public boolean isSeverityEnabled(int n) {
        return this.primordialLogger.isLoggable(Severities.severityToJDKLoggerLevel(n));
    }
}

