/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import weblogic.i18n.logging.BasicMessageLogger;
import weblogic.i18n.logging.CoreEnginePrimordialLoggerWrapper;
import weblogic.i18n.logging.MessageDispatcher;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerNotFoundException;
import weblogic.i18n.logging.MessageLoggerRegistryListener;

public final class MessageLoggerRegistry {
    private static final String DELIM = ".";
    private static final boolean DEBUG = false;
    public static final String DEFAULT_MESSAGE_LOGGER_PROP = "weblogic.i18n.logging.MessageLogger";
    private static final int SKIP_COUNT = 100;
    private static Tree tree = new Tree();
    private static List listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageLoggerRegistryListener(MessageLoggerRegistryListener messageLoggerRegistryListener) {
        List list = listeners;
        synchronized (list) {
            if (listeners.size() % 100 == 0) {
                MessageLoggerRegistry.expungeStaleEntries();
            }
            WeakReference<MessageLoggerRegistryListener> weakReference = new WeakReference<MessageLoggerRegistryListener>(messageLoggerRegistryListener);
            listeners.add(weakReference);
        }
    }

    private static void expungeStaleEntries() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessageLoggerResgistryListener(MessageLoggerRegistryListener messageLoggerRegistryListener) {
        List list = listeners;
        synchronized (list) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                MessageLoggerRegistryListener messageLoggerRegistryListener2 = (MessageLoggerRegistryListener)weakReference.get();
                if (messageLoggerRegistryListener2 != null && messageLoggerRegistryListener2 != messageLoggerRegistryListener) continue;
                iterator.remove();
            }
        }
    }

    public static void registerMessageLogger(String string, MessageLogger messageLogger) {
        Node node = MessageLoggerRegistry.buildTreeNodesRecursive(MessageLoggerRegistry.tree.getRootNode(), string);
        node.setValue(messageLogger);
        MessageLoggerRegistry.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListeners() {
        List list = listeners;
        synchronized (list) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                MessageLoggerRegistryListener messageLoggerRegistryListener = (MessageLoggerRegistryListener)weakReference.get();
                if (messageLoggerRegistryListener != null) {
                    messageLoggerRegistryListener.messageLoggerRegistryUpdated();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static MessageLogger findMessageLogger(String string) {
        Node node = MessageLoggerRegistry.findTreeNodeRecursive(MessageLoggerRegistry.tree.getRootNode(), string);
        MessageLogger messageLogger = null;
        while (messageLogger == null && node != null) {
            messageLogger = (MessageLogger)node.getValue();
            node = node.getParent();
        }
        if (messageLogger == null) {
            throw new MessageLoggerNotFoundException(string);
        }
        return messageLogger;
    }

    public static MessageLogger getRootLogger() {
        return (MessageLogger)tree.rootNode.getValue();
    }

    private static Node buildTreeNodesRecursive(Node node, String string) {
        int n = string.indexOf(DELIM);
        if (n > 0) {
            String string2 = string.substring(0, n);
            Node node2 = new Node(node, string2);
            node.getChildren().add(node2);
            if (n < string.length() - 1) {
                String string3 = string.substring(n + 1);
                return MessageLoggerRegistry.buildTreeNodesRecursive(node2, string3);
            }
            return node2;
        }
        if (node.getName().equals(string)) {
            return node;
        }
        Node node3 = new Node(node, string);
        node.getChildren().add(node3);
        return node3;
    }

    private static Node findTreeNodeRecursive(Node node, String string) {
        if (node.getChildren().isEmpty()) {
            return node;
        }
        int n = string.indexOf(DELIM);
        if (n > 0) {
            String string2 = string.substring(0, n);
            Node node2 = MessageLoggerRegistry.findChildNode(node, string2);
            if (node2 == null) {
                return node;
            }
            if (n < string.length() - 1) {
                String string3 = string.substring(n + 1);
                return MessageLoggerRegistry.findTreeNodeRecursive(node2, string3);
            }
            return node2;
        }
        Node node3 = MessageLoggerRegistry.findChildNode(node, string);
        if (node3 == null) {
            return node;
        }
        return node3;
    }

    private static Node findChildNode(Node node, String string) {
        for (Node node2 : node.getChildren()) {
            if (!node2.getName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
    }

    private static class Node {
        private Node parent;
        private String name;
        private Object value;
        private Set childNodes = new HashSet();

        private Node(Node node, String string) {
            this.parent = node;
            this.name = string;
        }

        private Node getParent() {
            return this.parent;
        }

        private String getName() {
            return this.name;
        }

        private Set getChildren() {
            return this.childNodes;
        }

        private Object getValue() {
            return this.value;
        }

        private void setValue(Object object) {
            this.value = object;
        }

        public boolean equals(Object object) {
            return ((Node)object).name.equals(this.name);
        }
    }

    private static class Tree {
        private Node rootNode = new Node(null, "");

        private Tree() {
            this.rootNode.setValue(this.initializeRootNodeLogger());
        }

        private Object initializeRootNodeLogger() {
            MessageDispatcher messageDispatcher = null;
            try {
                messageDispatcher = CoreEnginePrimordialLoggerWrapper.getInstance();
                if (messageDispatcher == null) {
                    String string = System.getProperty(MessageLoggerRegistry.DEFAULT_MESSAGE_LOGGER_PROP, "weblogic.logging.WLMessageLogger");
                    Class<?> clazz = Class.forName(string);
                    messageDispatcher = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                messageDispatcher = new BasicMessageLogger();
            }
            return messageDispatcher;
        }

        private Node getRootNode() {
            return this.rootNode;
        }
    }
}

