/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18ntools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import weblogic.i18ntools.L10NClassLoaderFactory;

public class DefaultL10NClassLoaderFactory
implements L10NClassLoaderFactory {
    private static boolean DEBUG = false;
    private static final String DEFAULT_MODULE_PREFIX = "weblogic.server.modules";
    private boolean valid;
    private String modulePrefix;
    private String patternPrefix;
    private String modulePattern;
    private File featureDir;
    private String version;
    private String versionPattern;
    private Map<ClassLoaderCacheKey, ClassLoaderWrapper> classLoaderMap = new WeakHashMap<ClassLoaderCacheKey, ClassLoaderWrapper>();

    public DefaultL10NClassLoaderFactory() {
        this(DEFAULT_MODULE_PREFIX);
    }

    public DefaultL10NClassLoaderFactory(String string) {
        try {
            DEBUG = Boolean.getBoolean("weblogic.debug.DebugL10NClassLoaderFactory");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.init(string);
        if (this.findEnvironmentFromClasspath() && this.featureDir != null && this.version != null) {
            this.versionPattern = this.version.replaceAll("\\.", "\\\\.") + "\\.jar$";
            this.valid = true;
        }
    }

    private void init(String string) {
        this.modulePrefix = string.replaceAll("\\.", "\\\\.");
        this.patternPrefix = this.modulePrefix + "\\.";
        this.modulePattern = "^" + this.modulePrefix + "_(.+)\\.jar$";
    }

    private boolean findEnvironmentFromClasspath() {
        Pattern pattern;
        String string;
        String string2;
        block6: {
            string2 = "";
            string = "";
            try {
                string2 = System.getProperty("java.class.path");
                string = System.getProperty("path.separator");
            }
            catch (SecurityException securityException) {
                if (DEBUG) {
                    securityException.printStackTrace();
                }
                return false;
            }
            pattern = null;
            try {
                pattern = Pattern.compile(this.modulePattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (!DEBUG) break block6;
                patternSyntaxException.printStackTrace();
            }
        }
        HashSet hashSet = new HashSet();
        boolean bl = this.findEnvironment(null, string2, pattern, string, hashSet);
        if (DEBUG) {
            DefaultL10NClassLoaderFactory.debug("findEnvironmentFromClasspath: success=" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findEnvironment(String string, String string2, Pattern pattern, String string3, Set set) {
        String[] stringArray;
        if (pattern == null || string2 == null) {
            return false;
        }
        if (DEBUG) {
            DefaultL10NClassLoaderFactory.debug("findEnvironment: rootDir=" + string + " classPath=" + string2);
        }
        if ((stringArray = string2.split(string3)) == null) {
            return false;
        }
        for (String string4 : stringArray) {
            File file;
            block28: {
                if ((string4 = string4.trim()).length() == 0) continue;
                if (DEBUG) {
                    DefaultL10NClassLoaderFactory.debug("processing: " + string4);
                }
                if (!(file = new File(string4)).isAbsolute() && string != null) {
                    file = new File(string + "/" + string4);
                }
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    if (!DEBUG) break block28;
                    iOException.printStackTrace();
                }
            }
            if (file.exists() && !set.contains(file.toString())) {
                set.add(file.toString());
                if (!file.isFile()) continue;
                String string5 = file.getName();
                Matcher matcher = pattern.matcher(string5);
                if (matcher.matches()) {
                    this.featureDir = file.getParentFile();
                    this.version = matcher.group(1);
                    if (DEBUG) {
                        DefaultL10NClassLoaderFactory.debug("Found: featureDir=" + this.featureDir + " version=" + this.version);
                    }
                    return true;
                }
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        String string6 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (string6 != null) {
                            if (!this.findEnvironment(file.getParent(), string6, pattern, " ", set)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        if (!DEBUG) continue;
                        DefaultL10NClassLoaderFactory.debug("Manifest of File " + file + " has no Class-Path");
                        continue;
                    }
                    if (!DEBUG) continue;
                    DefaultL10NClassLoaderFactory.debug("File " + file + " has no manifest");
                    continue;
                }
                catch (IOException iOException) {
                    if (!DEBUG) continue;
                    iOException.printStackTrace();
                    continue;
                }
                finally {
                    block29: {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException) {
                                if (!DEBUG) break block29;
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (!DEBUG) continue;
            DefaultL10NClassLoaderFactory.debug("File " + file + " does not exist");
        }
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(Locale locale, ClassLoader classLoader) {
        if (!this.valid || locale == null) {
            return null;
        }
        ClassLoaderCacheKey classLoaderCacheKey = new ClassLoaderCacheKey(classLoader, locale);
        ClassLoaderWrapper classLoaderWrapper = null;
        Map<ClassLoaderCacheKey, ClassLoaderWrapper> map = this.classLoaderMap;
        synchronized (map) {
            classLoaderWrapper = this.classLoaderMap.get(classLoaderCacheKey);
            if (classLoaderWrapper == null) {
                classLoaderWrapper = (ClassLoaderWrapper)AccessController.doPrivileged(new CreateLoaderAction(locale, classLoader));
                this.classLoaderMap.put(classLoaderCacheKey, classLoaderWrapper);
            }
        }
        return classLoaderWrapper.getLoader();
    }

    private Pattern buildPattern(Locale locale) {
        Pattern pattern;
        block8: {
            pattern = null;
            try {
                String string = locale.getLanguage();
                String string2 = locale.getCountry();
                String string3 = locale.getVariant();
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = this.patternPrefix + "(" + string;
                if (string2.length() > 0) {
                    string4 = string4 + "|" + string + "\\." + string2;
                    if (string3.length() > 0) {
                        string4 = string4 + "|" + string + "\\." + string2 + "\\." + string3;
                    }
                }
                string4 = string4 + ")_" + this.versionPattern;
                if (DEBUG) {
                    DefaultL10NClassLoaderFactory.debug("Using pattern for locale=" + locale + ": " + string4);
                }
                pattern = Pattern.compile(string4);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (!DEBUG) break block8;
                patternSyntaxException.printStackTrace();
            }
        }
        return pattern;
    }

    private ClassLoaderWrapper createLoader(Locale locale, ClassLoader classLoader) {
        Pattern pattern;
        File[] fileArray;
        URLClassLoader uRLClassLoader = null;
        if (this.featureDir != null && (fileArray = this.featureDir.listFiles(new FileFilter(pattern = this.buildPattern(locale)){
            final /* synthetic */ Pattern val$pat;
            {
                this.val$pat = pattern;
            }

            public boolean accept(File file) {
                String string;
                return this.val$pat != null && this.val$pat.matcher(string = file.getName()).matches();
            }
        })) != null && fileArray.length > 0) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (File file : fileArray) {
                try {
                    URL uRL = file.toURI().toURL();
                    arrayList.add(uRL);
                    if (!DEBUG) continue;
                    DefaultL10NClassLoaderFactory.debug("Adding url for locale=" + locale + ": " + uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!DEBUG) continue;
                    malformedURLException.printStackTrace();
                }
            }
            if (arrayList.size() > 0) {
                Serializable[] serializableArray = arrayList.toArray(new URL[0]);
                uRLClassLoader = classLoader == null ? new URLClassLoader((URL[])serializableArray) : new URLClassLoader((URL[])serializableArray, classLoader);
            }
        }
        if (DEBUG) {
            DefaultL10NClassLoaderFactory.debug("L10N classloader for locale=" + locale + ": " + uRLClassLoader);
        }
        return new ClassLoaderWrapper(uRLClassLoader);
    }

    private static void debug(String string) {
        System.out.println("DefaultL10NClassLoaderFactory: " + string);
    }

    public File getFeatureDir() {
        return this.featureDir;
    }

    public String getVersion() {
        return this.version;
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        DefaultL10NClassLoaderFactory defaultL10NClassLoaderFactory = new DefaultL10NClassLoaderFactory();
        long l2 = System.currentTimeMillis();
        System.out.println("featureDir=" + defaultL10NClassLoaderFactory.featureDir);
        System.out.println("version   =" + defaultL10NClassLoaderFactory.version);
        System.out.println("Elapsed time: " + (l2 - l) + " ms");
    }

    private static class ClassLoaderCacheKey {
        private ClassLoader parentLoader;
        private Locale locale;

        ClassLoaderCacheKey(ClassLoader classLoader, Locale locale) {
            this.parentLoader = classLoader;
            this.locale = locale;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClassLoaderCacheKey)) {
                return false;
            }
            ClassLoaderCacheKey classLoaderCacheKey = (ClassLoaderCacheKey)object;
            if (this.parentLoader != null && classLoaderCacheKey.parentLoader == null) {
                return false;
            }
            if (this.parentLoader != null ? !this.parentLoader.equals(classLoaderCacheKey.parentLoader) : classLoaderCacheKey.parentLoader != null) {
                return false;
            }
            if (this.locale != null && classLoaderCacheKey.locale == null) {
                return false;
            }
            return !(this.locale != null ? !this.locale.equals(classLoaderCacheKey.locale) : classLoaderCacheKey.locale != null);
        }

        public final int hashCode() {
            int n = this.parentLoader != null ? this.parentLoader.hashCode() : 0;
            n = 31 * n + (this.locale != null ? this.locale.hashCode() : 0);
            return n;
        }
    }

    private static class ClassLoaderWrapper {
        private ClassLoader loader;

        ClassLoaderWrapper(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }
    }

    private class CreateLoaderAction
    implements PrivilegedAction {
        private Locale locale;
        private ClassLoader parent;

        CreateLoaderAction(Locale locale, ClassLoader classLoader) {
            this.locale = locale;
            this.parent = classLoader;
        }

        public Object run() {
            return DefaultL10NClassLoaderFactory.this.createLoader(this.locale, this.parent);
        }
    }
}

