/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

public class KernelStatus {
    public static final String DIRECT_DISPATCH = "direct";
    public static final String DEFAULT_DISPATCH_ALIAS = "default";
    public static final String DEFAULT_DISPATCH = "weblogic.kernel.Default";
    public static final String NON_BLOCKING_DISPATCH = "weblogic.kernel.Non-Blocking";
    public static final String SYSTEM_DISPATCH = "weblogic.kernel.System";
    private static boolean intentionalShutdown = false;
    private static boolean isServer = false;
    private static boolean isthinIIOPClient = false;
    private static boolean isApplet = false;
    private static boolean isInitialized = false;
    private static boolean isIsServerSet = false;
    private static boolean isConfigured = false;
    private static final String DEBUG_PROP = "weblogic.kernel.debug";
    public static final boolean DEBUG = KernelStatus.initDebug();
    private static String tunnelURLPrefix = KernelStatus.initTunnelURLPrefix();

    private static final boolean initDebug() {
        boolean bl = false;
        try {
            boolean bl2 = bl = System.getProperty(DEBUG_PROP) != null;
            if ("true".equals(System.getProperty("java.class.version.applet")) || "true".equals(System.getProperty("java.vendor.applet")) || "true".equals(System.getProperty("java.version.applet"))) {
                isApplet = true;
                return false;
            }
            isApplet = Boolean.getBoolean("weblogic.j2ee.client.isWebStart");
            return bl;
        }
        catch (SecurityException securityException) {
            isApplet = true;
            return false;
        }
    }

    private static String initTunnelURLPrefix() {
        String string = null;
        if (!KernelStatus.isApplet()) {
            string = System.getProperty("weblogic.tunnel.prefix");
            if (string != null && "".equals(string)) {
                string = null;
            }
            if (string != null && string.charAt(0) != '/') {
                string = '/' + string;
            }
        }
        return string;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void setIsServer(boolean bl) {
        if (isIsServerSet) {
            try {
                Class.forName("com.bea.core.bootbundle.BootBundleLogger");
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot change <isServer>");
            }
        }
        isIsServerSet = true;
        isServer = bl;
    }

    public static boolean isServer() {
        return isServer;
    }

    public static void setIsThinIIOPClient(boolean bl) {
        if (isIsServerSet) {
            try {
                Class.forName("com.bea.core.bootbundle.BootBundleLogger");
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot change <isServer>");
            }
        }
        isthinIIOPClient = bl;
    }

    public static boolean isThinIIOPClient() {
        return isthinIIOPClient;
    }

    public static void setIsConfigured() {
        isConfigured = true;
    }

    public static boolean isConfigured() {
        return !isServer || isConfigured;
    }

    public static void initialized() {
        isInitialized = true;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static String getTunellingURLPrefix() {
        return tunnelURLPrefix;
    }

    public static String getTunellingURL(String string) {
        if (tunnelURLPrefix == null) {
            return string;
        }
        return tunnelURLPrefix + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<KernelStatus> clazz = KernelStatus.class;
        synchronized (KernelStatus.class) {
            intentionalShutdown = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isIntentionalShutdown() {
        return intentionalShutdown;
    }
}

