/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class Security {
    private static final AbstractSubject kernelID = Security.getKernelIdentity();

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException ace) {
            return null;
        }
    }

    public static Object runAs(Subject user, PrivilegedAction action) throws IllegalArgumentException {
        return SubjectManager.getSubjectManager().runAs(user, action);
    }

    public static Object runAs(Subject user, PrivilegedExceptionAction action) throws PrivilegedActionException, IllegalArgumentException {
        return SubjectManager.getSubjectManager().runAs(user, action);
    }

    public static Subject getCurrentSubject() {
        return SubjectManager.getSubjectManager().getCurrentSubject(kernelID).getSubject();
    }
}

