/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.IOException;
import java.util.Iterator;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextLocalMap;
import weblogic.workarea.WorkContextMap;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class WorkContextMapImpl
implements WorkContextMap,
WorkContextMapInterceptor {
    private static final AuditableThreadLocal localContextMap = AuditableThreadLocalFactory.createThreadLocal(new ThreadLocalInitialValue(){

        protected Object childValue(Object object) {
            if (object == null) {
                return null;
            }
            return ((WorkContextMapInterceptor)object).copyThreadContexts(2);
        }
    });

    WorkContextMapImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkContext put(String string, WorkContext workContext, int n) throws PropertyReadOnlyException {
        try {
            WorkContext workContext2 = this.getMap().put(string, workContext, n);
            return workContext2;
        }
        finally {
            if (this.getMapMaybe().isEmpty()) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkContext put(String string, WorkContext workContext) throws PropertyReadOnlyException {
        try {
            WorkContext workContext2 = this.getMap().put(string, workContext);
            return workContext2;
        }
        finally {
            if (this.getMapMaybe().isEmpty()) {
                this.reset();
            }
        }
    }

    public WorkContext get(String string) {
        WorkContextMap workContextMap = this.getMapMaybe();
        if (workContextMap == null) {
            return null;
        }
        return workContextMap.get(string);
    }

    public WorkContext remove(String string) throws NoWorkContextException, PropertyReadOnlyException {
        WorkContextMap workContextMap = this.getMapMaybe();
        if (workContextMap == null) {
            throw new NoWorkContextException();
        }
        WorkContext workContext = workContextMap.remove(string);
        if (workContextMap.isEmpty()) {
            this.reset();
        }
        return workContext;
    }

    public int getPropagationMode(String string) {
        if (this.isEmpty()) {
            return 1;
        }
        return this.getMapMaybe().getPropagationMode(string);
    }

    public boolean isPropagationModePresent(int n) {
        return this.getMapMaybe().isPropagationModePresent(n);
    }

    public boolean isEmpty() {
        return this.getMapMaybe() == null;
    }

    private void reset() {
        localContextMap.set(null);
    }

    public Iterator iterator() {
        WorkContextMap workContextMap = this.getMapMaybe();
        return workContextMap == null ? null : workContextMap.iterator();
    }

    public Iterator keys() {
        WorkContextMap workContextMap = this.getMapMaybe();
        return workContextMap == null ? null : workContextMap.keys();
    }

    public int version() {
        WorkContextMapInterceptor workContextMapInterceptor = (WorkContextMapInterceptor)localContextMap.get();
        return workContextMapInterceptor != null ? workContextMapInterceptor.version() : 0;
    }

    private final WorkContextMap getMapMaybe() {
        return (WorkContextMap)localContextMap.get();
    }

    private final WorkContextMap getMap() {
        WorkContextMap workContextMap = (WorkContextMap)localContextMap.get();
        if (workContextMap == null) {
            workContextMap = new WorkContextLocalMap();
            localContextMap.set(workContextMap);
        }
        return workContextMap;
    }

    public WorkContextMapInterceptor getInterceptor() {
        return (WorkContextMapInterceptor)((Object)this.getMapMaybe());
    }

    public void setInterceptor(WorkContextMapInterceptor workContextMapInterceptor) {
        localContextMap.set(workContextMapInterceptor);
    }

    public void sendRequest(WorkContextOutput workContextOutput, int n) throws IOException {
        WorkContextMapInterceptor workContextMapInterceptor = this.getInterceptor();
        if (workContextMapInterceptor != null) {
            workContextMapInterceptor.sendRequest(workContextOutput, n);
        }
    }

    public void sendResponse(WorkContextOutput workContextOutput, int n) throws IOException {
        WorkContextMapInterceptor workContextMapInterceptor = this.getInterceptor();
        if (workContextMapInterceptor != null) {
            workContextMapInterceptor.sendResponse(workContextOutput, 4);
        }
    }

    public void receiveRequest(WorkContextInput workContextInput) throws IOException {
        ((WorkContextMapInterceptor)((Object)this.getMap())).receiveRequest(workContextInput);
    }

    public void receiveResponse(WorkContextInput workContextInput) throws IOException {
        WorkContextMap workContextMap = this.getMapMaybe();
        if (workContextInput == null && workContextMap == null) {
            return;
        }
        if (workContextMap == null) {
            workContextMap = new WorkContextLocalMap();
            localContextMap.set(workContextMap);
        }
        ((WorkContextMapInterceptor)((Object)workContextMap)).receiveResponse(workContextInput);
        if (workContextMap.isEmpty()) {
            this.reset();
        }
    }

    public WorkContextMapInterceptor copyThreadContexts(int n) {
        WorkContextMapInterceptor workContextMapInterceptor = this.getInterceptor();
        if (workContextMapInterceptor != null) {
            return workContextMapInterceptor.copyThreadContexts(n);
        }
        return null;
    }

    public void restoreThreadContexts(WorkContextMapInterceptor workContextMapInterceptor) {
        if (workContextMapInterceptor != null) {
            ((WorkContextMapInterceptor)((Object)this.getMap())).restoreThreadContexts(workContextMapInterceptor);
        }
    }

    public WorkContextMapInterceptor suspendThreadContexts() {
        WorkContextMapInterceptor workContextMapInterceptor = this.getInterceptor();
        if (workContextMapInterceptor != null) {
            this.reset();
        }
        return workContextMapInterceptor;
    }

    public void resumeThreadContexts(WorkContextMapInterceptor workContextMapInterceptor) {
        localContextMap.set(workContextMapInterceptor);
    }
}

