




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.authentication;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to AuthenticatorMBean
 * (Interface=weblogic.management.security.authentication.AuthenticatorMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * The SSPI MBean that all Authentication providers with login services
 must extend. This MBean provides a ControlFlag to determine whether the Authentication
 provider is a REQUIRED, REQUISITE, SUFFICIENT, or OPTIONAL part of the login sequence.
 *
 * @xsdgen:complexType.typeName authenticatorType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 */
public class AuthenticatorMBeanImpl
  extends AuthenticationProviderMBeanImpl
  implements AuthenticatorMBean, java.io.Serializable
{
  private String _ControlFlag;


  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=AuthenticatorMBeanImpl)
   *
   */
  public AuthenticatorMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=AuthenticatorMBeanImpl)
   *
   */
  public AuthenticatorMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=AuthenticatorMBeanImpl)
   *
   */
  public AuthenticatorMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * <p>Returns how the login sequence uses the Authentication provider.</p>

 <p>A <code>REQUIRED</code> value specifies this LoginModule must succeed. Even if
 it fails, authentication proceeds down the list of LoginModules for the configured
 Authentication providers. This setting is the default.</p>
 
 <p>A <code>REQUISITE</code> value specifies this LoginModule must succeed. If other
 Authentication providers are configured and this LoginModule succeeds, authentication proceeds
 down the list of LoginModules. Otherwise, control is return to the application.</p>
 
 <p>A <code>SUFFICIENT</code> value specifies this LoginModule need not succeed. If it
 does succeed, return control to the application. If it fails and other Authentication providers
 are configured, authentication proceeds down the LoginModule list.</p>
 
 <p>An <code>OPTIONAL</code> value specifies this LoginModule need not succeed. Whether it
 succeeds or fails, authentication proceeds down the LoginModule list.</p>
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=getControlFlag)
   *
   * @xsdgen:element.name control-flag
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.enumeration REQUIRED
   * @xsdgen:element.enumeration REQUISITE
   * @xsdgen:element.enumeration SUFFICIENT
   * @xsdgen:element.enumeration OPTIONAL
   * @dynamic false
   */
  public String getControlFlag() {
    return _ControlFlag;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=isControlFlagInherited)
   *
   * return true if the value of property ControlFlag is inherited from template
   */
  public boolean isControlFlagInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=isControlFlagSet)
   *
   * @xsdgen:isSetMethodFor control-flag
   */
  public boolean isControlFlagSet() {
    return _isSet(8);
  }

  /**
   * <p>Sets how the login sequence uses the Authentication provider.</p>
 
 <p>A <code>REQUIRED</code> value specifies this LoginModule must succeed. Even if
 it fails, authentication proceeds down the list of LoginModules for the configured
 Authentication providers. This setting is the default.</p>
 
 <p>A <code>REQUISITE</code> value specifies this LoginModule must succeed. If other
 Authentication providers are configured and this LoginModule succeeds, authentication proceeds
 down the list of LoginModules. Otherwise, control is return to the application.</p>
 
 <p>A <code>SUFFICIENT</code> value specifies this LoginModule need not succeed. If it
 does succeed, return control to the application. If it fails and other Authentication providers
 are configured, authentication proceeds down the LoginModule list.</p>
 
 <p>An <code>OPTIONAL</code> value specifies this LoginModule need not succeed. Whether it
 succeeds or fails, authentication proceeds down the LoginModule list.</p>
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=setControlFlag)
   *
   */
  public void setControlFlag(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String[] _set = { "REQUIRED", "REQUISITE", "SUFFICIENT", "OPTIONAL" };
    param0 = LegalChecks.checkInEnum("ControlFlag", param0, _set);
    String _oldVal = _ControlFlag;
    _ControlFlag = param0;
    _postSet(8, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.AuthenticatorMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 8;
    }
    try {
      switch (idx) {
      case 8:
        _ControlFlag = "REQUIRED";
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends AuthenticationProviderMBeanImpl.Helper
  {
    private AuthenticatorMBeanImpl bean;

    protected Helper(AuthenticatorMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 8: return "ControlFlag";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("ControlFlag")) return 8;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isControlFlagSet()){
          buf.append("ControlFlag");
          buf.append(String.valueOf(bean.getControlFlag()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      AuthenticatorMBeanImpl otherTyped = (AuthenticatorMBeanImpl)other;
      computeDiff("ControlFlag", bean.getControlFlag(), otherTyped.getControlFlag(), false);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        AuthenticatorMBeanImpl original = (AuthenticatorMBeanImpl)event.getSourceBean();
        AuthenticatorMBeanImpl proposed = (AuthenticatorMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("ControlFlag")) {
          original.setControlFlag(proposed.getControlFlag());
          original._conditionalUnset(update.isUnsetUpdate(), 8);
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        AuthenticatorMBeanImpl copy = (AuthenticatorMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("ControlFlag")) && bean.isControlFlagSet()) {
          copy.setControlFlag((String)bean.getControlFlag());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
        }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends AuthenticationProviderMBeanImpl.SchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 12:
        if (false) return -1;
        else if (s.equals("control-flag"))
          return 8;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 8: return "control-flag";
        default: return super.getElementName(propIndex);
      }
    }






    public boolean isBean(int propIndex) {
      switch(propIndex) {
      default:
        return super.isBean(propIndex);
      }
    }










  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.authentication.AuthenticatorMBean"; 
  }

}
