




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.utils;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to LDAPServerMBean
 * (Interface=weblogic.management.utils.LDAPServerMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * The LDAPServerMBean interface defines methods used to get/set the configuration attributes
 that are required to communicate with an external LDAP server.
 *
 * @xsdgen:complexType.typeName ldap-serverType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class LDAPServerMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements LDAPServerMBean, java.io.Serializable
{
  private boolean _BindAnonymouslyOnReferrals;
  private boolean _CacheEnabled;
  private int _CacheSize;
  private int _CacheTTL;
  private int _ConnectTimeout;
  private int _ConnectionPoolSize;
  private int _ConnectionRetryLimit;
  private String _Credential;
  private byte[] _CredentialEncrypted;
  private boolean _FollowReferrals;
  private String _Host;
  private int _ParallelConnectDelay;
  private int _Port;
  private String _Principal;
  private int _ResultsTimeLimit;
  private boolean _SSLEnabled;


  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=LDAPServerMBeanImpl)
   *
   */
  public LDAPServerMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=LDAPServerMBeanImpl)
   *
   */
  public LDAPServerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=LDAPServerMBeanImpl)
   *
   */
  public LDAPServerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * Returns the host name or IP address of the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getHost)
   *
   * @xsdgen:element.name host
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default localhost
   * @dynamic true
   */
  public String getHost() {
    return _Host;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isHostInherited)
   *
   * return true if the value of property Host is inherited from template
   */
  public boolean isHostInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isHostSet)
   *
   * @xsdgen:isSetMethodFor host
   */
  public boolean isHostSet() {
    return _isSet(2);
  }

  /**
   * Sets the host name or IP address of the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setHost)
   *
   */
  public void setHost(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _Host;
    _Host = param0;
    _postSet(2, _oldVal, param0);
  }

  /**
   * Returns the port number on which the LDAP server is listening.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getPort)
   *
   * @xsdgen:element.name port
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 1
   * @xsdgen:element.maxInclusive 65534
   * @xsdgen:element.default 389
   * @dynamic true
   */
  public int getPort() {
    return _Port;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isPortInherited)
   *
   * return true if the value of property Port is inherited from template
   */
  public boolean isPortInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isPortSet)
   *
   * @xsdgen:isSetMethodFor port
   */
  public boolean isPortSet() {
    return _isSet(3);
  }

  /**
   * Sets the port number on which the LDAP server is listening.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setPort)
   *
   */
  public void setPort(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("Port", param0, 1, 65534);
    int _oldVal = _Port;
    _Port = param0;
    _postSet(3, _oldVal, param0);
  }

  /**
   * Returns whether SSL will be used to connect to the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isSSLEnabled)
   *
   * @xsdgen:element.name ssl-enabled
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic true
   */
  public boolean isSSLEnabled() {
    return _SSLEnabled;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isSSLEnabledInherited)
   *
   * return true if the value of property SSLEnabled is inherited from template
   */
  public boolean isSSLEnabledInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isSSLEnabledSet)
   *
   * @xsdgen:isSetMethodFor ssl-enabled
   */
  public boolean isSSLEnabledSet() {
    return _isSet(4);
  }

  /**
   * Sets whether SSL will be used to connect to the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setSSLEnabled)
   *
   */
  public void setSSLEnabled(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _SSLEnabled;
    _SSLEnabled = param0;
    _postSet(4, _oldVal, param0);
  }

  /**
   * Returns the Distinguished Name (DN) of the LDAP user that is
 used by WebLogic Server to connect to the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getPrincipal)
   *
   * @xsdgen:element.name principal
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic true
   */
  public String getPrincipal() {
    return _Principal;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isPrincipalInherited)
   *
   * return true if the value of property Principal is inherited from template
   */
  public boolean isPrincipalInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isPrincipalSet)
   *
   * @xsdgen:isSetMethodFor principal
   */
  public boolean isPrincipalSet() {
    return _isSet(5);
  }

  /**
   * Sets the Distinguished Name (DN) of the LDAP user that is
 used by WebLogic Server to connect to the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setPrincipal)
   *
   */
  public void setPrincipal(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _Principal;
    _Principal = param0;
    _postSet(5, _oldVal, param0);
  }

  /**
   * Returns the credential (generally a password) used to authenticate
 the LDAP user that is defined in the Principal attribute.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getCredential)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getCredential() {
    byte[] bEncrypted = getCredentialEncrypted();
    return (bEncrypted == null) ? null : _decrypt("Credential", bEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCredentialInherited)
   *
   * return true if the value of property Credential is inherited from template
   */
  public boolean isCredentialInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCredentialSet)
   *
   * @xsdgen:isSetMethodFor credential
   */
  public boolean isCredentialSet() {
    return isCredentialEncryptedSet();
  }

  /**
   * Sets the credential (generally a password) used to authenticate
 the LDAP user that is defined in the Principal attribute.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCredential)
   *
   */
  public void setCredential(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    setCredentialEncrypted(param0 == null ? null : _encrypt("Credential", param0));
  }

  /**
   * Returns the credential (generally a password) used to authenticate
 the LDAP user that is defined in the Principal attribute.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getCredentialEncrypted)
   *
   * @xsdgen:element.exclude
   */
  public byte[] getCredentialEncrypted() {
    return _getHelper()._cloneArray(_CredentialEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getCredentialEncryptedAsString)
   *
   * @xsdgen:element.name credential-encrypted
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getCredentialEncryptedAsString() {
    byte[] obj = getCredentialEncrypted();
    return (obj == null) ? null : (new String(obj));
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCredentialEncryptedInherited)
   *
   * return true if the value of property CredentialEncrypted is inherited from template
   */
  public boolean isCredentialEncryptedInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCredentialEncryptedSet)
   *
   * @xsdgen:isSetMethodFor credential-encrypted
   */
  public boolean isCredentialEncryptedSet() {
    return _isSet(7);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCredentialEncryptedAsString)
   *
   */
  public void setCredentialEncryptedAsString(String param0) {
    try {
    byte[] encryptedBytes = (param0 == null) ? null : param0.getBytes();
    setCredentialEncrypted(encryptedBytes);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns whether to cache LDAP requests with the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheEnabled)
   *
   * @xsdgen:element.name cache-enabled
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default true
   * @dynamic true
   */
  public boolean isCacheEnabled() {
    return _CacheEnabled;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheEnabledInherited)
   *
   * return true if the value of property CacheEnabled is inherited from template
   */
  public boolean isCacheEnabledInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheEnabledSet)
   *
   * @xsdgen:isSetMethodFor cache-enabled
   */
  public boolean isCacheEnabledSet() {
    return _isSet(8);
  }

  /**
   * Sets whether to cache LDAP requests with the LDAP server.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCacheEnabled)
   *
   */
  public void setCacheEnabled(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _CacheEnabled;
    _CacheEnabled = param0;
    _postSet(8, _oldVal, param0);
  }

  /**
   * Returns the size of the cache in K.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getCacheSize)
   *
   * @xsdgen:element.name cache-size
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.default 32
   * @dynamic true
   */
  public int getCacheSize() {
    return _CacheSize;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheSizeInherited)
   *
   * return true if the value of property CacheSize is inherited from template
   */
  public boolean isCacheSizeInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheSizeSet)
   *
   * @xsdgen:isSetMethodFor cache-size
   */
  public boolean isCacheSizeSet() {
    return _isSet(9);
  }

  /**
   * Sets the size of the cache in K.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCacheSize)
   *
   */
  public void setCacheSize(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkMin("CacheSize", param0, 0);
    int _oldVal = _CacheSize;
    _CacheSize = param0;
    _postSet(9, _oldVal, param0);
  }

  /**
   * Returns the time-to-live (TTL) of the cache in seconds.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getCacheTTL)
   *
   * @xsdgen:element.name cache-ttl
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.default 60
   * @dynamic true
   */
  public int getCacheTTL() {
    return _CacheTTL;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheTTLInherited)
   *
   * return true if the value of property CacheTTL is inherited from template
   */
  public boolean isCacheTTLInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isCacheTTLSet)
   *
   * @xsdgen:isSetMethodFor cache-ttl
   */
  public boolean isCacheTTLSet() {
    return _isSet(10);
  }

  /**
   * Sets the time-to-live (TTL) of the cache in seconds.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCacheTTL)
   *
   */
  public void setCacheTTL(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkMin("CacheTTL", param0, 0);
    int _oldVal = _CacheTTL;
    _CacheTTL = param0;
    _postSet(10, _oldVal, param0);
  }

  /**
   * Returns whether referrals will automatically be followed within the LDAP Directory.
 If set to false, then a Referral exception will be thrown when referrals are
 encountered during LDAP requests.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isFollowReferrals)
   *
   * @xsdgen:element.name follow-referrals
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default true
   * @dynamic true
   */
  public boolean isFollowReferrals() {
    return _FollowReferrals;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isFollowReferralsInherited)
   *
   * return true if the value of property FollowReferrals is inherited from template
   */
  public boolean isFollowReferralsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isFollowReferralsSet)
   *
   * @xsdgen:isSetMethodFor follow-referrals
   */
  public boolean isFollowReferralsSet() {
    return _isSet(11);
  }

  /**
   * Sets whether referrals will automatically be followed within the LDAP Directory.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setFollowReferrals)
   *
   */
  public void setFollowReferrals(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _FollowReferrals;
    _FollowReferrals = param0;
    _postSet(11, _oldVal, param0);
  }

  /**
   * Returns whether to anonymously bind when following referrals within the LDAP directory. 
 If set to false, then the current Principal and Credential will be used.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isBindAnonymouslyOnReferrals)
   *
   * @xsdgen:element.name bind-anonymously-on-referrals
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default false
   * @dynamic false
   */
  public boolean isBindAnonymouslyOnReferrals() {
    return _BindAnonymouslyOnReferrals;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isBindAnonymouslyOnReferralsInherited)
   *
   * return true if the value of property BindAnonymouslyOnReferrals is inherited from template
   */
  public boolean isBindAnonymouslyOnReferralsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isBindAnonymouslyOnReferralsSet)
   *
   * @xsdgen:isSetMethodFor bind-anonymously-on-referrals
   */
  public boolean isBindAnonymouslyOnReferralsSet() {
    return _isSet(12);
  }

  /**
   * Sets whether to anonymously bind when following referrals within the LDAP directory.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setBindAnonymouslyOnReferrals)
   *
   */
  public void setBindAnonymouslyOnReferrals(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _BindAnonymouslyOnReferrals;
    _BindAnonymouslyOnReferrals = param0;
    _postSet(12, _oldVal, param0);
  }

  /**
   * Returns the maximum number of milliseconds to wait for results before timing out.
 If set to 0, there is no maximum time limit.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getResultsTimeLimit)
   *
   * @xsdgen:element.name results-time-limit
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default 0
   * @dynamic true
   */
  public int getResultsTimeLimit() {
    return _ResultsTimeLimit;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isResultsTimeLimitInherited)
   *
   * return true if the value of property ResultsTimeLimit is inherited from template
   */
  public boolean isResultsTimeLimitInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isResultsTimeLimitSet)
   *
   * @xsdgen:isSetMethodFor results-time-limit
   */
  public boolean isResultsTimeLimitSet() {
    return _isSet(13);
  }

  /**
   * Sets the maximum number of milliseconds to wait for results before timing out. If set to 0, 
 there is no maximum time limit.

 <p>The default setting is 0. This default value can result in a slowdown in WebLogic Server execution 
 if the LDAP server is unavailable. In addition, if WebLogic Server has multiple LDAP Authentication 
 providers configured, the failure to connect to one LDAP server may block the use of the other LDAP 
 Authentication providers.</p>

 <p>Oracle recommends that you specify a non-zero value; for example, 60 seconds.</p>
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setResultsTimeLimit)
   *
   */
  public void setResultsTimeLimit(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    int _oldVal = _ResultsTimeLimit;
    _ResultsTimeLimit = param0;
    _postSet(13, _oldVal, param0);
  }

  /**
   * Returns the maximum number of seconds to wait for the LDAP connection to be established.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getConnectTimeout)
   *
   * @xsdgen:element.name connect-timeout
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default 0
   * @dynamic true
   */
  public int getConnectTimeout() {
    return _ConnectTimeout;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectTimeoutInherited)
   *
   * return true if the value of property ConnectTimeout is inherited from template
   */
  public boolean isConnectTimeoutInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectTimeoutSet)
   *
   * @xsdgen:isSetMethodFor connect-timeout
   */
  public boolean isConnectTimeoutSet() {
    return _isSet(14);
  }

  /**
   * Sets the maximum number of seconds to wait for the LDAP connection to be established.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setConnectTimeout)
   *
   */
  public void setConnectTimeout(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    int _oldVal = _ConnectTimeout;
    _ConnectTimeout = param0;
    _postSet(14, _oldVal, param0);
  }

  /**
   * <p>Returns the number of seconds to delay when making concurrent attempts to connect to multiple servers.</p>
 
 <p>If set to 0, connection attempts are serialized. An attempt is made to connect to the first server in the list.
 The next entry in the list is tried only if the attempt to connect to the current host fails. This might 
 cause your application to block for unacceptably long time if a host is down. If set to greater than 0, 
 another connection setup thread is started after this number of delay seconds has passed.</p>
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getParallelConnectDelay)
   *
   * @xsdgen:element.name parallel-connect-delay
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default 0
   * @dynamic true
   */
  public int getParallelConnectDelay() {
    return _ParallelConnectDelay;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isParallelConnectDelayInherited)
   *
   * return true if the value of property ParallelConnectDelay is inherited from template
   */
  public boolean isParallelConnectDelayInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isParallelConnectDelaySet)
   *
   * @xsdgen:isSetMethodFor parallel-connect-delay
   */
  public boolean isParallelConnectDelaySet() {
    return _isSet(15);
  }

  /**
   * Sets the number of seconds to delay when making concurrent attempts to connect to multiple servers.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setParallelConnectDelay)
   *
   */
  public void setParallelConnectDelay(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    int _oldVal = _ParallelConnectDelay;
    _ParallelConnectDelay = param0;
    _postSet(15, _oldVal, param0);
  }

  /**
   * Specifies the number of times to attempt to connect to the LDAP server
 if the initial connection failed.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getConnectionRetryLimit)
   *
   * @xsdgen:element.name connection-retry-limit
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default 1
   * @dynamic true
   */
  public int getConnectionRetryLimit() {
    return _ConnectionRetryLimit;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectionRetryLimitInherited)
   *
   * return true if the value of property ConnectionRetryLimit is inherited from template
   */
  public boolean isConnectionRetryLimitInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectionRetryLimitSet)
   *
   * @xsdgen:isSetMethodFor connection-retry-limit
   */
  public boolean isConnectionRetryLimitSet() {
    return _isSet(16);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setConnectionRetryLimit)
   *
   */
  public void setConnectionRetryLimit(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    int _oldVal = _ConnectionRetryLimit;
    _ConnectionRetryLimit = param0;
    _postSet(16, _oldVal, param0);
  }

  /**
   * The LDAP connection pool size. Default is 6.
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=getConnectionPoolSize)
   *
   * @xsdgen:element.name connection-pool-size
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default 6
   * @dynamic true
   */
  public int getConnectionPoolSize() {
    return _ConnectionPoolSize;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectionPoolSizeInherited)
   *
   * return true if the value of property ConnectionPoolSize is inherited from template
   */
  public boolean isConnectionPoolSizeInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=isConnectionPoolSizeSet)
   *
   * @xsdgen:isSetMethodFor connection-pool-size
   */
  public boolean isConnectionPoolSizeSet() {
    return _isSet(17);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setConnectionPoolSize)
   *
   */
  public void setConnectionPoolSize(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    int _oldVal = _ConnectionPoolSize;
    _ConnectionPoolSize = param0;
    _postSet(17, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }

  /**
   * 
   * (Interface=weblogic.management.utils.LDAPServerMBean Attribute=setCredentialEncrypted)
   *
   */
  public void setCredentialEncrypted(byte[] param0) {
    byte[] _oldVal = _CredentialEncrypted;
    if(_isProductionModeEnabled()) {
      if(param0 != null && !_isEncrypted(param0)) {
        throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: CredentialEncrypted of LDAPServerMBean");
      }
    }
    _getHelper()._clearArray(_CredentialEncrypted);
    _CredentialEncrypted = _getHelper()._cloneArray(param0);
    _postSet(7, _oldVal, param0);
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
      if (idx == 6) _markSet(7, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 9;
    }
    try {
      switch (idx) {
      case 9:
        _CacheSize = 32;
        if (initOne) break;
      case 10:
        _CacheTTL = 60;
        if (initOne) break;
      case 14:
        _ConnectTimeout = 0;
        if (initOne) break;
      case 17:
        _ConnectionPoolSize = 6;
        if (initOne) break;
      case 16:
        _ConnectionRetryLimit = 1;
        if (initOne) break;
      case 6:
        _CredentialEncrypted = null;
        if (initOne) break;
      case 7:
        _CredentialEncrypted = null;
        if (initOne) break;
      case 2:
        _Host = "localhost";
        if (initOne) break;
      case 15:
        _ParallelConnectDelay = 0;
        if (initOne) break;
      case 3:
        _Port = 389;
        if (initOne) break;
      case 5:
        _Principal = null;
        if (initOne) break;
      case 13:
        _ResultsTimeLimit = 0;
        if (initOne) break;
      case 12:
        _BindAnonymouslyOnReferrals = false;
        if (initOne) break;
      case 8:
        _CacheEnabled = true;
        if (initOne) break;
      case 11:
        _FollowReferrals = true;
        if (initOne) break;
      case 4:
        _SSLEnabled = false;
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private LDAPServerMBeanImpl bean;

    protected Helper(LDAPServerMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 9: return "CacheSize";
      case 10: return "CacheTTL";
      case 14: return "ConnectTimeout";
      case 17: return "ConnectionPoolSize";
      case 16: return "ConnectionRetryLimit";
      case 6: return "Credential";
      case 7: return "CredentialEncrypted";
      case 2: return "Host";
      case 15: return "ParallelConnectDelay";
      case 3: return "Port";
      case 5: return "Principal";
      case 13: return "ResultsTimeLimit";
      case 12: return "BindAnonymouslyOnReferrals";
      case 8: return "CacheEnabled";
      case 11: return "FollowReferrals";
      case 4: return "SSLEnabled";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("CacheSize")) return 9;
      else if (propName.equals("CacheTTL")) return 10;
      else if (propName.equals("ConnectTimeout")) return 14;
      else if (propName.equals("ConnectionPoolSize")) return 17;
      else if (propName.equals("ConnectionRetryLimit")) return 16;
      else if (propName.equals("Credential")) return 6;
      else if (propName.equals("CredentialEncrypted")) return 7;
      else if (propName.equals("Host")) return 2;
      else if (propName.equals("ParallelConnectDelay")) return 15;
      else if (propName.equals("Port")) return 3;
      else if (propName.equals("Principal")) return 5;
      else if (propName.equals("ResultsTimeLimit")) return 13;
      else if (propName.equals("BindAnonymouslyOnReferrals")) return 12;
      else if (propName.equals("CacheEnabled")) return 8;
      else if (propName.equals("FollowReferrals")) return 11;
      else if (propName.equals("SSLEnabled")) return 4;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isCacheSizeSet()){
          buf.append("CacheSize");
          buf.append(String.valueOf(bean.getCacheSize()));
        }
        if (bean.isCacheTTLSet()){
          buf.append("CacheTTL");
          buf.append(String.valueOf(bean.getCacheTTL()));
        }
        if (bean.isConnectTimeoutSet()){
          buf.append("ConnectTimeout");
          buf.append(String.valueOf(bean.getConnectTimeout()));
        }
        if (bean.isConnectionPoolSizeSet()){
          buf.append("ConnectionPoolSize");
          buf.append(String.valueOf(bean.getConnectionPoolSize()));
        }
        if (bean.isConnectionRetryLimitSet()){
          buf.append("ConnectionRetryLimit");
          buf.append(String.valueOf(bean.getConnectionRetryLimit()));
        }
        if (bean.isCredentialSet()){
          buf.append("Credential");
          buf.append(String.valueOf(bean.getCredential()));
        }
        if (bean.isCredentialEncryptedSet()){
          buf.append("CredentialEncrypted");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getCredentialEncrypted())));
        }
        if (bean.isHostSet()){
          buf.append("Host");
          buf.append(String.valueOf(bean.getHost()));
        }
        if (bean.isParallelConnectDelaySet()){
          buf.append("ParallelConnectDelay");
          buf.append(String.valueOf(bean.getParallelConnectDelay()));
        }
        if (bean.isPortSet()){
          buf.append("Port");
          buf.append(String.valueOf(bean.getPort()));
        }
        if (bean.isPrincipalSet()){
          buf.append("Principal");
          buf.append(String.valueOf(bean.getPrincipal()));
        }
        if (bean.isResultsTimeLimitSet()){
          buf.append("ResultsTimeLimit");
          buf.append(String.valueOf(bean.getResultsTimeLimit()));
        }
        if (bean.isBindAnonymouslyOnReferralsSet()){
          buf.append("BindAnonymouslyOnReferrals");
          buf.append(String.valueOf(bean.isBindAnonymouslyOnReferrals()));
        }
        if (bean.isCacheEnabledSet()){
          buf.append("CacheEnabled");
          buf.append(String.valueOf(bean.isCacheEnabled()));
        }
        if (bean.isFollowReferralsSet()){
          buf.append("FollowReferrals");
          buf.append(String.valueOf(bean.isFollowReferrals()));
        }
        if (bean.isSSLEnabledSet()){
          buf.append("SSLEnabled");
          buf.append(String.valueOf(bean.isSSLEnabled()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      LDAPServerMBeanImpl otherTyped = (LDAPServerMBeanImpl)other;
      computeDiff("CacheSize", bean.getCacheSize(), otherTyped.getCacheSize(), true);
      computeDiff("CacheTTL", bean.getCacheTTL(), otherTyped.getCacheTTL(), true);
      computeDiff("ConnectTimeout", bean.getConnectTimeout(), otherTyped.getConnectTimeout(), true);
      computeDiff("ConnectionPoolSize", bean.getConnectionPoolSize(), otherTyped.getConnectionPoolSize(), true);
      computeDiff("ConnectionRetryLimit", bean.getConnectionRetryLimit(), otherTyped.getConnectionRetryLimit(), true);
      computeDiff("CredentialEncrypted", bean.getCredentialEncrypted(), otherTyped.getCredentialEncrypted(), true);
      computeDiff("Host", bean.getHost(), otherTyped.getHost(), true);
      computeDiff("ParallelConnectDelay", bean.getParallelConnectDelay(), otherTyped.getParallelConnectDelay(), true);
      computeDiff("Port", bean.getPort(), otherTyped.getPort(), true);
      computeDiff("Principal", bean.getPrincipal(), otherTyped.getPrincipal(), true);
      computeDiff("ResultsTimeLimit", bean.getResultsTimeLimit(), otherTyped.getResultsTimeLimit(), true);
      computeDiff("BindAnonymouslyOnReferrals", bean.isBindAnonymouslyOnReferrals(), otherTyped.isBindAnonymouslyOnReferrals(), false);
      computeDiff("CacheEnabled", bean.isCacheEnabled(), otherTyped.isCacheEnabled(), true);
      computeDiff("FollowReferrals", bean.isFollowReferrals(), otherTyped.isFollowReferrals(), true);
      computeDiff("SSLEnabled", bean.isSSLEnabled(), otherTyped.isSSLEnabled(), true);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        LDAPServerMBeanImpl original = (LDAPServerMBeanImpl)event.getSourceBean();
        LDAPServerMBeanImpl proposed = (LDAPServerMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("CacheSize")) {
          original.setCacheSize(proposed.getCacheSize());
          original._conditionalUnset(update.isUnsetUpdate(), 9);
        } else
        if (prop.equals("CacheTTL")) {
          original.setCacheTTL(proposed.getCacheTTL());
          original._conditionalUnset(update.isUnsetUpdate(), 10);
        } else
        if (prop.equals("ConnectTimeout")) {
          original.setConnectTimeout(proposed.getConnectTimeout());
          original._conditionalUnset(update.isUnsetUpdate(), 14);
        } else
        if (prop.equals("ConnectionPoolSize")) {
          original.setConnectionPoolSize(proposed.getConnectionPoolSize());
          original._conditionalUnset(update.isUnsetUpdate(), 17);
        } else
        if (prop.equals("ConnectionRetryLimit")) {
          original.setConnectionRetryLimit(proposed.getConnectionRetryLimit());
          original._conditionalUnset(update.isUnsetUpdate(), 16);
        } else
        if (prop.equals("Credential")) {
        } else
        if (prop.equals("CredentialEncrypted")) {
          original.setCredentialEncrypted(proposed.getCredentialEncrypted());
          original._conditionalUnset(update.isUnsetUpdate(), 7);
        } else
        if (prop.equals("Host")) {
          original.setHost(proposed.getHost());
          original._conditionalUnset(update.isUnsetUpdate(), 2);
        } else
        if (prop.equals("ParallelConnectDelay")) {
          original.setParallelConnectDelay(proposed.getParallelConnectDelay());
          original._conditionalUnset(update.isUnsetUpdate(), 15);
        } else
        if (prop.equals("Port")) {
          original.setPort(proposed.getPort());
          original._conditionalUnset(update.isUnsetUpdate(), 3);
        } else
        if (prop.equals("Principal")) {
          original.setPrincipal(proposed.getPrincipal());
          original._conditionalUnset(update.isUnsetUpdate(), 5);
        } else
        if (prop.equals("ResultsTimeLimit")) {
          original.setResultsTimeLimit(proposed.getResultsTimeLimit());
          original._conditionalUnset(update.isUnsetUpdate(), 13);
        } else
        if (prop.equals("BindAnonymouslyOnReferrals")) {
          original.setBindAnonymouslyOnReferrals(proposed.isBindAnonymouslyOnReferrals());
          original._conditionalUnset(update.isUnsetUpdate(), 12);
        } else
        if (prop.equals("CacheEnabled")) {
          original.setCacheEnabled(proposed.isCacheEnabled());
          original._conditionalUnset(update.isUnsetUpdate(), 8);
        } else
        if (prop.equals("FollowReferrals")) {
          original.setFollowReferrals(proposed.isFollowReferrals());
          original._conditionalUnset(update.isUnsetUpdate(), 11);
        } else
        if (prop.equals("SSLEnabled")) {
          original.setSSLEnabled(proposed.isSSLEnabled());
          original._conditionalUnset(update.isUnsetUpdate(), 4);
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        LDAPServerMBeanImpl copy = (LDAPServerMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("CacheSize")) && bean.isCacheSizeSet()) {
          copy.setCacheSize((int)bean.getCacheSize());
        }
        if ((excludeProps == null || !excludeProps.contains("CacheTTL")) && bean.isCacheTTLSet()) {
          copy.setCacheTTL((int)bean.getCacheTTL());
        }
        if ((excludeProps == null || !excludeProps.contains("ConnectTimeout")) && bean.isConnectTimeoutSet()) {
          copy.setConnectTimeout((int)bean.getConnectTimeout());
        }
        if ((excludeProps == null || !excludeProps.contains("ConnectionPoolSize")) && bean.isConnectionPoolSizeSet()) {
          copy.setConnectionPoolSize((int)bean.getConnectionPoolSize());
        }
        if ((excludeProps == null || !excludeProps.contains("ConnectionRetryLimit")) && bean.isConnectionRetryLimitSet()) {
          copy.setConnectionRetryLimit((int)bean.getConnectionRetryLimit());
        }
        if ((excludeProps == null || !excludeProps.contains("CredentialEncrypted")) && bean.isCredentialEncryptedSet()) {
          o = bean.getCredentialEncrypted();
          copy.setCredentialEncrypted((o == null) ? null : (byte[])((byte[])o).clone());
        }
        if ((excludeProps == null || !excludeProps.contains("Host")) && bean.isHostSet()) {
          copy.setHost((String)bean.getHost());
        }
        if ((excludeProps == null || !excludeProps.contains("ParallelConnectDelay")) && bean.isParallelConnectDelaySet()) {
          copy.setParallelConnectDelay((int)bean.getParallelConnectDelay());
        }
        if ((excludeProps == null || !excludeProps.contains("Port")) && bean.isPortSet()) {
          copy.setPort((int)bean.getPort());
        }
        if ((excludeProps == null || !excludeProps.contains("Principal")) && bean.isPrincipalSet()) {
          copy.setPrincipal((String)bean.getPrincipal());
        }
        if ((excludeProps == null || !excludeProps.contains("ResultsTimeLimit")) && bean.isResultsTimeLimitSet()) {
          copy.setResultsTimeLimit((int)bean.getResultsTimeLimit());
        }
        if ((excludeProps == null || !excludeProps.contains("BindAnonymouslyOnReferrals")) && bean.isBindAnonymouslyOnReferralsSet()) {
          copy.setBindAnonymouslyOnReferrals((boolean)bean.isBindAnonymouslyOnReferrals());
        }
        if ((excludeProps == null || !excludeProps.contains("CacheEnabled")) && bean.isCacheEnabledSet()) {
          copy.setCacheEnabled((boolean)bean.isCacheEnabled());
        }
        if ((excludeProps == null || !excludeProps.contains("FollowReferrals")) && bean.isFollowReferralsSet()) {
          copy.setFollowReferrals((boolean)bean.isFollowReferrals());
        }
        if ((excludeProps == null || !excludeProps.contains("SSLEnabled")) && bean.isSSLEnabledSet()) {
          copy.setSSLEnabled((boolean)bean.isSSLEnabled());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
                                                     }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 10:
        if (false) return -1;
        else if (s.equals("cache-size"))
          return 9;
        else if (s.equals("credential"))
          return 6;
        break;
      case 8:
        if (false) return -1;
        else if (s.equals("cachettl"))
          return 10;
        break;
      case 15:
        if (false) return -1;
        else if (s.equals("connect-timeout"))
          return 14;
        break;
      case 20:
        if (false) return -1;
        else if (s.equals("connection-pool-size"))
          return 17;
        else if (s.equals("credential-encrypted"))
          return 7;
        break;
      case 22:
        if (false) return -1;
        else if (s.equals("connection-retry-limit"))
          return 16;
        else if (s.equals("parallel-connect-delay"))
          return 15;
        break;
      case 4:
        if (false) return -1;
        else if (s.equals("host"))
          return 2;
        else if (s.equals("port"))
          return 3;
        break;
      case 9:
        if (false) return -1;
        else if (s.equals("principal"))
          return 5;
        break;
      case 18:
        if (false) return -1;
        else if (s.equals("results-time-limit"))
          return 13;
        break;
      case 29:
        if (false) return -1;
        else if (s.equals("bind-anonymously-on-referrals"))
          return 12;
        break;
      case 13:
        if (false) return -1;
        else if (s.equals("cache-enabled"))
          return 8;
        break;
      case 16:
        if (false) return -1;
        else if (s.equals("follow-referrals"))
          return 11;
        break;
      case 11:
        if (false) return -1;
        else if (s.equals("ssl-enabled"))
          return 4;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 9: return "cache-size";
        case 10: return "cachettl";
        case 14: return "connect-timeout";
        case 17: return "connection-pool-size";
        case 16: return "connection-retry-limit";
        case 6: return "credential";
        case 7: return "credential-encrypted";
        case 2: return "host";
        case 15: return "parallel-connect-delay";
        case 3: return "port";
        case 5: return "principal";
        case 13: return "results-time-limit";
        case 12: return "bind-anonymously-on-referrals";
        case 8: return "cache-enabled";
        case 11: return "follow-referrals";
        case 4: return "ssl-enabled";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      default:
        return super.isArray(propIndex);
      }
    }














  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.utils.LDAPServerMBean"; 
  }

}
