/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import weblogic.corba.client.security.ClientSecurityContext;
import weblogic.corba.client.security.CompoundSecMechListImpl;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.security.auth.login.PasswordCredential;

public class EstablishContextImpl {
    private static final boolean DEBUG = false;
    private EstablishContext ctx = new EstablishContext();

    public EstablishContextImpl(CompoundSecMechListImpl mechList, Subject subject, Codec codec) throws InvalidTypeForEncoding, FormatMismatch, UnsupportedEncodingException {
        this.ctx.client_context_id = ClientSecurityContext.allocateClientContext(subject).getContextId();
        this.ctx.authorization_token = new AuthorizationElement[0];
        this.ctx.identity_token = new IdentityToken();
        Object clientAuth = null;
        PasswordCredential pc = null;
        if (subject != null) {
            Set<PasswordCredential> creds = subject.getPublicCredentials(PasswordCredential.class);
            Iterator<PasswordCredential> iter = creds.iterator();
            if (iter.hasNext()) {
                pc = iter.next();
            } else {
                try {
                    creds = subject.getPrivateCredentials(PasswordCredential.class);
                    iter = creds.iterator();
                    if (iter.hasNext()) {
                        pc = iter.next();
                    }
                }
                catch (AccessControlException ace) {
                    // empty catch block
                }
            }
        }
        String targetName = null;
        boolean hasGSSUP = mechList.hasGSSUP();
        boolean hasGSSUPIdentity = mechList.hasGSSUPIdentity();
        if (hasGSSUP) {
            byte[] target = mechList.getGSSUPTargetName();
            targetName = GSSUtil.extractGSSUPGSSNTExportedName(target);
        }
        if (hasGSSUP && pc != null) {
            InitialContextToken ict = new InitialContextToken(GSSUtil.getQuotedGSSUserName(pc.getUsername()).getBytes("UTF8"), pc.getPassword().getBytes("UTF8"), mechList.getGSSUPTargetName());
            Any a = ORB.init().create_any();
            InitialContextTokenHelper.insert(a, ict);
            this.ctx.client_authentication_token = GSSUtil.getGSSUPToken(codec.encode_value(a));
            this.ctx.identity_token.absent(true);
        } else if (hasGSSUPIdentity) {
            if (subject == null) {
                this.ctx.identity_token.anonymous(true);
            } else {
                Set<Principal> principals = subject.getPrincipals(Principal.class);
                Iterator<Principal> iter = principals.iterator();
                if (iter.hasNext()) {
                    String principal = iter.next().getName();
                    if (targetName != null) {
                        principal = principal + "@" + targetName;
                    }
                    byte[] principalName = GSSUtil.createGSSUPGSSNTExportedName(principal);
                    this.ctx.identity_token.principal_name(principalName);
                }
            }
        }
    }

    public final EstablishContext getContext() {
        return this.ctx;
    }

    private static void p(String msg) {
        System.out.println("<EstablishContextImpl>: " + msg);
    }
}

