/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import javax.security.auth.Subject;
import weblogic.corba.client.security.SubjectStackDelegateImpl;
import weblogic.kernel.AuditableThread;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.DelegatingSubjectStack;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectProxy;

public class SubjectManagerImpl
extends SubjectManager {
    private DelegatingSubjectStack stack = new DelegatingSubjectStack();

    public SubjectManagerImpl() {
        this.addDelegate();
    }

    public DelegatingSubjectStack getStack() {
        return this.stack;
    }

    public void addDelegate() {
        this.stack.addDelegate(new SubjectStackDelegateImpl());
    }

    protected AbstractSubject getKernelIdentity() {
        return null;
    }

    public AbstractSubject getCurrentSubject(AbstractSubject kernelIdentity) {
        AbstractSubject sub = this.stack.getCurrentSubject(kernelIdentity);
        if (sub == null) {
            return SubjectProxy.ANON;
        }
        return sub;
    }

    public AbstractSubject getCurrentSubject(AbstractSubject kernelIdentity, AuditableThread auditableThread) {
        return this.stack.getCurrentSubject(kernelIdentity, auditableThread);
    }

    public void pushSubject(AbstractSubject kernelIdentity, AbstractSubject userIdentity) {
        this.stack.pushSubject(kernelIdentity, userIdentity);
    }

    public void popSubject(AbstractSubject kernelIdentity) {
        this.stack.popSubject(kernelIdentity);
    }

    public int getSize() {
        return this.stack.getSize();
    }

    protected AbstractSubject createAbstractSubject(Subject subject) {
        return new SubjectProxy(subject);
    }

    public static synchronized boolean ensureInitialized() {
        if (!SubjectManagerImpl.subjectManagerInstalled()) {
            SubjectManagerImpl.setSubjectManager(new SubjectManagerImpl());
            return false;
        }
        return true;
    }

    public AbstractSubject getAnonymousSubject() {
        return SubjectProxy.ANON;
    }

    public static final boolean isSubjectManagerInstalled() {
        return SubjectManagerImpl.subjectManagerInstalled();
    }
}

