/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import weblogic.corba.client.utils.ContextInputImpl;
import weblogic.corba.client.utils.ContextOutputImpl;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;

public final class ContextInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = false;
    public static final int VENDOR_RUNTIME_CONTEXT = 1111834891;
    private final Codec codec;
    private final ORB orb;
    private final DynAnyFactory factory;

    public ContextInterceptor(Codec codec, DynAnyFactory factory) throws Exception {
        this.codec = codec;
        this.factory = factory;
        this.orb = ORB.init();
    }

    public String name() {
        return "ContextInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        ServiceContext ctx = this.encodeContexts();
        if (ctx != null) {
            ri.add_request_service_context(ctx, true);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        this.decodeContexts(ri);
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) {
    }

    private final ServiceContext encodeContexts() {
        try {
            WorkContextMapInterceptor interceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
            if (interceptor != null) {
                ContextOutputImpl co = new ContextOutputImpl(this.orb, this.factory);
                interceptor.sendRequest(co, 4);
                return new ServiceContext(1111834891, this.codec.encode_value(co.get_any()));
            }
        }
        catch (InvalidTypeForEncoding itfee) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void decodeContexts(ClientRequestInfo ri) {
        WorkContextMapInterceptor interceptor = WorkContextHelper.getWorkContextHelper().getInterceptor();
        try {
            ServiceContext ctx = ri.get_reply_service_context(1111834891);
            OutputStream out = this.orb.create_output_stream();
            out.write_octet_array(ctx.context_data, 0, ctx.context_data.length);
            InputStream in = out.create_input_stream();
            in.read_boolean();
            interceptor.receiveResponse(new ContextInputImpl(in));
        }
        catch (BAD_PARAM bpe) {
            if (bpe.minor != 1330446362) {
                throw bpe;
            }
            try {
                interceptor.receiveResponse(null);
            }
            catch (IOException ioe) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void p(String s) {
        System.err.println("<ContextInterceptor> " + s);
    }
}

