/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client14.iiop;

import com.sun.corba.se.connection.EndPointInfo;
import com.sun.corba.se.connection.GetEndPointInfoAgainException;
import com.sun.corba.se.internal.core.IOR;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.omg.CORBA.ORB;
import weblogic.corba.client.cluster.DummySocket;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.corba.client14.security.SSLORBSocketFactory;

public class BiDirSSLORBSocketFactory
extends SSLORBSocketFactory {
    private BiDirSocketFactory factory = new BiDirSocketFactory();
    private static final String ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME = "weblogic.thinclient.enableClusterFailOver";
    private static final boolean ENABLE_CLUSTER_FAILOVER = BiDirSSLORBSocketFactory.initializeEnableClusterFailOverProperty();

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        if (DEBUG) {
            BiDirSSLORBSocketFactory.p("createServerSocket(" + type + ", " + port + ")");
        }
        return this.factory.createServerSocket(port);
    }

    public EndPointInfo getEndPointInfo(ORB orb, IOR ior, EndPointInfo endPointInfo) {
        this.factory.initializeInterceptor(orb);
        return super.getEndPointInfo(orb, ior, endPointInfo);
    }

    public Socket createSocket(EndPointInfo endPointInfo) throws IOException, GetEndPointInfoAgainException {
        if (DEBUG) {
            BiDirSSLORBSocketFactory.p("createSocket(" + endPointInfo.getHost() + ":" + endPointInfo.getPort() + ", " + endPointInfo.getType() + ")");
        }
        try {
            return this.factory.createSocket(endPointInfo.getHost(), endPointInfo.getPort(), super.createSocket(endPointInfo));
        }
        catch (SocketException se) {
            if (!ENABLE_CLUSTER_FAILOVER) {
                throw se;
            }
            if (se instanceof ConnectException || se instanceof NoRouteToHostException) {
                if (DEBUG) {
                    BiDirSSLORBSocketFactory.p("created DummySocket()");
                }
                return new DummySocket();
            }
            throw se;
        }
    }

    protected static void p(String s) {
        System.err.println("<BiDirSSLORBSocketFactory> " + s);
    }

    private static boolean initializeEnableClusterFailOverProperty() {
        boolean enabled = true;
        try {
            enabled = System.getProperty(ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME, "true").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return enabled;
    }
}

