/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.cluster;

import java.util.HashMap;
import weblogic.corba.iiop.cluster.PrimarySecondarySelector;
import weblogic.corba.iiop.cluster.RandomSelector;
import weblogic.corba.iiop.cluster.RoundRobinSelector;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.iiop.cluster.ServerAffinitySelector;
import weblogic.corba.iiop.cluster.StickySelector;

public class SelectorFactory {
    public static final Selector getSelector(String name) {
        Selector selector = (Selector)SelectorMaker.SELECTOR_MAP.get(name);
        if (selector != null) {
            return selector;
        }
        return StickySelector.SELECTOR;
    }

    private static final HashMap getSelectorMap() {
        HashMap<String, Selector> smap = new HashMap<String, Selector>();
        smap.put("random", RandomSelector.SELECTOR);
        smap.put("round-robin", RoundRobinSelector.SELECTOR);
        smap.put("round-robin-affinity", ServerAffinitySelector.SELECTOR);
        smap.put("random-affinity", ServerAffinitySelector.SELECTOR);
        smap.put("server-affinity", ServerAffinitySelector.SELECTOR);
        smap.put("weight-based-affinity", ServerAffinitySelector.SELECTOR);
        smap.put("primary-secondary", PrimarySecondarySelector.SELECTOR);
        return smap;
    }

    static /* synthetic */ HashMap access$000() {
        return SelectorFactory.getSelectorMap();
    }

    private static final class SelectorMaker {
        private static final HashMap SELECTOR_MAP = SelectorFactory.access$000();

        private SelectorMaker() {
        }
    }
}

