/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.corba.iiop.cluster.RandomSelector;
import weblogic.corba.iiop.cluster.RoundRobinSelector;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.j2ee.naming.EndPointInfo;

public final class NameParser
implements javax.naming.NameParser {
    public static final String IIOP_PROTOCOL = "iiop";
    public static final String TGIOP_PROTOCOL = "tgiop";
    public static final String COMPLEX_PROTOCOL = "complex";
    public static final String IIOPS_PROTOCOL = "iiops";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String TGIOP_PREFIX = "tgiop:";
    public static final String IIOP_PREFIX = "iiop:";
    public static final String T3_PREFIX = "t3:";
    public static final String T3S_PREFIX = "t3s:";
    public static final String IOR_PREFIX = "IOR:";
    public static final String IIOPS_PREFIX = "iiops:";
    public static final String IIOPLOC_PREFIX = "iioploc:";
    public static final String HTTP_PREFIX = "http:";
    public static final String HTTPS_PREFIX = "https:";
    public static final String CORBALOC_PREFIX = "corbaloc:";
    public static final String IIOPNAME_PREFIX = "iiopname:";
    public static final String CORBANAME_PREFIX = "corbaname:";
    public static final String NAME_SERVICE = "NameService";
    public static final boolean DEBUG = false;
    private static HashMap protocolMap = new HashMap();
    private static HashMap clientProtocolMap;
    public static final String CORBALOC_RIR_PREFIX = "corbaloc:rir:";
    public static final String CORBALOC_TGIOP_PREFIX = "corbaloc:tgiop:";
    public static final String CORBALOC_IIOP_PREFIX = "corbaloc:iiop:";
    public static final String CORBALOC_HTTP_PREFIX = "corbaloc:http:";
    public static final String CORBALOC_HTTPS_PREFIX = "corbaloc:https:";
    public static final String CORBALOC_IIOP_PREFIX2 = "corbaloc::";
    public static final String CORBALOC_IIOPS_PREFIX = "corbaloc:iiops:";
    public static final String CORBANAME_RIR_PREFIX = "corbaname:rir:";
    public static final String CORBANAME_TGIOP_PREFIX = "corbaname:tgiop:";
    public static final String CORBANAME_IIOP_PREFIX = "corbaname:iiop:";
    public static final String CORBANAME_IIOP_PREFIX2 = "corbaname::";
    public static final String CORBANAME_IIOPS_PREFIX = "corbaname:iiops:";
    private static HashMap complexProtocolMap;
    private static int defaultMinorVersion;
    private static final Properties defaultProps;

    public static void initialize(int minorversion) {
        defaultMinorVersion = minorversion;
    }

    public static boolean isGIOPProtocol(String url) {
        return NameParser.getProtocol(url) != null;
    }

    public Name parse(String name) throws NamingException {
        return NameParser.parseName(name);
    }

    public static Name parseName(String name) throws NamingException {
        return new CompoundName(name, defaultProps);
    }

    public static String getProtocol(String url) {
        if (url == null) {
            return null;
        }
        int delim = url.indexOf(58);
        if (delim < 0) {
            return null;
        }
        String protocolprefix = url.substring(0, delim + 1);
        String protocol = (String)protocolMap.get(protocolprefix);
        if (protocol == COMPLEX_PROTOCOL) {
            if ((delim = url.indexOf(58, delim + 1)) < 0) {
                return null;
            }
            protocolprefix = url.substring(0, delim + 1);
            protocol = (String)complexProtocolMap.get(protocolprefix);
        }
        return protocol;
    }

    public static String getProtocolString(String url) throws InvalidNameException {
        if (NameParser.getProtocol(url) == null) {
            return null;
        }
        try {
            int delim = url.indexOf(35);
            if (delim >= 0) {
                return url.substring(0, delim);
            }
            delim = url.indexOf(47);
            if (delim < 0) {
                return url;
            }
            int delim2 = url.indexOf(47, delim + 1);
            if (delim2 < 0) {
                return url;
            }
            if (url.substring(delim + 1, delim2).equals(NAME_SERVICE)) {
                return url.substring(0, delim2 + 1);
            }
            delim = url.indexOf(47, delim2 + 1);
            if (delim < 0) {
                return url;
            }
            return url.substring(0, delim + 1);
        }
        catch (Exception e) {
            InvalidNameException ne = new InvalidNameException("Invalid scheme");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public static String getNameString(String url) {
        if (NameParser.getProtocol(url) == null) {
            return url;
        }
        int delim = url.indexOf(35);
        if (delim >= 0) {
            return url.substring(delim + 1);
        }
        delim = url.indexOf(47);
        if (delim < 0) {
            return "";
        }
        int delim2 = url.indexOf(47, delim + 1);
        if (delim2 < 0) {
            return "";
        }
        if (url.substring(delim + 1, delim2).equals(NAME_SERVICE)) {
            return url.substring(delim2 + 1);
        }
        delim = url.indexOf(47, delim2 + 1);
        if (delim >= 0) {
            return url.substring(delim + 1);
        }
        return "";
    }

    public static URLInfo parseURL(String url) throws InvalidNameException {
        if (url == null) {
            throw new InvalidNameException("url is null");
        }
        int delim = url.indexOf(58);
        String protocolprefix = url.substring(0, delim + 1);
        String protocol = (String)clientProtocolMap.get(protocolprefix);
        if (protocol == COMPLEX_PROTOCOL) {
            return NameParser.parseComplexURL(url);
        }
        if (protocol == null) {
            return null;
        }
        URLInfo ret = new URLInfo(protocol);
        String name = url.substring(delim + 1);
        if (!name.startsWith("//")) {
            throw new InvalidNameException("url does not contain //");
        }
        name = name.substring(2);
        int comma = 0;
        ArrayList<EndPointInfo> urllist = null;
        while (comma >= 0) {
            comma = name.indexOf(44);
            if (comma < 0 && (comma = name.indexOf(124)) >= 0) {
                ret.selector = RandomSelector.SELECTOR;
            }
            String addr = name;
            if (comma >= 0) {
                addr = name.substring(0, comma);
                name = name.substring(comma + 1);
            }
            String host = addr;
            int port = -1;
            if (protocol != TGIOP_PROTOCOL) {
                delim = addr.lastIndexOf(58);
                if (delim < 0) {
                    delim = name.indexOf(58);
                    if (delim < 0) {
                        throw new InvalidNameException("url does not contain a port");
                    }
                    host = addr;
                    addr = name;
                } else {
                    host = addr.substring(0, delim);
                }
                int delim2 = addr.indexOf(47);
                if (delim2 < 0) {
                    delim2 = addr.length();
                }
                try {
                    port = Integer.parseInt(addr.substring(delim + 1, delim2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (addr.length() > delim2) {
                    ret.name = addr.substring(delim2);
                }
            }
            ret.addressList[0] = new EndPointInfo(host, port, 1, defaultMinorVersion);
            if (comma <= 0 && urllist == null) continue;
            if (urllist == null) {
                urllist = new ArrayList<EndPointInfo>();
            }
            urllist.add(ret.addressList[0]);
        }
        if (urllist != null) {
            ret.addressList = urllist.toArray(ret.addressList);
            ret.randomizeStart();
        } else {
            NameParser.normalizeClusterAddress(ret);
        }
        return ret;
    }

    private static void normalizeClusterAddress(URLInfo ret) throws InvalidNameException {
    }

    public static URLInfo parseComplexURL(String url) throws InvalidNameException {
        if (url == null) {
            throw new InvalidNameException("url is null");
        }
        int delim = url.indexOf(58);
        if (delim < 0) {
            throw new InvalidNameException("url does not contain :");
        }
        if ((delim = url.indexOf(58, delim + 1)) < 0) {
            throw new InvalidNameException("url does not contain ::");
        }
        String protocolprefix = url.substring(0, delim + 1);
        String protocol = (String)complexProtocolMap.get(protocolprefix);
        if (protocol == null) {
            throw new InvalidNameException("url does not contain a known protocol");
        }
        URLInfo ret = new URLInfo(protocol);
        String name = url.substring(delim + 1);
        if (url.startsWith(CORBANAME_PREFIX)) {
            delim = name.indexOf(35);
            if (delim >= 0) {
                ret.name = name.substring(delim + 1);
            } else {
                delim = name.length();
            }
        } else if (url.startsWith(CORBALOC_PREFIX)) {
            delim = name.indexOf(47);
            if (delim < 0) {
                throw new InvalidNameException("url does not contain a service name");
            }
            String compoundName = name.substring(delim + 1);
            int delim2 = compoundName.indexOf(47);
            if (delim2 >= 0) {
                ret.serviceName = compoundName.substring(0, delim2);
                ret.name = compoundName.substring(delim2 + 1);
            } else {
                ret.serviceName = compoundName;
            }
        }
        name = name.substring(0, delim);
        int comma = 0;
        ArrayList<EndPointInfo> urllist = null;
        while (comma >= 0) {
            int minorVersion = defaultMinorVersion;
            int majorVersion = 1;
            comma = name.indexOf(44);
            if (comma < 0 && (comma = name.indexOf(124)) >= 0) {
                ret.selector = RandomSelector.SELECTOR;
            }
            String addr = name;
            if (comma >= 0) {
                addr = name.substring(0, comma);
                try {
                    name = name.substring(comma + 1);
                    name = name.substring(name.indexOf(58) + 1);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    throw new InvalidNameException("url contains an Invalid multi-url specification");
                }
            }
            try {
                if (addr.indexOf(64) != -1) {
                    String ver = addr.substring(0, addr.indexOf(64));
                    addr = addr.substring(addr.indexOf(64) + 1);
                    majorVersion = Integer.parseInt(ver.substring(0, 1));
                    minorVersion = Integer.parseInt(ver.substring(2, 3));
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidNameException("url contains an invalid version specification");
            }
            String host = addr;
            int port = -1;
            if (protocol != TGIOP_PROTOCOL) {
                delim = addr.lastIndexOf(58);
                if (delim < 0) {
                    throw new InvalidNameException("url does not contain :");
                }
                host = addr.substring(0, delim);
                try {
                    port = Integer.parseInt(addr.substring(delim + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ret.addressList[0] = new EndPointInfo(host, port, majorVersion, minorVersion);
            if (comma <= 0 && urllist == null) continue;
            if (urllist == null) {
                urllist = new ArrayList<EndPointInfo>();
            }
            urllist.add(ret.addressList[0]);
        }
        if (urllist != null) {
            ret.addressList = urllist.toArray(ret.addressList);
            ret.randomizeStart();
        } else {
            NameParser.normalizeClusterAddress(ret);
        }
        return ret;
    }

    public static void main(String[] args) throws InvalidNameException {
        if (args.length == 1) {
            String url = args[0];
            System.out.println(NameParser.parseURL(url));
        } else {
            System.out.println("NameParser <url>");
        }
    }

    private static void p(String s) {
        System.out.println("<NameParser> " + s);
    }

    static {
        protocolMap.put(IIOPS_PREFIX, IIOPS_PROTOCOL);
        protocolMap.put(IIOP_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(IOR_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(TGIOP_PREFIX, TGIOP_PROTOCOL);
        protocolMap.put(IIOPLOC_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(IIOPNAME_PREFIX, IIOP_PROTOCOL);
        protocolMap.put(CORBALOC_PREFIX, COMPLEX_PROTOCOL);
        protocolMap.put(CORBANAME_PREFIX, COMPLEX_PROTOCOL);
        clientProtocolMap = new HashMap(protocolMap);
        clientProtocolMap.put(T3S_PREFIX, IIOPS_PROTOCOL);
        clientProtocolMap.put(T3_PREFIX, IIOP_PROTOCOL);
        clientProtocolMap.put(HTTP_PREFIX, HTTP_PROTOCOL);
        clientProtocolMap.put(HTTPS_PREFIX, HTTPS_PROTOCOL);
        complexProtocolMap = new HashMap();
        complexProtocolMap.put(CORBALOC_RIR_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_TGIOP_PREFIX, TGIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOP_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOP_PREFIX2, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_IIOPS_PREFIX, IIOPS_PROTOCOL);
        complexProtocolMap.put(CORBALOC_HTTP_PREFIX, HTTP_PROTOCOL);
        complexProtocolMap.put(CORBALOC_HTTPS_PREFIX, HTTPS_PROTOCOL);
        complexProtocolMap.put(CORBANAME_RIR_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_TGIOP_PREFIX, TGIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOP_PREFIX, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOP_PREFIX2, IIOP_PROTOCOL);
        complexProtocolMap.put(CORBANAME_IIOPS_PREFIX, IIOPS_PROTOCOL);
        defaultMinorVersion = 2;
        defaultProps = new Properties();
        defaultProps.put("jndi.syntax.direction", "left_to_right");
        defaultProps.put("jndi.syntax.separator", "/");
        defaultProps.put("jndi.syntax.separator2", ".");
        defaultProps.put("jndi.syntax.ignorecase", "false");
        defaultProps.put("jndi.syntax.escape", "\\");
        defaultProps.put("jndi.syntax.beginquote", "\"");
        defaultProps.put("jndi.syntax.endquote", "\"");
        defaultProps.put("jndi.syntax.beginquote2", "'");
        defaultProps.put("jndi.syntax.endquote2", "'");
        defaultProps.put("jndi.syntax.separator.ava", ",");
        defaultProps.put("jndi.syntax.separator.typeval", "=");
    }

    public static class URLInfo {
        private Selector selector = RoundRobinSelector.SELECTOR;
        private int current = 0;
        public EndPointInfo[] addressList;
        public String name = "";
        public String serviceName = "NameService";
        public String protocol = null;

        public URLInfo(String protocol) {
            this.protocol = protocol;
            this.addressList = new EndPointInfo[]{new EndPointInfo()};
        }

        public final String getHost() {
            return this.addressList[this.current].getHost();
        }

        public final int getPort() {
            return this.addressList[this.current].getPort();
        }

        public final int getMinorVersion() {
            return this.addressList[this.current].getMinorVersion();
        }

        public final int getMajorVersion() {
            return this.addressList[this.current].getMajorVersion();
        }

        public final EndPointInfo getAddress() {
            return this.addressList[this.current];
        }

        public final EndPointInfo getNextAddress() {
            EndPointInfo epi = this.addressList[this.current];
            this.current = this.selector.select(this.current, this.addressList.length);
            return epi;
        }

        public final String getService() {
            return this.serviceName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        void randomizeStart() {
            if (this.addressList == null || this.addressList.length <= 1) {
                this.current = 0;
            } else {
                double dHostIdx = Math.random() * (double)this.addressList.length + 0.5;
                this.current = (int)Math.round(dHostIdx) - 1;
            }
        }

        final String getKey() {
            return this.protocol + this.getAddress().getAddress();
        }

        final String getNextKey() {
            return this.protocol + this.getNextAddress().getAddress();
        }

        public String getURL() {
            return NameParser.CORBALOC_PREFIX + this.protocol + ":" + this.addressList[this.current].getAddress() + "/" + this.serviceName;
        }

        public String getClusterURL() {
            StringBuffer url = new StringBuffer(this.protocol + "://");
            for (int i = 0; i < this.addressList.length; ++i) {
                if (i != 0) {
                    url.append(",");
                }
                url.append(this.addressList[i].getAddress());
            }
            return url.toString();
        }

        public String getNeutralURL() {
            return NameParser.CORBALOC_IIOP_PREFIX2 + this.addressList[this.current].getAddress() + "/" + this.serviceName;
        }

        public boolean isSecure() {
            return this.protocol == NameParser.IIOPS_PROTOCOL;
        }

        public String toString() {
            return this.getURL() + (this.name.length() == 0 ? "" : "/" + this.name);
        }
    }
}

