/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.util.HashSet;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextConstants;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.InvalidDyeException;

public final class DiagnosticContextHelper
implements DiagnosticContextConstants {
    private static DyeInfo[] dyeInfos = new DyeInfo[]{new DyeInfo("ADDR1", 1L), new DyeInfo("ADDR2", 2L), new DyeInfo("ADDR3", 4L), new DyeInfo("ADDR4", 8L), new DyeInfo("USER1", 16L), new DyeInfo("USER2", 32L), new DyeInfo("USER3", 64L), new DyeInfo("USER4", 128L), new DyeInfo("COOKIE1", 256L), new DyeInfo("COOKIE2", 512L), new DyeInfo("COOKIE3", 1024L), new DyeInfo("COOKIE4", 2048L), new DyeInfo("EXECQ1", 4096L), new DyeInfo("EXECQ2", 8192L), new DyeInfo("EXECQ3", 16384L), new DyeInfo("EXECQ4", 32768L), new DyeInfo("THREADGROUP1", 65536L), new DyeInfo("THREADGROUP2", 131072L), new DyeInfo("THREADGROUP3", 262144L), new DyeInfo("THREADGROUP4", 524288L), new DyeInfo("PROTOCOL_T3", 0x100000L), new DyeInfo("PROTOCOL_HTTP", 0x200000L), new DyeInfo("PROTOCOL_RMI", 0x400000L), new DyeInfo("PROTOCOL_SOAP", 0x800000L), new DyeInfo("PROTOCOL_IIOP", 0x1000000L), new DyeInfo("PROTOCOL_JRMP", 0x2000000L), new DyeInfo("PROTOCOL_SSL", 0x4000000L), new DyeInfo("CONNECTOR1", 0x8000000L), new DyeInfo("CONNECTOR2", 0x10000000L), new DyeInfo("CONNECTOR3", 0x20000000L), new DyeInfo("CONNECTOR4", 0x40000000L), new DyeInfo("THROTTLE", 0x100000000L), new DyeInfo("JFR_THROTTLE", 0x200000000L), new DyeInfo("DYE_0", 0x100000000000000L), new DyeInfo("DYE_1", 0x200000000000000L), new DyeInfo("DYE_2", 0x400000000000000L), new DyeInfo("DYE_3", 0x800000000000000L), new DyeInfo("DYE_4", 0x1000000000000000L), new DyeInfo("DYE_5", 0x2000000000000000L), new DyeInfo("DYE_6", 0x4000000000000000L), new DyeInfo("DYE_7", Long.MIN_VALUE)};

    public static String getContextId() {
        DiagnosticContext ctx = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return ctx != null ? ctx.getContextId() : null;
    }

    public static void setDye(byte dye, boolean enable) throws InvalidDyeException {
        if (dye < 56 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        DiagnosticContext ctx = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (ctx != null) {
            ctx.setDye(dye, enable);
        }
    }

    public static boolean isDyedWith(byte dye) throws InvalidDyeException {
        DiagnosticContext ctx = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return ctx != null ? ctx.isDyedWith(dye) : false;
    }

    public static String getPayload() {
        DiagnosticContext ctx = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return ctx != null ? ctx.getPayload() : null;
    }

    public static void setPayload(String payload) {
        DiagnosticContext ctx = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (ctx != null) {
            ctx.setPayload(payload);
        }
    }

    public static long parseDyeMask(String mask) {
        if (mask == null) {
            return 0L;
        }
        String[] maskNames = mask.split(",");
        return DiagnosticContextHelper.parseDyeMask(maskNames);
    }

    public static long parseDyeMask(String[] maskNames) {
        long maskValue = 0L;
        int size = maskNames != null ? maskNames.length : 0;
        for (int i = 0; i < size; ++i) {
            String mName = maskNames[i].trim();
            maskValue |= DiagnosticContextHelper.getDyeValue(mName);
        }
        return maskValue;
    }

    public static String[] getDyeFlagNames() {
        String[] dyeNames = new String[dyeInfos.length];
        for (int i = 0; i < dyeInfos.length; ++i) {
            dyeNames[i] = DiagnosticContextHelper.dyeInfos[i].dyeName;
        }
        return dyeNames;
    }

    public static void validateDyeFlagNames(String[] maskNames) {
        if (maskNames == null || maskNames.length == 0) {
            return;
        }
        HashSet<String> dyeNames = new HashSet<String>();
        for (int i = 0; i < dyeInfos.length; ++i) {
            dyeNames.add(DiagnosticContextHelper.dyeInfos[i].dyeName);
        }
        for (int j = 0; j < maskNames.length; ++j) {
            if (dyeNames.contains(maskNames[j])) continue;
            throw new IllegalArgumentException("Dye name is invalid " + maskNames[j]);
        }
    }

    private static long getDyeValue(String dyeName) {
        for (int i = 0; i < dyeInfos.length; ++i) {
            if (!dyeName.equals(DiagnosticContextHelper.dyeInfos[i].dyeName)) continue;
            return DiagnosticContextHelper.dyeInfos[i].dyeValue;
        }
        return 0L;
    }

    public static synchronized void registerDye(String dyeName, int index) throws InvalidDyeException {
        if (index < 0 || index > 63) {
            throw new InvalidDyeException("Invalid dye index " + index);
        }
        long dyeValue = 1L << index;
        int size = dyeInfos.length;
        for (int i = 0; i < size; ++i) {
            DyeInfo dyeInfo = dyeInfos[i];
            if (dyeName.equals(dyeInfo.dyeName)) {
                throw new InvalidDyeException("Dye " + dyeName + " is already defined");
            }
            if (dyeInfo.dyeValue != dyeValue) continue;
            throw new InvalidDyeException("Dye " + dyeInfo.dyeName + " is already defined as dye " + index);
        }
        DyeInfo[] tmp = new DyeInfo[size + 1];
        System.arraycopy(dyeInfos, 0, tmp, 0, size);
        tmp[size] = new DyeInfo(dyeName, dyeValue);
        dyeInfos = tmp;
    }

    private static class DyeInfo {
        String dyeName;
        long dyeValue;

        DyeInfo(String dyeName, long dyeValue) {
            this.dyeName = dyeName;
            this.dyeValue = dyeValue;
        }
    }
}

