/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.diagnostics.debug.DebugContext;
import weblogic.diagnostics.debug.DebugLoggerRepository;

public final class DebugLogger {
    private static ThreadLocal recursionState = new ThreadLocal(){

        public Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final boolean DISABLED_FLAG = DebugLogger.isDebugDisabled();
    static final int CTX_MODE_OFF = 0;
    static final int CTX_MODE_AND = 1;
    static final int CTX_MODE_OR = 2;
    private static DebugLoggerRepository defaultRepository = new DebugLoggerRepository();
    private static DebugContext debugContext = null;
    private static int contextMode = 0;
    private static long debugMask = 0L;
    private String debugLoggerName = null;
    private String displayName = null;
    private boolean debugEnabled = false;
    private DebugLoggerRepository debugLoggerRepository;

    public static DebugLoggerRepository getDefaultDebugLoggerRepository() {
        return defaultRepository;
    }

    private static boolean isDebugDisabled() {
        try {
            return Boolean.getBoolean("weblogic.diagnostics.debug.DebugLogger.DISABLED");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static DebugLogger getDebugLogger(String string) {
        return defaultRepository.getDebugLogger(string);
    }

    public static DebugLogger createUnregisteredDebugLogger(String string, boolean bl) {
        DebugLogger debugLogger = new DebugLogger(string, DebugLogger.getDefaultDebugLoggerRepository());
        debugLogger.setDebugEnabled(bl);
        return debugLogger;
    }

    static void setContextMode(int n) {
        contextMode = n;
    }

    static void setDebugContext(DebugContext debugContext) {
        DebugLogger.debugContext = debugContext;
    }

    static void setDebugMask(long l) {
        debugMask = l;
    }

    DebugLogger(String string, DebugLoggerRepository debugLoggerRepository) {
        this.debugLoggerName = string;
        this.displayName = this.debugLoggerName.replaceFirst("Debug", "");
        this.debugLoggerRepository = debugLoggerRepository;
    }

    public String getDebugLoggerName() {
        return this.debugLoggerName;
    }

    public final boolean isDebugEnabled() {
        if (!DISABLED_FLAG) {
            return this.isDebugEnabledInternal();
        }
        return false;
    }

    private final boolean isDebugEnabledInternal() {
        switch (contextMode) {
            case 1: {
                return this.debugEnabled && (debugMask & this.getDyeVector()) == debugMask;
            }
            case 2: {
                return this.debugEnabled && (debugMask & this.getDyeVector()) != 0L;
            }
        }
        return this.debugEnabled;
    }

    final void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
    }

    public void debug(String string) {
        this.log(Level.FINE, string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.log(Level.FINE, string, throwable);
    }

    private void log(Level level, String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            LogRecord logRecord = new LogRecord(level, string);
            logRecord.setLoggerName(this.displayName);
            logRecord.setThrown(throwable);
            logRecord.setSourceClassName(DebugLogger.class.getName());
            logRecord.setSourceMethodName("debug");
            this.debugLoggerRepository.getLogger().log(logRecord);
        }
    }

    private long getDyeVector() {
        long l = 0L;
        Boolean bl = (Boolean)recursionState.get();
        if (bl == Boolean.FALSE) {
            recursionState.set(Boolean.TRUE);
            l = debugContext.getDyeVector();
            recursionState.set(Boolean.FALSE);
        }
        return l;
    }
}

