/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.CatalogMessage;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.i18ntools.L10nLookup;
import weblogic.utils.StackTraceUtilsClient;

public class Loggable {
    private static final String MISSING_MSG = "Unable to access undefined message, id = ";
    private static final String UNKNOWN_SUBSYSTEM = "Unknown";
    private static final String FORMAT_PREFIX = "[{0}:{1}]";
    private final String id;
    private final Object[] args;
    private final Throwable thrown;
    private final String location;
    private final MessageLogger messageLogger;
    private final ClassLoader classLoader;

    private static Throwable getThrowable(Object[] objectArray) {
        Object object;
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length - 1;
        if (n >= 0 && (object = objectArray[n]) instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public Loggable(String string, Object[] objectArray, String string2, MessageLogger messageLogger, ClassLoader classLoader) {
        this.id = string;
        this.args = objectArray;
        this.classLoader = classLoader;
        this.thrown = Loggable.getThrowable(this.args);
        this.location = string2;
        this.messageLogger = messageLogger;
    }

    public Loggable(String string, Object[] objectArray, String string2) {
        this(string, objectArray, string2, MessageLoggerRegistry.getRootLogger(), Loggable.class.getClassLoader());
    }

    private static String calculateClassName(String string) {
        String string2 = L10nLookup.getL10n().getProperty(string);
        if (string2 != null) {
            return string2.substring(string2.indexOf(":") + 1);
        }
        return null;
    }

    public Loggable(String string, Object[] objectArray) {
        this(string, objectArray, Loggable.calculateClassName(string));
    }

    public String log() {
        if (this.location != null) {
            this.messageLogger.log(new CatalogMessage(this.id, this.args, this.location, this.classLoader));
        } else {
            this.messageLogger.log(UNKNOWN_SUBSYSTEM, 8, MISSING_MSG + this.id);
        }
        return this.id;
    }

    public String getMessageBody() {
        return this.getMessage(Locale.getDefault(), true, false);
    }

    private String getMessage(Locale locale, boolean bl, boolean bl2) {
        if (this.location == null) {
            return MISSING_MSG + this.id;
        }
        Localizer localizer = null;
        try {
            localizer = L10nLookup.getLocalizer(locale, this.location, this.classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            localizer = L10nLookup.getL10n().getLocalizer(this.id, locale);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            Object[] objectArray = new Object[]{localizer.getSubSystem(), this.id};
            stringBuffer.append(MessageFormat.format(FORMAT_PREFIX, objectArray));
        }
        stringBuffer.append(MessageFormat.format(localizer.getBody(this.id), this.args));
        if (bl2 && this.thrown != null && localizer.getStackTrace(this.id)) {
            stringBuffer.append("\n");
            stringBuffer.append(StackTraceUtilsClient.throwable2StackTrace(this.thrown));
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault(), true, true);
    }

    public String getMessage(Locale locale) {
        return this.getMessage(locale, true, true);
    }

    public String getMessageText() {
        return this.getMessage(Locale.getDefault(), false, true);
    }

    public String getMessageText(Locale locale) {
        return this.getMessage(locale, false, true);
    }

    public String getId() {
        return this.id;
    }
}

