/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageResetScheduler {
    private Map<String, MessageResetEntry> messageTimestamps = new ConcurrentHashMap<String, MessageResetEntry>();

    public static MessageResetScheduler getInstance() {
        return SINGLETON.instance;
    }

    private MessageResetScheduler() {
    }

    public boolean isMessageLoggingDisabled(String string) {
        long l;
        long l2 = System.currentTimeMillis();
        MessageResetEntry messageResetEntry = this.messageTimestamps.get(string);
        long l3 = messageResetEntry == null ? 0L : messageResetEntry.timestamp;
        long l4 = l2 - l3;
        long l5 = l = messageResetEntry == null ? 0L : messageResetEntry.delay;
        return l4 < l;
    }

    public boolean resetLogMessage(String string) {
        return this.messageTimestamps.remove(string) != null;
    }

    public void scheduleMessageReset(String string, long l) {
        this.messageTimestamps.put(string, new MessageResetEntry(l, System.currentTimeMillis()));
    }

    private static final class MessageResetEntry {
        long delay;
        long timestamp;

        MessageResetEntry(long l, long l2) {
            this.delay = l;
            this.timestamp = l2;
        }
    }

    private static class SINGLETON {
        static MessageResetScheduler instance = new MessageResetScheduler();

        private SINGLETON() {
        }
    }
}

