/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import weblogic.kernel.AuditableThread;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.KernelLogger;
import weblogic.kernel.KernelStatus;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.kernel.ThreadStorage;

final class FinalThreadLocal
implements AuditableThreadLocal {
    private static volatile boolean finalized = false;
    private final int index = FinalThreadStorage.newSlot(this);
    private final ThreadLocalInitialValue initial;
    private static final String CONTINUAL_LOG_PROP = "weblogic.kernel.debug.JavaThreadAccess";
    private static final boolean keepLogging = FinalThreadLocal.getContinueLoggingProperty();
    private static boolean loggedWarning = true;
    private static final InheritableThreadLocal threadLocals = new InheritableThreadLocal(){

        protected Object initialValue() {
            return new FinalThreadStorage();
        }

        protected Object childValue(Object object) {
            Thread thread = Thread.currentThread();
            if (thread instanceof AuditableThread) {
                return new FinalThreadStorage(((AuditableThread)thread).finalThreadStorage);
            }
            if (!loggedWarning) {
                KernelLogger.logWarnSwitchToWorkManagerAPI();
                loggedWarning = true;
            } else if (keepLogging) {
                KernelLogger.logDebugSwitchToWorkManagerAPI(thread.toString());
            }
            if (object != null) {
                return new FinalThreadStorage((FinalThreadStorage)object);
            }
            return null;
        }
    };

    private static boolean getContinueLoggingProperty() {
        return !KernelStatus.isApplet() && "true".equals(System.getProperty(CONTINUAL_LOG_PROP));
    }

    FinalThreadLocal() {
        this.initial = new ThreadLocalInitialValue();
    }

    FinalThreadLocal(ThreadLocalInitialValue threadLocalInitialValue) {
        this.initial = threadLocalInitialValue;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AuditableThread) {
            return ((AuditableThread)thread).finalThreadStorage.get(this.index);
        }
        return this.get((ThreadStorage)threadLocals.get());
    }

    public Object get(AuditableThread auditableThread) {
        if (auditableThread == null) {
            return null;
        }
        return auditableThread.finalThreadStorage.get(this.index);
    }

    private Object get(ThreadStorage threadStorage) {
        if (threadStorage == null) {
            return null;
        }
        return threadStorage.get(this.index);
    }

    public void set(Object object) {
        Thread thread = Thread.currentThread();
        if (thread instanceof AuditableThread) {
            ((AuditableThread)thread).finalThreadStorage.set(this.index, object);
        } else {
            this.set((ThreadStorage)threadLocals.get(), object);
        }
    }

    private void set(ThreadStorage threadStorage, Object object) {
        if (threadStorage == null) {
            return;
        }
        threadStorage.set(this.index, object);
    }

    static boolean isFinalized() {
        return finalized;
    }

    static final void resetJavaThreadStorage() {
        threadLocals.set(null);
    }

    static final class FinalThreadStorage
    implements ThreadStorage {
        private static FinalThreadLocal[] varList = new FinalThreadLocal[0];
        private final Object[] storage;
        private final int NUM_SLOTS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int newSlot(FinalThreadLocal finalThreadLocal) {
            if (finalized) {
                throw new AssertionError((Object)"A FinalThreadLocal was allocated after thread creation.");
            }
            Class<FinalThreadStorage> clazz = FinalThreadStorage.class;
            synchronized (FinalThreadStorage.class) {
                int n = varList.length;
                FinalThreadLocal[] finalThreadLocalArray = new FinalThreadLocal[n + 1];
                System.arraycopy(varList, 0, finalThreadLocalArray, 0, n);
                finalThreadLocalArray[n] = finalThreadLocal;
                varList = finalThreadLocalArray;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return n;
            }
        }

        public FinalThreadStorage() {
            finalized = true;
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = varList[i].initial.initialValue();
            }
        }

        protected FinalThreadStorage(FinalThreadStorage finalThreadStorage) {
            this.NUM_SLOTS = varList.length;
            this.storage = new Object[this.NUM_SLOTS];
            for (int i = 0; i < this.NUM_SLOTS; ++i) {
                this.storage[i] = finalThreadStorage != null ? varList[i].initial.childValue(finalThreadStorage.storage[i]) : varList[i].initial.initialValue();
            }
        }

        public void set(int n, Object object) {
            this.storage[n] = object;
        }

        public Object get(int n) {
            return this.storage[n];
        }

        public final void reset() {
            Object[] objectArray = this.storage;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                objectArray[i] = varList[i].initial.resetValue(object);
            }
        }
    }
}

