/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import weblogic.workarea.PrimitiveWorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public class SerializableWorkContext
implements PrimitiveWorkContext,
Serializable {
    private static final long serialVersionUID = 3485637846065994552L;
    private byte[] data;
    private transient Serializable object;
    private transient boolean mutable = false;

    public SerializableWorkContext() {
    }

    SerializableWorkContext(Serializable serializable) throws IOException {
        this(serializable, false);
    }

    SerializableWorkContext(Serializable serializable, boolean bl) throws IOException {
        this.object = serializable;
        this.mutable = bl;
        if (!bl) {
            this.data = this.serialize(this.object);
        }
    }

    public String toString() {
        return "Serializable";
    }

    public Object get() {
        try {
            return this.getSerializable();
        }
        catch (IOException iOException) {
            return this.data;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.data;
        }
    }

    public Serializable getSerializable() throws IOException, ClassNotFoundException {
        if (this.object != null) {
            return this.object;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(objectStreamClass.getName(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.resolveClass(objectStreamClass);
                }
            }

            @Override
            protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader classLoader2 = null;
                boolean bl = false;
                Class[] classArray = new Class[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
                    if ((clazz.getModifiers() & 1) == 0) {
                        if (bl) {
                            if (classLoader2 != clazz.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            classLoader2 = clazz.getClassLoader();
                            bl = true;
                        }
                    }
                    classArray[i] = clazz;
                }
                try {
                    return Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ClassNotFoundException(null, illegalArgumentException);
                }
            }
        };
        Serializable serializable = (Serializable)objectInputStream.readObject();
        objectInputStream.close();
        if (serializable instanceof Carrier) {
            this.object = ((Carrier)serializable).getSerializable();
            this.mutable = ((Carrier)serializable).isMutable();
        } else {
            this.object = serializable;
        }
        return this.object;
    }

    public boolean equals(Object object) {
        if (object instanceof SerializableWorkContext) {
            if (!this.mutable && !((SerializableWorkContext)object).mutable) {
                return Arrays.equals(((SerializableWorkContext)object).data, this.data);
            }
            return this.get().equals(((SerializableWorkContext)object).get());
        }
        return false;
    }

    public void writeContext(WorkContextOutput workContextOutput) throws IOException {
        if (this.mutable) {
            Carrier carrier = new Carrier(this.object);
            carrier.setMutable();
            this.data = this.serialize(carrier);
        }
        workContextOutput.writeInt(this.data.length);
        workContextOutput.write(this.data);
    }

    public void readContext(WorkContextInput workContextInput) throws IOException {
        this.data = new byte[workContextInput.readInt()];
        workContextInput.readFully(this.data);
    }

    private byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static class Carrier
    implements Serializable {
        private static final int VERSION = 1;
        private static final long serialVersionUID = -197593099539117489L;
        private Serializable serializable;
        private boolean mutable;

        public Carrier() {
        }

        Carrier(Serializable serializable) {
            this.serializable = serializable;
        }

        Serializable getSerializable() {
            return this.serializable;
        }

        void setMutable() {
            this.mutable = true;
        }

        boolean isMutable() {
            return this.mutable;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(this.serializable);
            objectOutputStream.writeBoolean(this.mutable);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            int n = objectInputStream.readInt();
            this.serializable = (Serializable)objectInputStream.readObject();
            this.mutable = objectInputStream.readBoolean();
        }
    }
}

