




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.authentication;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.management.commo.StandardInterface;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.utils.InvalidParameterException;
import weblogic.management.utils.NotFoundException;
import javax.management.openmbean.OpenType;


/**
 * Corresponds to UserAttributeReaderMBean
 * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * Provides a set of methods for getting a list of supported users attributes
 and their types. Methods are also provided to get user attribute values.
 An Authentication provider MBean can optionally implement this MBean. The 
 WebLogic Server Administration Console detects when an Authentication provider 
 implements this MBean and automatically provides a tab for using these methods.
 *
 * @xsdgen:complexType.typeName user-attribute-readerType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class UserAttributeReaderMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements UserAttributeReaderMBean, java.io.Serializable
{
  private String[] _SupportedUserAttributeNames;


  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=UserAttributeReaderMBeanImpl)
   *
   */
  public UserAttributeReaderMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=UserAttributeReaderMBeanImpl)
   *
   */
  public UserAttributeReaderMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=UserAttributeReaderMBeanImpl)
   *
   */
  public UserAttributeReaderMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * Provides a list of supported user attribute names for the provider.
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=getSupportedUserAttributeNames)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getSupportedUserAttributeNames() {
    return _SupportedUserAttributeNames;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=isSupportedUserAttributeNamesInherited)
   *
   * return true if the value of property SupportedUserAttributeNames is inherited from template
   */
  public boolean isSupportedUserAttributeNamesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=isSupportedUserAttributeNamesSet)
   *
   * @xsdgen:isSetMethodFor supported-user-attribute-name
   */
  public boolean isSupportedUserAttributeNamesSet() {
    return _isSet(2);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=setSupportedUserAttributeNames)
   *
   */
  public void setSupportedUserAttributeNames(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _SupportedUserAttributeNames = param0;
  }

  /**
   * Checks if a user attribute is supported.
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=isUserAttributeNameSupported)
   *
   */
  public boolean isUserAttributeNameSupported(String param0)
    throws InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Returns the user attribute type
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=getSupportedUserAttributeType)
   *
   */
  public javax.management.openmbean.OpenType getSupportedUserAttributeType(String param0)
    throws InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * Gets a user attribute value for a user.

 If the user attribute is unset,a null would be returned.
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=getUserAttributeValue)
   *
   */
  public Object getUserAttributeValue(String param0, String param1)
    throws NotFoundException, InvalidParameterException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserAttributeReaderMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 2;
    }
    try {
      switch (idx) {
      case 2:
        _SupportedUserAttributeNames = new String[]{};
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private UserAttributeReaderMBeanImpl bean;

    protected Helper(UserAttributeReaderMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 2: return "SupportedUserAttributeNames";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("SupportedUserAttributeNames")) return 2;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isSupportedUserAttributeNamesSet()){
          buf.append("SupportedUserAttributeNames");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getSupportedUserAttributeNames())));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      UserAttributeReaderMBeanImpl otherTyped = (UserAttributeReaderMBeanImpl)other;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        UserAttributeReaderMBeanImpl original = (UserAttributeReaderMBeanImpl)event.getSourceBean();
        UserAttributeReaderMBeanImpl proposed = (UserAttributeReaderMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("SupportedUserAttributeNames")) {
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        UserAttributeReaderMBeanImpl copy = (UserAttributeReaderMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
        }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 29:
        if (false) return -1;
        else if (s.equals("supported-user-attribute-name"))
          return 2;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 2: return "supported-user-attribute-name";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      case 2:
        return true;
      default:
        return super.isArray(propIndex);
      }
    }














  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.authentication.UserAttributeReaderMBean"; 
  }

}
