




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security.authentication;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.security.RealmMBean;
import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to UserLockoutManagerMBean
 * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * Lists and manages lockouts on user accounts.
 *
 * @xsdgen:complexType.typeName user-lockout-managerType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class UserLockoutManagerMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements UserLockoutManagerMBean, java.io.Serializable
{
  private String _CompatibilityObjectName;
  private long _InvalidLoginAttemptsTotalCount;
  private long _InvalidLoginUsersHighCount;
  private long _LockedUsersCurrentCount;
  private long _LockoutCacheSize;
  private long _LockoutDuration;
  private boolean _LockoutEnabled;
  private long _LockoutGCThreshold;
  private long _LockoutResetDuration;
  private long _LockoutThreshold;
  private long _LoginAttemptsWhileLockedTotalCount;
  private String _Name;
  private weblogic.management.security.RealmMBean _Realm;
  private long _UnlockedUsersTotalCount;
  private long _UserLockoutTotalCount;
  private transient UserLockoutManagerImpl _customizer;


  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=UserLockoutManagerMBeanImpl)
   *
   */
  public UserLockoutManagerMBeanImpl() {
    super();
    try {
      _customizer = new weblogic.management.security.authentication.UserLockoutManagerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=UserLockoutManagerMBeanImpl)
   *
   */
  public UserLockoutManagerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    try {
      _customizer = new weblogic.management.security.authentication.UserLockoutManagerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=UserLockoutManagerMBeanImpl)
   *
   */
  public UserLockoutManagerMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    try {
      _customizer = new weblogic.management.security.authentication.UserLockoutManagerImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * Returns the number of user lockouts that have occured since
 this server has been started.

 In a cluster, this method returns the number of user lockouts
 that have occured since the cluster has been started because
 all servers share login failure information.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getUserLockoutTotalCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getUserLockoutTotalCount() {
    try {
    return _customizer.getUserLockoutTotalCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isUserLockoutTotalCountInherited)
   *
   * return true if the value of property UserLockoutTotalCount is inherited from template
   */
  public boolean isUserLockoutTotalCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isUserLockoutTotalCountSet)
   *
   * @xsdgen:isSetMethodFor user-lockout-total-count
   */
  public boolean isUserLockoutTotalCountSet() {
    return _isSet(2);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setUserLockoutTotalCount)
   *
   */
  public void setUserLockoutTotalCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _UserLockoutTotalCount = param0;
  }

  /**
   * Returns the number of invalid logins attempted since this server
 has been started and lockouts have been enabled.

 In a cluster, this method returns the number of invalid logins
 attempted that have occured since the cluster has been started
 because all servers share login failure information.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getInvalidLoginAttemptsTotalCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getInvalidLoginAttemptsTotalCount() {
    try {
    return _customizer.getInvalidLoginAttemptsTotalCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isInvalidLoginAttemptsTotalCountInherited)
   *
   * return true if the value of property InvalidLoginAttemptsTotalCount is inherited from template
   */
  public boolean isInvalidLoginAttemptsTotalCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isInvalidLoginAttemptsTotalCountSet)
   *
   * @xsdgen:isSetMethodFor invalid-login-attempts-total-count
   */
  public boolean isInvalidLoginAttemptsTotalCountSet() {
    return _isSet(3);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setInvalidLoginAttemptsTotalCount)
   *
   */
  public void setInvalidLoginAttemptsTotalCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _InvalidLoginAttemptsTotalCount = param0;
  }

  /**
   * Returns the number of invalid logins attempted since this server
 has been started and lockouts have been enabled.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLoginAttemptsWhileLockedTotalCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getLoginAttemptsWhileLockedTotalCount() {
    try {
    return _customizer.getLoginAttemptsWhileLockedTotalCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLoginAttemptsWhileLockedTotalCountInherited)
   *
   * return true if the value of property LoginAttemptsWhileLockedTotalCount is inherited from template
   */
  public boolean isLoginAttemptsWhileLockedTotalCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLoginAttemptsWhileLockedTotalCountSet)
   *
   * @xsdgen:isSetMethodFor login-attempts-while-locked-total-count
   */
  public boolean isLoginAttemptsWhileLockedTotalCountSet() {
    return _isSet(4);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLoginAttemptsWhileLockedTotalCount)
   *
   */
  public void setLoginAttemptsWhileLockedTotalCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _LoginAttemptsWhileLockedTotalCount = param0;
  }

  /**
   * Returns the highest number of users with concurrent
 unexpired or uncleared invalid login attempts.

 Invalid login attempts expire as specified by <code>LockoutResetDuration</code>.
 This count is useful in determining whether the <code>LockoutCacheSize</code>
 needs to be modified.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getInvalidLoginUsersHighCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getInvalidLoginUsersHighCount() {
    try {
    return _customizer.getInvalidLoginUsersHighCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isInvalidLoginUsersHighCountInherited)
   *
   * return true if the value of property InvalidLoginUsersHighCount is inherited from template
   */
  public boolean isInvalidLoginUsersHighCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isInvalidLoginUsersHighCountSet)
   *
   * @xsdgen:isSetMethodFor invalid-login-users-high-count
   */
  public boolean isInvalidLoginUsersHighCountSet() {
    return _isSet(5);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setInvalidLoginUsersHighCount)
   *
   */
  public void setInvalidLoginUsersHighCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _InvalidLoginUsersHighCount = param0;
  }

  /**
   * Returns the number times users have been unlocked
 since this server has been started.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getUnlockedUsersTotalCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getUnlockedUsersTotalCount() {
    try {
    return _customizer.getUnlockedUsersTotalCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isUnlockedUsersTotalCountInherited)
   *
   * return true if the value of property UnlockedUsersTotalCount is inherited from template
   */
  public boolean isUnlockedUsersTotalCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isUnlockedUsersTotalCountSet)
   *
   * @xsdgen:isSetMethodFor unlocked-users-total-count
   */
  public boolean isUnlockedUsersTotalCountSet() {
    return _isSet(6);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setUnlockedUsersTotalCount)
   *
   */
  public void setUnlockedUsersTotalCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _UnlockedUsersTotalCount = param0;
  }

  /**
   * Returns the number of users that are currently locked out of this server.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockedUsersCurrentCount)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public long getLockedUsersCurrentCount() {
    try {
    return _customizer.getLockedUsersCurrentCount();
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockedUsersCurrentCountInherited)
   *
   * return true if the value of property LockedUsersCurrentCount is inherited from template
   */
  public boolean isLockedUsersCurrentCountInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockedUsersCurrentCountSet)
   *
   * @xsdgen:isSetMethodFor locked-users-current-count
   */
  public boolean isLockedUsersCurrentCountSet() {
    return _isSet(7);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockedUsersCurrentCount)
   *
   */
  public void setLockedUsersCurrentCount(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    _LockedUsersCurrentCount = param0;
  }

  /**
   * Returns the realm that contains this user lockout manager.
 Returns null if this security provider is not contained by a realm.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getRealm)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public weblogic.management.security.RealmMBean getRealm() {
    return _customizer.getRealm();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isRealmInherited)
   *
   * return true if the value of property Realm is inherited from template
   */
  public boolean isRealmInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isRealmSet)
   *
   * @xsdgen:isSetMethodFor realm
   */
  public boolean isRealmSet() {
    return _isSet(8);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setRealm)
   *
   */
  public void setRealm(weblogic.management.security.RealmMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
    _Realm = param0;
  }

  /**
   * Returns whether the server locks out users when there are invalid login attempts.

 A <code>true</code> value for this attribute causes the server to consider
 the other attributes of this MBean. A <code>false</code> value causes the server
 to ignore the other attributes of this MBean."
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutEnabled)
   *
   * @xsdgen:element.name lockout-enabled
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default true
   * @dynamic false
   */
  public boolean isLockoutEnabled() {
    return _LockoutEnabled;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutEnabledInherited)
   *
   * return true if the value of property LockoutEnabled is inherited from template
   */
  public boolean isLockoutEnabledInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutEnabledSet)
   *
   * @xsdgen:isSetMethodFor lockout-enabled
   */
  public boolean isLockoutEnabledSet() {
    return _isSet(9);
  }

  /**
   * Sets whether the server locks out users when there are invalid login attempts.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutEnabled)
   *
   */
  public void setLockoutEnabled(boolean param0)
    throws javax.management.InvalidAttributeValueException
  {
    boolean _oldVal = _LockoutEnabled;
    _LockoutEnabled = param0;
    _postSet(9, _oldVal, param0);
  }

  /**
   * Returns the maximum number of consecutive invalid login attempts before account is locked out.

 When the number of invalid logins within a specified period of time is greater than
 <code>LockoutThreshold</code>value, the user is locked out. For example,
 with the default setting of <code>1</code>, the user is locked out on the
 second consecutive invalid login. With a setting of <code>2</code>, the user
 is locked out on the third consecutive invalid login.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockoutThreshold)
   *
   * @xsdgen:element.name lockout-threshold
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 1
   * @xsdgen:element.maxInclusive 2147483647
   * @xsdgen:element.default 5
   * @dynamic false
   */
  public long getLockoutThreshold() {
    return _LockoutThreshold;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutThresholdInherited)
   *
   * return true if the value of property LockoutThreshold is inherited from template
   */
  public boolean isLockoutThresholdInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutThresholdSet)
   *
   * @xsdgen:isSetMethodFor lockout-threshold
   */
  public boolean isLockoutThresholdSet() {
    return _isSet(10);
  }

  /**
   * Sets the maximum number of consecutive invalid login attempts before account is locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutThreshold)
   *
   */
  public void setLockoutThreshold(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("LockoutThreshold", param0, 1, java.lang.Integer.MAX_VALUE);
    long _oldVal = _LockoutThreshold;
    _LockoutThreshold = param0;
    _postSet(10, _oldVal, param0);
  }

  /**
   * Returns the number of minutes that a user account is locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockoutDuration)
   *
   * @xsdgen:element.name lockout-duration
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.maxInclusive 2147483647
   * @xsdgen:element.default 30
   * @dynamic false
   */
  public long getLockoutDuration() {
    return _LockoutDuration;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutDurationInherited)
   *
   * return true if the value of property LockoutDuration is inherited from template
   */
  public boolean isLockoutDurationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutDurationSet)
   *
   * @xsdgen:isSetMethodFor lockout-duration
   */
  public boolean isLockoutDurationSet() {
    return _isSet(11);
  }

  /**
   * Sets the number of minutes that a user account is locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutDuration)
   *
   */
  public void setLockoutDuration(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("LockoutDuration", param0, 0, java.lang.Integer.MAX_VALUE);
    long _oldVal = _LockoutDuration;
    _LockoutDuration = param0;
    _postSet(11, _oldVal, param0);
  }

  /**
   * The number of minutes within which consecutive invalid login attempts cause the user account to be locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockoutResetDuration)
   *
   * @xsdgen:element.name lockout-reset-duration
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 1
   * @xsdgen:element.maxInclusive 2147483647
   * @xsdgen:element.default 5
   * @dynamic false
   */
  public long getLockoutResetDuration() {
    return _LockoutResetDuration;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutResetDurationInherited)
   *
   * return true if the value of property LockoutResetDuration is inherited from template
   */
  public boolean isLockoutResetDurationInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutResetDurationSet)
   *
   * @xsdgen:isSetMethodFor lockout-reset-duration
   */
  public boolean isLockoutResetDurationSet() {
    return _isSet(12);
  }

  /**
   * The number of minutes within which consecutive invalid login attempts cause the user account to be locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutResetDuration)
   *
   */
  public void setLockoutResetDuration(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("LockoutResetDuration", param0, 1, java.lang.Integer.MAX_VALUE);
    long _oldVal = _LockoutResetDuration;
    _LockoutResetDuration = param0;
    _postSet(12, _oldVal, param0);
  }

  /**
   * Returns the number of invalid login records that the server places in a cache.
 The server creates one record for each invalid login.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockoutCacheSize)
   *
   * @xsdgen:element.name lockout-cache-size
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.maxInclusive 2147483647
   * @xsdgen:element.default 5
   * @dynamic false
   */
  public long getLockoutCacheSize() {
    return _LockoutCacheSize;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutCacheSizeInherited)
   *
   * return true if the value of property LockoutCacheSize is inherited from template
   */
  public boolean isLockoutCacheSizeInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutCacheSizeSet)
   *
   * @xsdgen:isSetMethodFor lockout-cache-size
   */
  public boolean isLockoutCacheSizeSet() {
    return _isSet(13);
  }

  /**
   * Sets the number of invalid login records that the server places in a cache.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutCacheSize)
   *
   */
  public void setLockoutCacheSize(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("LockoutCacheSize", param0, 0, java.lang.Integer.MAX_VALUE);
    long _oldVal = _LockoutCacheSize;
    _LockoutCacheSize = param0;
    _postSet(13, _oldVal, param0);
  }

  /**
   * <p>Returns the maximum number of invalid login records that the server keeps in memory.</p>

 <p>If the number of invalid login records is equal to or greater than this value,
 the server's garbage collection purges the records that have expired.
 A record expires when the user associated with the record has been locked out.</p>
 
 <p>The lower the threshold, the more often the server uses its resources to collect garbage.</p>
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLockoutGCThreshold)
   *
   * @xsdgen:element.name lockout-gc-threshold
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.maxInclusive 2147483647
   * @xsdgen:element.default 400
   * @dynamic false
   */
  public long getLockoutGCThreshold() {
    return _LockoutGCThreshold;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutGCThresholdInherited)
   *
   * return true if the value of property LockoutGCThreshold is inherited from template
   */
  public boolean isLockoutGCThresholdInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockoutGCThresholdSet)
   *
   * @xsdgen:isSetMethodFor lockout-gc-threshold
   */
  public boolean isLockoutGCThresholdSet() {
    return _isSet(14);
  }

  /**
   * Sets the maximum number of invalid login records that the server keeps in memory.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setLockoutGCThreshold)
   *
   */
  public void setLockoutGCThreshold(long param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkInRange("LockoutGCThreshold", param0, 0, java.lang.Integer.MAX_VALUE);
    long _oldVal = _LockoutGCThreshold;
    _LockoutGCThreshold = param0;
    _postSet(14, _oldVal, param0);
  }

  /**
   * Indicates whether a user is locked out.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isLockedOut)
   *
   */
  public boolean isLockedOut(String param0) {
    try {
    return _customizer.isLockedOut(param0);
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Unlocks a user account.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=clearLockout)
   *
   */
  public void clearLockout(String param0) {
    try {
    _customizer.clearLockout(param0);
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns a string that indicates the time of the last invalid login for this user.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLastLoginFailure)
   *
   */
  public long getLastLoginFailure(String param0) {
    try {
    return _customizer.getLastLoginFailure(param0);
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * Returns the current count of login failures for a specific user. This value returns to
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getLoginFailureCount)
   *
   */
  public long getLoginFailureCount(String param0) {
    try {
    return _customizer.getLoginFailureCount(param0);
    } catch (javax.management.MBeanException e) {
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * The name of this configuration. WebLogic Server uses an MBean to
 implement and persist the configuration.
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getName)
   *
   * @xsdgen:element.name name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default UserLockoutManager
   * @dynamic false
   */
  public String getName() {
    return _Name;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isNameInherited)
   *
   * return true if the value of property Name is inherited from template
   */
  public boolean isNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isNameSet)
   *
   * @xsdgen:isSetMethodFor name
   */
  public boolean isNameSet() {
    return _isSet(15);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setName)
   *
   */
  public void setName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _Name;
    _Name = param0;
    _postSet(15, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=getCompatibilityObjectName)
   *
   * @xsdgen:element.name compatibility-object-name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getCompatibilityObjectName() {
    return _customizer.getCompatibilityObjectName();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isCompatibilityObjectNameInherited)
   *
   * return true if the value of property CompatibilityObjectName is inherited from template
   */
  public boolean isCompatibilityObjectNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=isCompatibilityObjectNameSet)
   *
   * @xsdgen:isSetMethodFor compatibility-object-name
   */
  public boolean isCompatibilityObjectNameSet() {
    return _isSet(16);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=setCompatibilityObjectName)
   *
   */
  public void setCompatibilityObjectName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _CompatibilityObjectName;
    _CompatibilityObjectName = param0;
    _postSet(16, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.authentication.UserLockoutManagerMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 16;
    }
    try {
      switch (idx) {
      case 16:
        _CompatibilityObjectName = null;
        if (initOne) break;
      case 3:
        _InvalidLoginAttemptsTotalCount = 0;
        if (initOne) break;
      case 5:
        _InvalidLoginUsersHighCount = 0;
        if (initOne) break;
      case 7:
        _LockedUsersCurrentCount = 0;
        if (initOne) break;
      case 13:
        _LockoutCacheSize = 5;
        if (initOne) break;
      case 11:
        _LockoutDuration = 30;
        if (initOne) break;
      case 14:
        _LockoutGCThreshold = 400;
        if (initOne) break;
      case 12:
        _LockoutResetDuration = 5;
        if (initOne) break;
      case 10:
        _LockoutThreshold = 5;
        if (initOne) break;
      case 4:
        _LoginAttemptsWhileLockedTotalCount = 0;
        if (initOne) break;
      case 15:
        _Name = "UserLockoutManager";
        if (initOne) break;
      case 8:
        _Realm = null;
        if (initOne) break;
      case 6:
        _UnlockedUsersTotalCount = 0;
        if (initOne) break;
      case 2:
        _UserLockoutTotalCount = 0;
        if (initOne) break;
      case 9:
        _LockoutEnabled = true;
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private UserLockoutManagerMBeanImpl bean;

    protected Helper(UserLockoutManagerMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 16: return "CompatibilityObjectName";
      case 3: return "InvalidLoginAttemptsTotalCount";
      case 5: return "InvalidLoginUsersHighCount";
      case 7: return "LockedUsersCurrentCount";
      case 13: return "LockoutCacheSize";
      case 11: return "LockoutDuration";
      case 14: return "LockoutGCThreshold";
      case 12: return "LockoutResetDuration";
      case 10: return "LockoutThreshold";
      case 4: return "LoginAttemptsWhileLockedTotalCount";
      case 15: return "Name";
      case 8: return "Realm";
      case 6: return "UnlockedUsersTotalCount";
      case 2: return "UserLockoutTotalCount";
      case 9: return "LockoutEnabled";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("CompatibilityObjectName")) return 16;
      else if (propName.equals("InvalidLoginAttemptsTotalCount")) return 3;
      else if (propName.equals("InvalidLoginUsersHighCount")) return 5;
      else if (propName.equals("LockedUsersCurrentCount")) return 7;
      else if (propName.equals("LockoutCacheSize")) return 13;
      else if (propName.equals("LockoutDuration")) return 11;
      else if (propName.equals("LockoutGCThreshold")) return 14;
      else if (propName.equals("LockoutResetDuration")) return 12;
      else if (propName.equals("LockoutThreshold")) return 10;
      else if (propName.equals("LoginAttemptsWhileLockedTotalCount")) return 4;
      else if (propName.equals("Name")) return 15;
      else if (propName.equals("Realm")) return 8;
      else if (propName.equals("UnlockedUsersTotalCount")) return 6;
      else if (propName.equals("UserLockoutTotalCount")) return 2;
      else if (propName.equals("LockoutEnabled")) return 9;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isCompatibilityObjectNameSet()){
          buf.append("CompatibilityObjectName");
          buf.append(String.valueOf(bean.getCompatibilityObjectName()));
        }
        if (bean.isInvalidLoginAttemptsTotalCountSet()){
          buf.append("InvalidLoginAttemptsTotalCount");
          buf.append(String.valueOf(bean.getInvalidLoginAttemptsTotalCount()));
        }
        if (bean.isInvalidLoginUsersHighCountSet()){
          buf.append("InvalidLoginUsersHighCount");
          buf.append(String.valueOf(bean.getInvalidLoginUsersHighCount()));
        }
        if (bean.isLockedUsersCurrentCountSet()){
          buf.append("LockedUsersCurrentCount");
          buf.append(String.valueOf(bean.getLockedUsersCurrentCount()));
        }
        if (bean.isLockoutCacheSizeSet()){
          buf.append("LockoutCacheSize");
          buf.append(String.valueOf(bean.getLockoutCacheSize()));
        }
        if (bean.isLockoutDurationSet()){
          buf.append("LockoutDuration");
          buf.append(String.valueOf(bean.getLockoutDuration()));
        }
        if (bean.isLockoutGCThresholdSet()){
          buf.append("LockoutGCThreshold");
          buf.append(String.valueOf(bean.getLockoutGCThreshold()));
        }
        if (bean.isLockoutResetDurationSet()){
          buf.append("LockoutResetDuration");
          buf.append(String.valueOf(bean.getLockoutResetDuration()));
        }
        if (bean.isLockoutThresholdSet()){
          buf.append("LockoutThreshold");
          buf.append(String.valueOf(bean.getLockoutThreshold()));
        }
        if (bean.isLoginAttemptsWhileLockedTotalCountSet()){
          buf.append("LoginAttemptsWhileLockedTotalCount");
          buf.append(String.valueOf(bean.getLoginAttemptsWhileLockedTotalCount()));
        }
        if (bean.isNameSet()){
          buf.append("Name");
          buf.append(String.valueOf(bean.getName()));
        }
        if (bean.isRealmSet()){
          buf.append("Realm");
          buf.append(String.valueOf(bean.getRealm()));
        }
        if (bean.isUnlockedUsersTotalCountSet()){
          buf.append("UnlockedUsersTotalCount");
          buf.append(String.valueOf(bean.getUnlockedUsersTotalCount()));
        }
        if (bean.isUserLockoutTotalCountSet()){
          buf.append("UserLockoutTotalCount");
          buf.append(String.valueOf(bean.getUserLockoutTotalCount()));
        }
        if (bean.isLockoutEnabledSet()){
          buf.append("LockoutEnabled");
          buf.append(String.valueOf(bean.isLockoutEnabled()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      UserLockoutManagerMBeanImpl otherTyped = (UserLockoutManagerMBeanImpl)other;
      computeDiff("CompatibilityObjectName", bean.getCompatibilityObjectName(), otherTyped.getCompatibilityObjectName(), false);
      computeDiff("LockoutCacheSize", bean.getLockoutCacheSize(), otherTyped.getLockoutCacheSize(), false);
      computeDiff("LockoutDuration", bean.getLockoutDuration(), otherTyped.getLockoutDuration(), false);
      computeDiff("LockoutGCThreshold", bean.getLockoutGCThreshold(), otherTyped.getLockoutGCThreshold(), false);
      computeDiff("LockoutResetDuration", bean.getLockoutResetDuration(), otherTyped.getLockoutResetDuration(), false);
      computeDiff("LockoutThreshold", bean.getLockoutThreshold(), otherTyped.getLockoutThreshold(), false);
      computeDiff("Name", bean.getName(), otherTyped.getName(), false);
      computeDiff("LockoutEnabled", bean.isLockoutEnabled(), otherTyped.isLockoutEnabled(), false);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        UserLockoutManagerMBeanImpl original = (UserLockoutManagerMBeanImpl)event.getSourceBean();
        UserLockoutManagerMBeanImpl proposed = (UserLockoutManagerMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("CompatibilityObjectName")) {
          original._conditionalUnset(update.isUnsetUpdate(), 16);
        } else
        if (prop.equals("InvalidLoginAttemptsTotalCount")) {
        } else
        if (prop.equals("InvalidLoginUsersHighCount")) {
        } else
        if (prop.equals("LockedUsersCurrentCount")) {
        } else
        if (prop.equals("LockoutCacheSize")) {
          original.setLockoutCacheSize(proposed.getLockoutCacheSize());
          original._conditionalUnset(update.isUnsetUpdate(), 13);
        } else
        if (prop.equals("LockoutDuration")) {
          original.setLockoutDuration(proposed.getLockoutDuration());
          original._conditionalUnset(update.isUnsetUpdate(), 11);
        } else
        if (prop.equals("LockoutGCThreshold")) {
          original.setLockoutGCThreshold(proposed.getLockoutGCThreshold());
          original._conditionalUnset(update.isUnsetUpdate(), 14);
        } else
        if (prop.equals("LockoutResetDuration")) {
          original.setLockoutResetDuration(proposed.getLockoutResetDuration());
          original._conditionalUnset(update.isUnsetUpdate(), 12);
        } else
        if (prop.equals("LockoutThreshold")) {
          original.setLockoutThreshold(proposed.getLockoutThreshold());
          original._conditionalUnset(update.isUnsetUpdate(), 10);
        } else
        if (prop.equals("LoginAttemptsWhileLockedTotalCount")) {
        } else
        if (prop.equals("Name")) {
          original.setName(proposed.getName());
          original._conditionalUnset(update.isUnsetUpdate(), 15);
        } else
        if (prop.equals("Realm")) {
        } else
        if (prop.equals("UnlockedUsersTotalCount")) {
        } else
        if (prop.equals("UserLockoutTotalCount")) {
        } else
        if (prop.equals("LockoutEnabled")) {
          original.setLockoutEnabled(proposed.isLockoutEnabled());
          original._conditionalUnset(update.isUnsetUpdate(), 9);
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        UserLockoutManagerMBeanImpl copy = (UserLockoutManagerMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("CompatibilityObjectName")) && bean.isCompatibilityObjectNameSet()) {
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutCacheSize")) && bean.isLockoutCacheSizeSet()) {
          copy.setLockoutCacheSize((long)bean.getLockoutCacheSize());
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutDuration")) && bean.isLockoutDurationSet()) {
          copy.setLockoutDuration((long)bean.getLockoutDuration());
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutGCThreshold")) && bean.isLockoutGCThresholdSet()) {
          copy.setLockoutGCThreshold((long)bean.getLockoutGCThreshold());
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutResetDuration")) && bean.isLockoutResetDurationSet()) {
          copy.setLockoutResetDuration((long)bean.getLockoutResetDuration());
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutThreshold")) && bean.isLockoutThresholdSet()) {
          copy.setLockoutThreshold((long)bean.getLockoutThreshold());
        }
        if ((excludeProps == null || !excludeProps.contains("Name")) && bean.isNameSet()) {
          copy.setName((String)bean.getName());
        }
        if ((excludeProps == null || !excludeProps.contains("LockoutEnabled")) && bean.isLockoutEnabledSet()) {
          copy.setLockoutEnabled((boolean)bean.isLockoutEnabled());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
                                  		inferSubTree(bean.getRealm(), clazz, annotation);
                }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 25:
        if (false) return -1;
        else if (s.equals("compatibility-object-name"))
          return 16;
        break;
      case 34:
        if (false) return -1;
        else if (s.equals("invalid-login-attempts-total-count"))
          return 3;
        break;
      case 30:
        if (false) return -1;
        else if (s.equals("invalid-login-users-high-count"))
          return 5;
        break;
      case 26:
        if (false) return -1;
        else if (s.equals("locked-users-current-count"))
          return 7;
        else if (s.equals("unlocked-users-total-count"))
          return 6;
        break;
      case 18:
        if (false) return -1;
        else if (s.equals("lockout-cache-size"))
          return 13;
        break;
      case 16:
        if (false) return -1;
        else if (s.equals("lockout-duration"))
          return 11;
        break;
      case 19:
        if (false) return -1;
        else if (s.equals("lockoutgc-threshold"))
          return 14;
        break;
      case 22:
        if (false) return -1;
        else if (s.equals("lockout-reset-duration"))
          return 12;
        break;
      case 17:
        if (false) return -1;
        else if (s.equals("lockout-threshold"))
          return 10;
        break;
      case 39:
        if (false) return -1;
        else if (s.equals("login-attempts-while-locked-total-count"))
          return 4;
        break;
      case 4:
        if (false) return -1;
        else if (s.equals("name"))
          return 15;
        break;
      case 5:
        if (false) return -1;
        else if (s.equals("realm"))
          return 8;
        break;
      case 24:
        if (false) return -1;
        else if (s.equals("user-lockout-total-count"))
          return 2;
        break;
      case 15:
        if (false) return -1;
        else if (s.equals("lockout-enabled"))
          return 9;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 16: return "compatibility-object-name";
        case 3: return "invalid-login-attempts-total-count";
        case 5: return "invalid-login-users-high-count";
        case 7: return "locked-users-current-count";
        case 13: return "lockout-cache-size";
        case 11: return "lockout-duration";
        case 14: return "lockoutgc-threshold";
        case 12: return "lockout-reset-duration";
        case 10: return "lockout-threshold";
        case 4: return "login-attempts-while-locked-total-count";
        case 15: return "name";
        case 8: return "realm";
        case 6: return "unlocked-users-total-count";
        case 2: return "user-lockout-total-count";
        case 9: return "lockout-enabled";
        default: return super.getElementName(propIndex);
      }
    }






    public boolean isBean(int propIndex) {
      switch(propIndex) {
      default:
        return super.isBean(propIndex);
      }
    }










  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.authentication.UserLockoutManagerMBean"; 
  }

}
